/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.xml.maven.catalog;

import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;

public class ChmLogger {
    private final Log log;
    private Map<LogReason, Boolean> enabled = new HashMap<LogReason, Boolean>();

    public ChmLogger(Log log) {
        this.log = log;
    }

    public void log(LogReason reason, LogLevel level, String message) {
        if (this.isEnabled(reason)) {
            level.log(this.log, reason.toString() + ": " + message);
        }
    }

    public void enableReason(LogReason reason, boolean value) {
        this.enabled.put(reason, value);
    }

    private boolean isEnabled(LogReason reason) {
        Boolean ret = this.enabled.get((Object)reason);
        return ret != null ? ret : false;
    }

    public static enum LogLevel {
        DEBUG("DEBUG", new BiConsumer<Log, String>(){

            @Override
            public void accept(Log log, String s) {
                log.debug((CharSequence)s);
            }
        }),
        INFO("INFO", new BiConsumer<Log, String>(){

            @Override
            public void accept(Log log, String s) {
                log.info((CharSequence)s);
            }
        }),
        WARN("WARN", new BiConsumer<Log, String>(){

            @Override
            public void accept(Log log, String s) {
                log.warn((CharSequence)s);
            }
        }),
        ERROR("ERROR", new BiConsumer<Log, String>(){

            @Override
            public void accept(Log log, String s) {
                log.error((CharSequence)s);
            }
        });

        private final BiConsumer<Log, String> logger;
        private final String name;

        private LogLevel(String name, BiConsumer<Log, String> logger) {
            this.name = name;
            this.logger = logger;
        }

        private void log(Log log, String message) {
            this.logger.accept(log, message);
        }

        private static interface BiConsumer<T, U> {
            public void accept(T var1, U var2);
        }
    }

    public static enum LogReason {
        VISITING,
        EXCLUSION,
        MATCHES,
        PARAMETERS,
        CLASSPATH,
        DEPENDENCY;


        public String toString() {
            return this.name();
        }
    }
}

