/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.maven.gaulois.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.XMLFilterImpl;
import top.marchand.maven.gaulois.compiler.FileSet;
import top.marchand.maven.gaulois.compiler.utils.GauloisConfigScanner;
import top.marchand.xml.maven.plugin.xsl.AbstractCompiler;

@Mojo(name="gaulois-compiler", defaultPhase=LifecyclePhase.COMPILE)
public class GCMojo
extends AbstractCompiler {
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classesDirectory;
    @Parameter
    List<FileSet> gauloisPipeFilesets;
    @Parameter
    private File catalog;
    @Parameter(defaultValue="${project.basedir}")
    private File projectBaseDir;
    private XsltExecutable gauloisCompilerXsl;
    @Parameter
    List<File> xslSourceDirs;
    public static final SAXParserFactory PARSER_FACTORY = SAXParserFactory.newInstance();
    private static final String LOG_PREFIX = "[gaulois-compiler]";
    private static final String ERROR_MESSAGE = "<gauloisPipeFilesets>\n\t<gauloisPipeFileset>\n\t\t<dir>src/main/xsl...</dir>\n\t</gauloisPipeFileset>\n</gauloisPipeFilesets>\n is required in gaulois-compiler-maven-plugin configuration";

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.gauloisPipeFilesets == null) {
            this.getLog().error((CharSequence)"[gaulois-compiler]\n<gauloisPipeFilesets>\n\t<gauloisPipeFileset>\n\t\t<dir>src/main/xsl...</dir>\n\t</gauloisPipeFileset>\n</gauloisPipeFilesets>\n is required in gaulois-compiler-maven-plugin configuration");
            throw new MojoExecutionException(ERROR_MESSAGE);
        }
        if (this.xslSourceDirs == null) {
            this.xslSourceDirs = new ArrayList<File>();
        }
        if (this.xslSourceDirs.isEmpty()) {
            this.xslSourceDirs.add(new File(this.projectBaseDir, "src/main/xsl"));
        }
        Log log = this.getLog();
        this.initSaxon();
        Path targetDir = this.classesDirectory.toPath();
        boolean hasError = false;
        HashMap<File, File> gauloisConfigToCompile = new HashMap<File, File>();
        HashMap<Source, File> xslToCompile = new HashMap<Source, File>();
        this.getLog().debug((CharSequence)"[gaulois-compiler] looking for gaulois-pipe config files");
        for (FileSet fs : this.gauloisPipeFilesets) {
            Path basedir = new File(fs.getDir()).toPath();
            this.getLog().debug((CharSequence)("looking in " + basedir.toString()));
            for (Path p : fs.getFiles(log)) {
                this.getLog().debug((CharSequence)("found " + p.toString()));
                File sourceFile = basedir.resolve(p).toFile();
                Path targetPath = p.getParent() == null ? targetDir : targetDir.resolve(p.getParent());
                String sourceFileName = sourceFile.getName();
                File targetFile = targetPath.resolve(sourceFileName).toFile();
                gauloisConfigToCompile.put(sourceFile, targetFile);
                hasError |= this.scanGauloisFile(sourceFile, targetFile, gauloisConfigToCompile, xslToCompile, targetDir);
            }
        }
        if (!hasError) {
            for (Object xslSource : xslToCompile.keySet()) {
                try {
                    this.getLog().debug((CharSequence)("compiling " + xslSource.getSystemId()));
                    this.compileFile((Source)xslSource, (File)xslToCompile.get(xslSource));
                }
                catch (FileNotFoundException | SaxonApiException ex) {
                    this.getLog().warn((CharSequence)("while compiling " + xslSource.getSystemId()), ex);
                    hasError = true;
                }
            }
            StreamSource xsl = new StreamSource(((Object)((Object)this)).getClass().getResourceAsStream("/top/marchand/maven/gaulois/compiler/gaulois-compiler.xsl"));
            try {
                this.gauloisCompilerXsl = this.getXsltCompiler().compile((Source)xsl);
                for (File gSrc : gauloisConfigToCompile.keySet()) {
                    this.getLog().debug((CharSequence)("compiling " + gSrc.getAbsolutePath()));
                    this.compileGaulois(gSrc, (File)gauloisConfigToCompile.get(gSrc));
                }
            }
            catch (Exception ex) {
                hasError = true;
                this.getLog().error((Throwable)ex);
            }
        } else {
            this.getLog().warn((CharSequence)"[gaulois-compiler] Errors occured");
        }
    }

    public File getCatalogFile() {
        return this.catalog;
    }

    protected boolean scanGauloisFile(File sourceFile, File targetFile, Map<File, File> gauloisConfigToCompile, Map<Source, File> xslToCompile, Path targetDir) {
        try {
            ParserAdapter reader = new ParserAdapter(PARSER_FACTORY.newSAXParser().getParser());
            final GauloisConfigScanner scanner = new GauloisConfigScanner(this.xslSourceDirs, this.classesDirectory, this.getUriResolver(), this.getLog());
            XMLFilterImpl filter = new XMLFilterImpl(reader){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                    super.startElement(uri, localName, qName, atts);
                    scanner.startElement(uri, localName, qName, atts);
                }
            };
            filter.parse(sourceFile.getAbsolutePath());
            if (scanner.hasErrors()) {
                for (String errorMsg : scanner.getErrorMessages()) {
                    this.getLog().error((CharSequence)errorMsg);
                }
            } else {
                xslToCompile.putAll(scanner.getXslToCompile());
                gauloisConfigToCompile.put(sourceFile, targetFile);
            }
            return scanner.hasErrors();
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            this.getLog().error((CharSequence)("while scanning " + sourceFile.getAbsolutePath()), (Throwable)ex);
            return true;
        }
    }

    protected void compileGaulois(File source, File target) throws SaxonApiException {
        XsltTransformer tr = this.gauloisCompilerXsl.load();
        Serializer ser = this.getProcessor().newSerializer(target);
        tr.setDestination((Destination)ser);
        XdmNode sourceNode = this.getBuilder().build(source);
        tr.setInitialContextNode(sourceNode);
        tr.transform();
        tr.close();
    }
}

