/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.maven.gaulois.compiler.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public class GauloisConfigScanner
extends DefaultHandler2 {
    public static final String GAULOIS_NS = "http://efl.fr/chaine/saxon-pipe/config";
    boolean hasError = false;
    private final List<File> xslDirectories;
    private final File outputDirectory;
    private final Map<Source, File> xslToCompile;
    private final List<String> errors;
    private final URIResolver resolver;
    private int uriErrorCount = 0;
    private final Log log;

    public GauloisConfigScanner(List<File> xslDirectories, File outputDirectory, URIResolver resolver, Log log) {
        this.xslDirectories = xslDirectories;
        this.outputDirectory = outputDirectory;
        this.resolver = resolver;
        this.log = log;
        this.xslToCompile = new HashMap<Source, File>();
        this.errors = new ArrayList<String>();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        block10: {
            super.startElement(uri, localName, qName, attributes);
            if (GAULOIS_NS.equals(uri) && "xslt".equals(localName)) {
                String href = attributes.getValue("href");
                this.log.debug((CharSequence)("found XSL: " + href));
                if (!href.startsWith("cp:/")) {
                    try {
                        Source source = this.resolver.resolve(href, "");
                        this.log.debug((CharSequence)("source is a " + source.getClass().getName()));
                        String systemId = source.getSystemId();
                        String xslPath = systemId.contains("!") ? systemId.substring(systemId.indexOf("!") + 1) : systemId;
                        this.log.debug((CharSequence)("xslPath=" + xslPath));
                        String shortPath = FilenameUtils.getPath((String)xslPath);
                        this.log.debug((CharSequence)("shortPath=" + shortPath));
                        String baseName = FilenameUtils.getBaseName((String)xslPath);
                        this.log.debug((CharSequence)("baseName=" + baseName));
                        String targetPath = shortPath.concat(baseName).concat(".sef");
                        this.log.debug((CharSequence)("targetPath=" + targetPath));
                        File targetXsl = new File(this.outputDirectory, targetPath);
                        this.xslToCompile.put(source, targetXsl);
                    }
                    catch (NullPointerException | TransformerException ex) {
                        this.hasError = true;
                        if (this.uriErrorCount >= 10) break block10;
                        this.errors.add(href + " is an invalid URI. Only URI based on cp:/ protocol are supported, or the one that can be resolved via the catalog");
                        ++this.uriErrorCount;
                    }
                } else if (href.startsWith("cp:/")) {
                    String path = href.substring(4);
                    this.log.debug((CharSequence)("searching for xsl " + path));
                    boolean found = false;
                    for (File dir : this.xslDirectories) {
                        File xsl = new File(dir, path);
                        if (xsl.exists() && xsl.isFile()) {
                            this.log.debug((CharSequence)("\tfound at " + xsl.getAbsolutePath()));
                            String shortPath = FilenameUtils.getPath((String)path);
                            String baseName = FilenameUtils.getBaseName((String)path);
                            String targetPath = shortPath.concat(baseName).concat(".sef");
                            File targetXsl = new File(this.outputDirectory, targetPath);
                            try {
                                InputSource is = new InputSource(new FileInputStream(xsl));
                                String systemID = xsl.toURI().toString();
                                is.setPublicId(systemID);
                                SAXSource ss = new SAXSource(is);
                                ss.setSystemId(systemID);
                                this.xslToCompile.put(ss, targetXsl);
                                found = true;
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                // empty catch block
                            }
                        }
                        if (!found) continue;
                        break;
                    }
                }
            }
        }
    }

    public boolean hasErrors() {
        return this.hasError;
    }

    public List<String> getErrorMessages() {
        return this.errors;
    }

    public Map<Source, File> getXslToCompile() {
        return this.xslToCompile;
    }
}

