/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.maven.gaulois.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.MessageListener;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmMap;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.trans.XPathException;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.XMLFilterImpl;
import top.marchand.maven.gaulois.compiler.FileSet;
import top.marchand.maven.gaulois.compiler.utils.GauloisConfigScanner;
import top.marchand.maven.gaulois.compiler.utils.GauloisSet;
import top.marchand.maven.gaulois.compiler.utils.GauloisXsl;
import top.marchand.maven.saxon.utils.SaxonOptions;
import top.marchand.xml.maven.plugin.xsl.AbstractCompiler;

@Mojo(name="gaulois-compiler", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class GCMojo
extends AbstractCompiler {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classesDirectory;
    @Parameter
    List<FileSet> gauloisPipeFilesets;
    @Parameter
    private File catalog;
    @Parameter(defaultValue="${project.basedir}")
    private File projectBaseDir;
    @Parameter(defaultValue="${project.build.outputDirectory}/gc/schemas")
    private File schemasDestination;
    @Parameter
    private File postCompiler;
    @Parameter
    SaxonOptions saxonOptions;
    private XsltExecutable postCompilerXsl;
    private XsltExecutable gauloisCompilerXsl;
    private XsltExecutable xutScanner;
    private XsltExecutable xutFilter;
    @Parameter
    List<File> xslSourceDirs;
    private Set<GauloisSet> gauloisSets;
    private Map<String, GauloisXsl> foundXsls;
    public static final SAXParserFactory PARSER_FACTORY = SAXParserFactory.newInstance();
    private ArrayList<String> classpaths;
    private static final String XUT_NS = "https://github.com/mricaud/xml-utilities";
    private static final QName QN_DEP_TYPE = new QName("dependency-type");
    private static final QName QN_URI = new QName("uri");
    private static final QName QN_ABS_URI = new QName("abs-uri");
    private static final QName QN_NAME = new QName("name");
    private static final QName QN_PARAM_SCHEMAS = new QName("schemas");
    private static final QName QN_PARAM_XSLMAP = new QName("xslMap");
    private static final QName QN_TARGET_PATH = new QName("targetPath");
    private static final String LOG_PREFIX = "[gaulois-compiler]";
    private static final String ERROR_MESSAGE = "<gauloisPipeFilesets>\n\t<gauloisPipeFileset>\n\t\t<dir>src/main/xsl...</dir>\n\t</gauloisPipeFileset>\n</gauloisPipeFilesets>\n is required in gaulois-compiler-maven-plugin configuration";

    public MavenProject getProject() {
        return this.project;
    }

    public DependencyGraphBuilder getGraphBuilder() {
        return this.dependencyGraphBuilder;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.gauloisPipeFilesets == null) {
            this.getLog().error((CharSequence)"[gaulois-compiler]\n<gauloisPipeFilesets>\n\t<gauloisPipeFileset>\n\t\t<dir>src/main/xsl...</dir>\n\t</gauloisPipeFileset>\n</gauloisPipeFilesets>\n is required in gaulois-compiler-maven-plugin configuration");
            throw new MojoExecutionException(ERROR_MESSAGE);
        }
        if (this.xslSourceDirs == null) {
            this.xslSourceDirs = new ArrayList<File>();
        }
        if (this.xslSourceDirs.isEmpty()) {
            this.xslSourceDirs.add(new File(this.projectBaseDir, "src/main/xsl"));
        }
        Log log = this.getLog();
        try {
            this.initSaxon();
        }
        catch (XPathException ex) {
            this.getLog().error((CharSequence)"while configuring saxon:", (Throwable)ex);
        }
        this.loadClasspath();
        this.gauloisSets = new TreeSet<GauloisSet>();
        this.foundXsls = new HashMap<String, GauloisXsl>();
        ThreadLocal<EntityResolver2> th = new ThreadLocal<EntityResolver2>();
        th.set(this.getEntityResolver());
        this.getLog().warn((CharSequence)(LOG_PREFIX + this.getXsltCompiler().getProcessor().getUnderlyingConfiguration().getSourceParserClass()));
        try {
            URL url = ((Object)((Object)this)).getClass().getResource("/org/mricaud/xml-utilities/get-xml-file-static-dependency-tree.xsl");
            StreamSource ssource = new StreamSource(url.openStream());
            ssource.setSystemId(url.toExternalForm());
            this.xutScanner = this.getXsltCompiler().compile((Source)ssource);
            this.xutFilter = this.getXsltCompiler().compile((Source)new StreamSource(((Object)((Object)this)).getClass().getResource("/top/marchand/maven/gaulois/compiler/schema-filter.xsl").openStream()));
        }
        catch (IOException | SaxonApiException ex) {
            throw new MojoFailureException("while compiling xut xsl", ex);
        }
        Path targetDir = this.classesDirectory.toPath();
        boolean hasError = false;
        this.getLog().debug((CharSequence)"[gaulois-compiler] looking for gaulois-pipe config files");
        for (Object fs : this.gauloisPipeFilesets) {
            if (fs.getUri() != null && !fs.getUri().isEmpty()) {
                try {
                    Source source = this.compiler.getURIResolver().resolve(fs.getUri(), null);
                    String sPath = fs.getUriPath();
                    this.getLog().debug((CharSequence)("[gaulois-compiler] sPath=" + sPath));
                    Path targetPath = targetDir.resolve(sPath).getParent();
                    this.getLog().debug((CharSequence)("[gaulois-compiler] targetPath=" + targetPath.toString()));
                    String sourceFileName = sPath.substring(sPath.lastIndexOf("/") + 1);
                    if (sourceFileName.contains("?")) {
                        sourceFileName = sourceFileName.substring(0, sourceFileName.indexOf("?") - 1);
                    }
                    File targetFile = targetPath.resolve(sourceFileName).toFile();
                    this.getLog().debug((CharSequence)("[gaulois-compiler] targetFile=" + targetFile.getAbsolutePath()));
                    hasError |= this.scanGauloisFile(source, targetFile, targetDir);
                }
                catch (URISyntaxException | TransformerException ex) {
                    hasError = true;
                    this.getLog().error((CharSequence)("while parsing " + fs.getUri()), (Throwable)ex);
                }
                continue;
            }
            List pathes = fs.getFiles(this.projectBaseDir, log);
            Path basedir = new File(fs.getDir()).toPath();
            this.getLog().debug((CharSequence)("[gaulois-compiler]looking in " + basedir.toString()));
            for (Path p : pathes) {
                this.getLog().debug((CharSequence)("[gaulois-compiler]found " + p.toString()));
                File sourceFile = basedir.resolve(p).toFile();
                Path targetPath = p.getParent() == null ? targetDir : targetDir.resolve(p.getParent());
                String sourceFileName = sourceFile.getName();
                File targetFile = targetPath.resolve(sourceFileName).toFile();
                try {
                    hasError |= this.scanGauloisFile(sourceFile, targetFile, targetDir);
                }
                catch (FileNotFoundException | URISyntaxException ex) {
                    hasError = true;
                    this.getLog().error((CharSequence)("[gaulois-compiler]while parsing " + p.toString()), (Throwable)ex);
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        for (GauloisXsl gx : this.foundXsls.values()) {
            sb.append(gx.getXslSystemId()).append("->").append(gx.getTargetFile().getAbsolutePath()).append("\n");
        }
        this.getLog().debug((CharSequence)("Found XSL: " + sb.toString()));
        if (!hasError) {
            for (String xslSystemId : this.foundXsls.keySet()) {
                try {
                    this.getLog().debug((CharSequence)("[gaulois-compiler] compiling " + xslSystemId));
                    StreamSource xslSource = new StreamSource(xslSystemId);
                    File targetFile = this.foundXsls.get(xslSystemId).getTargetFile();
                    this.compileFile(xslSource, targetFile);
                }
                catch (FileNotFoundException | SaxonApiException ex) {
                    this.getLog().warn((CharSequence)("[gaulois-compiler] while compiling " + xslSystemId), ex);
                }
            }
            StreamSource xsl = new StreamSource(((Object)((Object)this)).getClass().getResourceAsStream("/top/marchand/maven/gaulois/compiler/gaulois-compiler.xsl"));
            try {
                this.gauloisCompilerXsl = this.getXsltCompiler().compile((Source)xsl);
                XdmMap xslMap = this.buildXslMap(this.foundXsls);
                for (GauloisSet gs : this.gauloisSets) {
                    this.getLog().debug((CharSequence)("[gaulois-compiler] compiling " + gs.getGauloisConfigSystemId()));
                    this.compileGaulois(new StreamSource(gs.getGauloisConfigSystemId()), gs.getTargetFile(), gs.getAllSchemas(), xslMap);
                }
            }
            catch (SaxonApiException ex) {
                this.getLog().error((Throwable)ex);
            }
        } else {
            this.getLog().warn((CharSequence)"[gaulois-compiler] Errors occured");
        }
    }

    private XdmMap buildXslMap(Map<String, GauloisXsl> xsls) {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        for (GauloisXsl gx : xsls.values()) {
            tempMap.put(gx.getOriginalSystemId(), gx.getTargetFile().getAbsolutePath());
        }
        return XdmMap.makeMap(tempMap);
    }

    public File getCatalogFile() {
        return this.catalog;
    }

    protected boolean scanGauloisFile(File sourceFile, File targetFile, Path targetDir) throws FileNotFoundException, URISyntaxException {
        String systemId = sourceFile.toURI().toString();
        this.getLog().debug((CharSequence)("scanGauloisFile(" + systemId + ",File, Path);"));
        InputSource is = new InputSource(new FileInputStream(sourceFile));
        is.setSystemId(systemId);
        SAXSource source = new SAXSource(is);
        source.setSystemId(systemId);
        return this.scanGauloisFile(source, targetFile, targetDir);
    }

    protected boolean scanGauloisFile(Source source, File targetFile, Path targetDir) throws URISyntaxException {
        assert (source.getSystemId() != null);
        try {
            ParserAdapter reader = new ParserAdapter(PARSER_FACTORY.newSAXParser().getParser());
            final GauloisConfigScanner scanner = new GauloisConfigScanner(this.xslSourceDirs, this.classesDirectory, this.getUriResolver(), this.getLog(), this.classpaths);
            XMLFilterImpl filter = new XMLFilterImpl(reader){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                    super.startElement(uri, localName, qName, atts);
                    scanner.startElement(uri, localName, qName, atts);
                }
            };
            filter.parse(source.getSystemId());
            if (scanner.hasErrors()) {
                for (String errorMsg : scanner.getErrorMessages()) {
                    this.getLog().error((CharSequence)errorMsg);
                }
            } else {
                GauloisSet set = new GauloisSet(source.getSystemId(), targetFile);
                if (!this.gauloisSets.contains(set)) {
                    this.gauloisSets.add(set);
                    for (Source xslSource : scanner.getXslToCompile().keySet()) {
                        GauloisXsl xsl = this.foundXsls.get(xslSource.getSystemId());
                        if (xsl == null) {
                            GauloisConfigScanner.FileInfo fileInfo = scanner.getXslToCompile().get(xslSource);
                            xsl = new GauloisXsl(xslSource.getSystemId(), fileInfo.getFile(), fileInfo.getOriginalSystemId());
                            this.foundXsls.put(xslSource.getSystemId(), xsl);
                            this.scanForSchemas(xsl);
                        }
                        set.getXsls().add(xsl);
                    }
                }
            }
            return scanner.hasErrors();
        }
        catch (IOException | ParserConfigurationException | SaxonApiException | SAXException ex) {
            this.getLog().error((CharSequence)("while scanning " + source.getSystemId()), ex);
            return true;
        }
    }

    protected void compileGaulois(Source source, File target, Set<String> schemas, XdmMap xslMap) throws SaxonApiException {
        XsltTransformer tr = this.gauloisCompilerXsl.load();
        tr.setURIResolver(this.getUriResolver());
        ArrayList<XdmAtomicValue> values = new ArrayList<XdmAtomicValue>();
        for (String schema : schemas) {
            this.getLog().info((CharSequence)(LOG_PREFIX + target.getName() + " has schema: " + schema));
            values.add(new XdmAtomicValue(schema));
        }
        XdmValue sequence = new XdmValue(values);
        tr.setMessageListener(new MessageListener(){

            public void message(XdmNode xn, boolean bln, SourceLocator sl) {
                GCMojo.this.getLog().debug((CharSequence)xn.toString());
            }
        });
        tr.setParameter(QN_PARAM_SCHEMAS, sequence);
        tr.setParameter(QN_PARAM_XSLMAP, (XdmValue)xslMap);
        tr.setParameter(QN_TARGET_PATH, XdmValue.makeValue((Object)this.classesDirectory.getAbsolutePath()));
        XsltTransformer first = tr;
        XsltTransformer pc = this.getPostCompiler();
        if (pc != null) {
            tr.setDestination((Destination)pc);
            tr = pc;
        }
        Serializer ser = this.getProcessor().newSerializer(target);
        tr.setDestination((Destination)ser);
        XdmNode sourceNode = this.getBuilder().build(source);
        first.setInitialContextNode(sourceNode);
        first.transform();
        first.close();
    }

    protected XsltTransformer getPostCompiler() {
        if (this.postCompilerXsl == null && this.postCompiler != null && this.postCompiler.exists() && this.postCompiler.isFile()) {
            try {
                this.postCompilerXsl = this.getXsltCompiler().compile((Source)new StreamSource(new FileInputStream(this.postCompiler)));
            }
            catch (FileNotFoundException | SaxonApiException ex) {
                this.getLog().error((CharSequence)("while compiling post-compiler " + this.postCompiler.getAbsolutePath()), ex);
            }
        }
        return this.postCompilerXsl == null ? null : this.postCompilerXsl.load();
    }

    protected void scanForSchemas(GauloisXsl xsl) throws SaxonApiException, URISyntaxException, IOException {
        this.getLog().debug((CharSequence)("[gaulois-compiler] scanning for schema " + xsl.getXslSystemId()));
        XsltTransformer xut = this.xutScanner.load();
        xut.setMessageListener((MessageListener)new NullMessageListener());
        XsltTransformer filter = this.xutFilter.load();
        xut.setDestination((Destination)filter);
        XdmDestination dest = new XdmDestination();
        filter.setDestination((Destination)dest);
        xut.setMessageListener(new MessageListener(){

            public void message(XdmNode xn, boolean bln, SourceLocator sl) {
            }
        });
        XdmNode xslDocument = this.getBuilder().build((Source)new StreamSource(xsl.getXslSystemId()));
        xut.setInitialContextNode(xslDocument);
        xut.setParameter(new QName(XUT_NS, "xut:get-xml-file-static-dependency-tree.filterDuplicatedDependencies"), (XdmValue)new XdmAtomicValue(true));
        xut.transform();
        XdmNode dependencies = dest.getXdmNode();
        XdmNode file = (XdmNode)dependencies.axisIterator(Axis.CHILD).next();
        XdmSequenceIterator xsi = file.axisIterator(Axis.CHILD);
        while (xsi.hasNext()) {
            this.exploreFile(xsl, (XdmNode)xsi.next());
        }
    }

    private void exploreFile(GauloisXsl xsl, XdmNode node) throws URISyntaxException, IOException {
        String dependencyType = node.getAttributeValue(QN_DEP_TYPE);
        String absUri = node.getAttributeValue(QN_ABS_URI);
        this.getLog().debug((CharSequence)("[gaulois-compiler]\texploreFile <" + node.getNodeName() + " " + QN_DEP_TYPE.toString() + "=" + dependencyType + " absUri=" + absUri));
        if (dependencyType.equals("xsl:import-schema")) {
            String uri = node.getAttributeValue(QN_URI);
            String name = node.getAttributeValue(QN_NAME);
            SchemaTarget targetSchema = this.getTargetSchemaFile(name, absUri);
            xsl.getSchemas().add(targetSchema.getAccessUri());
            this.getLog().debug((CharSequence)("[gaulois-compiler]\turi is " + absUri));
            this.copyUriToFile(absUri, targetSchema.getFileLocation());
            XdmSequenceIterator it = node.axisIterator(Axis.CHILD);
            while (it.hasNext()) {
                XdmNode schemaNode = (XdmNode)it.next();
                this.copySubSchema(targetSchema.getFileLocation(), schemaNode);
            }
        }
    }

    private void copySubSchema(File parent, XdmNode schemaNode) throws URISyntaxException, IOException {
        String uri = schemaNode.getAttributeValue(QN_URI);
        String absUri = schemaNode.getAttributeValue(QN_ABS_URI);
        File schemaFile = parent.toPath().resolve(uri).toFile();
        this.copyFile(new File(new URI(absUri)), schemaFile);
        XdmSequenceIterator it = schemaNode.axisIterator(Axis.CHILD);
        while (it.hasNext()) {
            XdmNode subSchemaNode = (XdmNode)it.next();
            this.copySubSchema(schemaFile, subSchemaNode);
        }
    }

    private SchemaTarget getTargetSchemaFile(String name, String absUri) {
        File destSchema = new File(this.getSchemasDestination(), name);
        Path p = this.classesDirectory.toPath().relativize(destSchema.toPath());
        String accessUri = "cp:/" + p.toString().replaceAll("\\\\", "/");
        return new SchemaTarget(accessUri, destSchema);
    }

    private void copyFile(File source, File dest) throws IOException {
        dest.getParentFile().mkdirs();
        try (FileChannel in = new FileInputStream(source).getChannel();
             FileChannel out = new FileOutputStream(dest).getChannel();){
            in.transferTo(0L, in.size(), out);
        }
    }

    private void copyUriToFile(String uri, File dest) throws IOException, URISyntaxException {
        dest.getParentFile().mkdirs();
        URL url = new URI(uri).toURL();
        InputStream is = url.openStream();
        try (ReadableByteChannel in = Channels.newChannel(is);
             FileChannel out = new FileOutputStream(dest).getChannel();){
            long size = 5120L;
            long offset = 0L;
            long vol = out.transferFrom(in, 0L, 5120L);
            while (vol == 5120L) {
                vol = out.transferFrom(in, offset += vol, 5120L);
            }
        }
    }

    private void loadClasspath() {
        try {
            this.classpaths = new ArrayList(this.project.getCompileClasspathElements().size());
            for (Object i : this.project.getCompileClasspathElements()) {
                File f = new File(i.toString());
                this.classpaths.add(f.toURI().toString());
            }
            this.getLog().debug((CharSequence)("[gaulois-compiler]classpaths=" + this.classpaths));
        }
        catch (DependencyResolutionRequiredException ex) {
            this.getLog().error((CharSequence)(LOG_PREFIX + ex.getMessage()), (Throwable)ex);
        }
    }

    public File getSchemasDestination() {
        return this.schemasDestination;
    }

    public SaxonOptions getSaxonOptions() {
        return this.saxonOptions;
    }

    private class NullMessageListener
    implements MessageListener {
        private NullMessageListener() {
        }

        public void message(XdmNode xn, boolean bln, SourceLocator sl) {
        }
    }

    private class SchemaTarget {
        private final String accessUri;
        private final File fileLocation;

        public SchemaTarget(String accessUri, File fileLocation) {
            this.accessUri = accessUri;
            this.fileLocation = fileLocation;
        }

        public String getAccessUri() {
            return this.accessUri;
        }

        public File getFileLocation() {
            return this.fileLocation;
        }
    }
}

