/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.maven.gaulois.compiler.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public class GauloisConfigScanner
extends DefaultHandler2 {
    public static final String GAULOIS_NS = "http://efl.fr/chaine/saxon-pipe/config";
    boolean hasError = false;
    private final List<File> xslDirectories;
    private final File outputDirectory;
    private final Map<Source, FileInfo> xslToCompile;
    private final List<String> errors;
    private final URIResolver resolver;
    private int uriErrorCount = 0;
    private final Log log;
    private final List<String> classpathes;

    public GauloisConfigScanner(List<File> xslDirectories, File outputDirectory, URIResolver resolver, Log log, List<String> classpathes) {
        this.xslDirectories = xslDirectories;
        this.outputDirectory = outputDirectory;
        this.resolver = resolver;
        this.log = log;
        this.classpathes = classpathes;
        this.xslToCompile = new HashMap<Source, FileInfo>();
        this.errors = new ArrayList<String>();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        block21: {
            super.startElement(uri, localName, qName, attributes);
            if (GAULOIS_NS.equals(uri) && "xslt".equals(localName)) {
                String href = attributes.getValue("href");
                this.log.debug((CharSequence)("found XSL: " + href));
                if (!href.startsWith("cp:/")) {
                    try {
                        Source source = this.resolver.resolve(href, "");
                        this.log.debug((CharSequence)("source is a " + source.getClass().getName()));
                        String systemId = source.getSystemId();
                        String xslPath = systemId.contains("!") ? systemId.substring(systemId.indexOf("!") + 1) : systemId;
                        this.log.debug((CharSequence)("xslPath=" + xslPath));
                        String shortPath = FilenameUtils.getPath((String)xslPath);
                        this.log.debug((CharSequence)("shortPath=" + shortPath));
                        String baseName = FilenameUtils.getBaseName((String)xslPath);
                        this.log.debug((CharSequence)("baseName=" + baseName));
                        String targetPath = shortPath.concat(baseName).concat(".sef");
                        this.log.debug((CharSequence)("targetPath=" + targetPath));
                        File targetXsl = new File(this.outputDirectory, targetPath);
                        this.xslToCompile.put(source, new FileInfo(targetXsl, href));
                    }
                    catch (NullPointerException | TransformerException ex) {
                        this.hasError = true;
                        if (this.uriErrorCount < 10) {
                            this.errors.add(href + " is an invalid URI. Only URI based on cp:/ protocol are supported, or the one that can be resolved via the catalog");
                            ++this.uriErrorCount;
                        }
                        break block21;
                    }
                }
                if (href.startsWith("cp:/")) {
                    boolean found;
                    block22: {
                        File targetXsl;
                        String targetPath;
                        String baseName;
                        String shortPath;
                        String path = href.substring(4);
                        this.log.debug((CharSequence)("searching for xsl " + path));
                        found = false;
                        for (File dir : this.xslDirectories) {
                            File xsl = new File(dir, path);
                            if (xsl.exists() && xsl.isFile()) {
                                this.log.debug((CharSequence)("\tfound at " + xsl.getAbsolutePath()));
                                shortPath = FilenameUtils.getPath((String)path);
                                baseName = FilenameUtils.getBaseName((String)path);
                                targetPath = shortPath.concat(baseName).concat(".sef");
                                targetXsl = new File(this.outputDirectory, targetPath);
                                try {
                                    InputSource is = new InputSource(new FileInputStream(xsl));
                                    String systemID = xsl.toURI().toString();
                                    is.setPublicId(systemID);
                                    SAXSource ss = new SAXSource(is);
                                    ss.setSystemId(systemID);
                                    this.xslToCompile.put(ss, new FileInfo(targetXsl, href));
                                    found = true;
                                }
                                catch (FileNotFoundException is) {
                                    // empty catch block
                                }
                            }
                            if (!found) continue;
                            break;
                        }
                        if (!found) {
                            try {
                                Source source = this.resolver.resolve(href, "");
                                if (source != null) {
                                    this.log.debug((CharSequence)("source is a " + source.getClass().getName()));
                                    String systemId = source.getSystemId();
                                    String xslPath = systemId.contains("!") ? systemId.substring(systemId.indexOf("!") + 1) : systemId;
                                    this.log.debug((CharSequence)("xslPath=" + xslPath));
                                    shortPath = FilenameUtils.getPath((String)xslPath);
                                    this.log.debug((CharSequence)("shortPath=" + shortPath));
                                    baseName = FilenameUtils.getBaseName((String)xslPath);
                                    this.log.debug((CharSequence)("baseName=" + baseName));
                                    targetPath = shortPath.concat(baseName).concat(".sef");
                                    this.log.debug((CharSequence)("targetPath=" + targetPath));
                                    targetXsl = new File(this.outputDirectory, targetPath);
                                    this.xslToCompile.put(source, new FileInfo(targetXsl, href));
                                    found = true;
                                }
                            }
                            catch (NullPointerException | TransformerException ex) {
                                this.hasError = true;
                                if (this.uriErrorCount >= 10) break block22;
                                this.errors.add(href + " is an invalid URI. Only URI based on cp:/ protocol are supported, or the one that can be resolved via the catalog");
                                ++this.uriErrorCount;
                            }
                        }
                    }
                    if (!found) {
                        this.log.debug((CharSequence)("searching for " + href + " in classpath"));
                        for (String cp : this.classpathes) {
                            try {
                                URL url;
                                InputStream is;
                                String systemId = cp;
                                if (systemId.endsWith(".jar")) {
                                    systemId = "jar:" + systemId;
                                }
                                if ((is = (url = new URL(systemId = systemId + "!" + href.substring(3))).openStream()) == null) continue;
                                this.log.debug((CharSequence)("systemId=" + systemId));
                                String xslPath = systemId.contains("!") ? systemId.substring(systemId.indexOf("!") + 1) : systemId;
                                this.log.debug((CharSequence)("xslPath=" + xslPath));
                                String shortPath = FilenameUtils.getPath((String)xslPath);
                                this.log.debug((CharSequence)("shortPath=" + shortPath));
                                String baseName = FilenameUtils.getBaseName((String)xslPath);
                                this.log.debug((CharSequence)("baseName=" + baseName));
                                String targetPath = shortPath.concat(baseName).concat(".sef");
                                this.log.debug((CharSequence)("targetPath=" + targetPath));
                                File targetXsl = new File(this.outputDirectory, targetPath);
                                SAXSource source = new SAXSource(new InputSource(is));
                                source.setSystemId(systemId);
                                this.xslToCompile.put(source, new FileInfo(targetXsl, href));
                                found = true;
                            }
                            catch (FileNotFoundException systemId) {
                            }
                            catch (IOException ex) {
                                this.log.warn((CharSequence)("while searching " + href + "in classpath:"), (Throwable)ex);
                            }
                        }
                    }
                    if (!found) {
                        this.log.warn((CharSequence)(href + " could not be found ! It won't be compiled"));
                    }
                }
            }
        }
    }

    public boolean hasErrors() {
        return this.hasError;
    }

    public List<String> getErrorMessages() {
        return this.errors;
    }

    public Map<Source, FileInfo> getXslToCompile() {
        return this.xslToCompile;
    }

    public class FileInfo {
        private final File file;
        private final String originalSystemId;

        public FileInfo(File file, String originalSystemId) {
            this.file = file;
            this.originalSystemId = originalSystemId;
        }

        public File getFile() {
            return this.file;
        }

        public String getOriginalSystemId() {
            return this.originalSystemId;
        }
    }
}

