/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.maven.gaulois.compiler.utils;

import java.io.File;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import top.marchand.maven.gaulois.compiler.utils.GauloisXsl;

public class GauloisSet
implements Comparable<GauloisSet> {
    private final String gauloisConfigSystemId;
    private final Set<GauloisXsl> xsls;
    private final File targetFile;

    public GauloisSet(String systemId, File targetFile) {
        this.gauloisConfigSystemId = systemId;
        this.targetFile = targetFile;
        this.xsls = new TreeSet<GauloisXsl>();
    }

    public String getGauloisConfigSystemId() {
        return this.gauloisConfigSystemId;
    }

    public Set<GauloisXsl> getXsls() {
        return this.xsls;
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    public Set<String> getAllSchemas() {
        TreeSet<String> ret = new TreeSet<String>();
        for (GauloisXsl gx : this.getXsls()) {
            ret.addAll(gx.getSchemas());
        }
        return ret;
    }

    @Override
    public int compareTo(GauloisSet o) {
        return this.gauloisConfigSystemId.compareTo(o.getGauloisConfigSystemId());
    }

    public boolean equals(Object obj) {
        if (obj instanceof GauloisSet) {
            return this.gauloisConfigSystemId.equals(((GauloisSet)obj).getGauloisConfigSystemId());
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 13 * hash + Objects.hashCode(this.gauloisConfigSystemId);
        return hash;
    }
}

