/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.maven.artifact.resolver.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.ArtifactCoordinate;
import org.apache.maven.shared.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.dependencies.DefaultDependableCoordinate;
import org.apache.maven.shared.dependencies.DependableCoordinate;
import org.codehaus.plexus.util.StringUtils;

public class ArtifactResolverUtils {
    private static final Pattern ALT_REPO_SYNTAX_PATTERN = Pattern.compile("(.+)::(.*)::(.+)");
    private final Map<String, ArtifactRepositoryLayout> repositoryLayouts;
    private final List<ArtifactRepository> repoList;
    private final List<ArtifactRepository> pomRemoteRepositories;
    private final MavenSession session;
    private final ArtifactResolver artifactResolver;
    private final ArtifactHandlerManager artifactHandlerManager;

    public ArtifactResolverUtils(MavenSession session, ArtifactResolver artifactResolver, ArtifactHandlerManager artifactHandlerManager, Map<String, ArtifactRepositoryLayout> repositoryLayouts, List<ArtifactRepository> pomRemoteRepositories) {
        this.session = session;
        this.artifactResolver = artifactResolver;
        this.artifactHandlerManager = artifactHandlerManager;
        this.repositoryLayouts = repositoryLayouts;
        this.repoList = new ArrayList<ArtifactRepository>();
        this.pomRemoteRepositories = pomRemoteRepositories;
    }

    public final void constructRepoList(String remoteRepositories) throws MojoFailureException {
        ArtifactRepositoryPolicy always = new ArtifactRepositoryPolicy(true, "always", "warn");
        if (this.pomRemoteRepositories != null) {
            this.repoList.addAll(this.pomRemoteRepositories);
        }
        if (remoteRepositories != null) {
            List<String> repos = Arrays.asList(StringUtils.split((String)remoteRepositories, (String)","));
            for (String repo : repos) {
                this.repoList.add(this.parseRepository(repo, always));
            }
        }
    }

    public Artifact resolveArtifact(DefaultDependableCoordinate coordinate) throws ArtifactResolverException {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setRemoteRepositories(this.repoList);
        ArtifactResult artifactResult = this.artifactResolver.resolveArtifact((ProjectBuildingRequest)buildingRequest, this.toArtifactCoordinate((DependableCoordinate)coordinate));
        Artifact foundArtifact = artifactResult.getArtifact();
        return foundArtifact;
    }

    private ArtifactCoordinate toArtifactCoordinate(DependableCoordinate dependableCoordinate) {
        ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(dependableCoordinate.getType());
        DefaultArtifactCoordinate artifactCoordinate = new DefaultArtifactCoordinate();
        artifactCoordinate.setGroupId(dependableCoordinate.getGroupId());
        artifactCoordinate.setArtifactId(dependableCoordinate.getArtifactId());
        artifactCoordinate.setVersion(dependableCoordinate.getVersion());
        artifactCoordinate.setClassifier(dependableCoordinate.getClassifier());
        artifactCoordinate.setExtension(artifactHandler.getExtension());
        return artifactCoordinate;
    }

    protected ArtifactRepository parseRepository(String repo, ArtifactRepositoryPolicy policy) throws MojoFailureException {
        String id = "temp";
        ArtifactRepositoryLayout layout = this.getLayout("default");
        String url = repo;
        if (repo.contains("::")) {
            Matcher matcher = ALT_REPO_SYNTAX_PATTERN.matcher(repo);
            if (!matcher.matches()) {
                throw new MojoFailureException((Object)repo, "Invalid syntax for repository: " + repo, "Invalid syntax for repository. Use \"id::layout::url\" or \"URL\".");
            }
            id = matcher.group(1).trim();
            if (!StringUtils.isEmpty((String)matcher.group(2))) {
                layout = this.getLayout(matcher.group(2).trim());
            }
            url = matcher.group(3).trim();
        }
        return new MavenArtifactRepository(id, url, layout, policy, policy);
    }

    private ArtifactRepositoryLayout getLayout(String id) throws MojoFailureException {
        ArtifactRepositoryLayout layout = this.repositoryLayouts.get(id);
        if (layout == null) {
            throw new MojoFailureException((Object)id, "Invalid repository layout", "Invalid repository layout: " + id);
        }
        return layout;
    }
}

