/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.xml.maven.servers.utils;

import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Server;
import org.codehaus.plexus.PlexusContainer;
import top.marchand.xml.maven.servers.utils.ServerInformation;

public class MavenServerUtils {
    private final PlexusContainer container;
    private final MavenSession session;
    private static final String SECURITY_DISPATCHER_CLASS_NAME = "org.sonatype.plexus.components.sec.dispatcher.SecDispatcher";

    public MavenServerUtils(MavenSession session, PlexusContainer container) {
        this.session = session;
        this.container = container;
    }

    public ServerInformation getServerAuthentication(String serverId) throws MojoExecutionException {
        if (serverId == null || serverId.isEmpty()) {
            throw new MojoExecutionException("server parameter is required");
        }
        Server settingsServer = this.session.getSettings().getServer(serverId);
        if (settingsServer == null) {
            throw new MojoExecutionException("Server " + serverId + " is unknown. It should be defined in your settings.xml.");
        }
        String password = this.decryptInlinePasswords(settingsServer.getPassword());
        return new ServerInformation(settingsServer.getUsername(), password);
    }

    private String decryptInlinePasswords(String v) {
        Pattern p = Pattern.compile("(\\{[^\\}]+\\})");
        Matcher m = p.matcher(v);
        StringBuffer s = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(s, this.decryptPassword(m.group(1)));
        }
        m.appendTail(s);
        return s.toString();
    }

    private String decryptPassword(String password) {
        try {
            Class<?> securityDispatcherClass = this.container.getClass().getClassLoader().loadClass(SECURITY_DISPATCHER_CLASS_NAME);
            Object securityDispatcher = this.container.lookup(SECURITY_DISPATCHER_CLASS_NAME, "maven");
            Method decrypt = securityDispatcherClass.getMethod("decrypt", String.class);
            return ((String)decrypt.invoke(securityDispatcher, password)).replace("$", "\\$");
        }
        catch (Exception exception) {
            return password;
        }
    }
}

