/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.xml.maven.oxygenBeautifier;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltTransformer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="beautify", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class BeautifierMojo
extends AbstractMojo {
    @Component
    public MavenProject project;
    @Parameter(defaultValue="false")
    public boolean activateXslLogs;
    @Parameter(defaultValue="false")
    public boolean keepOldFiles;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File baseDir = this.project.getBasedir();
        Processor processor = new Processor(Configuration.newConfiguration());
        try {
            XsltTransformer xsl = processor.newXsltCompiler().compile((Source)new StreamSource(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("top/marchand/xml/maven/oxygenBeautifier/projectBeautifier.xsl"))).load();
            xsl.setParameter(new QName("debug.reorder.xpr"), (XdmValue)new XdmAtomicValue(this.isActivateXslLogs()));
            for (File f : this.getOxygenProjectFiles(baseDir)) {
                String filename = f.getName();
                File originFile = new File(baseDir, this.getOriginFileName(filename));
                f.renameTo(originFile);
                xsl.setSource((Source)new StreamSource(originFile));
                xsl.setDestination((Destination)processor.newSerializer(new File(baseDir, filename)));
                xsl.transform();
                if (this.keepOldFiles) continue;
                originFile.delete();
            }
        }
        catch (SaxonApiException ex) {
            this.getLog().error((CharSequence)"Unable to load beautifier XSL");
            throw new MojoFailureException("Unable to load beautifier XSL", (Throwable)ex);
        }
    }

    private String getOriginFileName(String filename) {
        String mainPart = filename.substring(0, filename.length() - 4);
        return mainPart.concat("-origin.xpr_");
    }

    private List<File> getOxygenProjectFiles(File dir) {
        return Arrays.asList(dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xpr");
            }
        }));
    }

    public boolean isActivateXslLogs() {
        return this.activateXslLogs;
    }
}

