/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.maven.saxon.utils;

import net.sf.saxon.Configuration;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.trans.XPathException;
import top.marchand.maven.saxon.utils.SaxonOptions;

public class SaxonUtils {
    public static void prepareSaxonConfiguration(Processor processor, SaxonOptions saxonOptions) throws XPathException {
        Configuration config = processor.getUnderlyingConfiguration();
        if (saxonOptions != null) {
            Object resolver;
            String value;
            if (saxonOptions.getXi() != null) {
                processor.setConfigurationProperty("http://saxon.sf.net/feature/xinclude-aware", (Object)"on".equals(saxonOptions.getXi()));
            }
            if ((value = saxonOptions.getWarnings()) != null) {
                if ("silent".equals(value)) {
                    processor.setConfigurationProperty("http://saxon.sf.net/feature/recoveryPolicy", (Object)0);
                } else if ("recover".equals(value)) {
                    processor.setConfigurationProperty("http://saxon.sf.net/feature/recoveryPolicy", (Object)1);
                } else if ("fatal".equals(value)) {
                    processor.setConfigurationProperty("http://saxon.sf.net/feature/recoveryPolicy", (Object)2);
                }
            }
            if ((value = saxonOptions.getVal()) != null) {
                if ("strict".equals(value)) {
                    processor.setConfigurationProperty("http://saxon.sf.net/feature/schema-validation", (Object)1);
                } else if ("lax".equals(value)) {
                    processor.setConfigurationProperty("http://saxon.sf.net/feature/schema-validation", (Object)2);
                }
            }
            if ((value = saxonOptions.getTree()) != null) {
                if ("linked".equals(value)) {
                    config.setTreeModel(0);
                } else if ("tiny".equals(value)) {
                    config.setTreeModel(1);
                } else if ("tinyc".equals(value)) {
                    config.setTreeModel(2);
                }
            }
            if ((value = saxonOptions.getCollectionFinderClass()) != null) {
                resolver = config.getInstance(value, null);
                processor.setConfigurationProperty("http://saxon.sf.net/feature/collection-finder", resolver);
            }
            if ((value = saxonOptions.getDtd()) != null) {
                if ("on".equals(value)) {
                    config.getParseOptions().setDTDValidationMode(1);
                } else if ("off".equals(value)) {
                    config.getParseOptions().setDTDValidationMode(4);
                } else if ("recover".equals(value)) {
                    config.getParseOptions().setDTDValidationMode(2);
                }
            }
            if ((value = saxonOptions.getEa()) != null) {
                config.getDefaultXsltCompilerInfo().setAssertionsEnabled("on".equals(value));
            }
            if ((value = saxonOptions.getExpand()) != null) {
                config.getParseOptions().setExpandAttributeDefaults("on".equals(value));
            }
            if ((value = saxonOptions.getExt()) != null) {
                config.setBooleanProperty("http://saxon.sf.net/feature/allow-external-functions", "on".equals(value));
            }
            if ((value = saxonOptions.getL()) != null) {
                config.setBooleanProperty("http://saxon.sf.net/feature/linenumbering", "on".equals(value));
            }
            if ((value = saxonOptions.getM()) != null) {
                config.setConfigurationProperty("http://saxon.sf.net/feature/messageEmitterClass", (Object)value);
            }
            if ((value = saxonOptions.getOpt()) != null) {
                config.setConfigurationProperty("http://saxon.sf.net/feature/optimizationLevel", (Object)value);
            }
            if ((value = saxonOptions.getOr()) != null) {
                resolver = config.getInstance(value, null);
                config.setConfigurationProperty("http://saxon.sf.net/feature/outputURIResolver", resolver);
            }
            if ((value = saxonOptions.getOutval()) != null) {
                Boolean isRecover = "recover".equals(value);
                config.setConfigurationProperty("http://saxon.sf.net/feature/validation-warnings", (Object)isRecover);
                config.setConfigurationProperty("http://saxon.sf.net/feature/validation-comments", (Object)isRecover);
            }
            if ((value = saxonOptions.getStrip()) != null) {
                config.setConfigurationProperty("http://saxon.sf.net/feature/strip-whitespace", (Object)value);
            }
            if ((value = saxonOptions.getT()) != null) {
                config.setCompileWithTracing(true);
            }
            if ((value = saxonOptions.getTJ()) != null) {
                config.setBooleanProperty("http://saxon.sf.net/feature/trace-external-functions", "on".equals(value));
            }
        }
    }
}

