/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.maven.saxon.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;

public class SaxonOptions {
    private String collectionFinderClass;
    private String dtd;
    private String ea;
    private String expand;
    private String ext;
    private String l;
    private String m;
    private String opt;
    private String or;
    private String outval;
    private String r;
    private String relocate;
    private String strip;
    private String T;
    private String TJ;
    private String tree;
    private String val;
    private String warnings;
    private String xi;
    public static final String SAXON_CONFIG_PROPERTY = " Saxon Configuration Property";

    public void setCollectionFinderClass(String collectionFinderClass) {
        this.collectionFinderClass = collectionFinderClass;
    }

    public void setDtd(String dtd) {
        this.dtd = dtd;
    }

    public void setEa(String ea) {
        this.ea = ea;
    }

    public void setExpand(String expand) {
        this.expand = expand;
    }

    public void setExt(String ext) {
        this.ext = ext;
    }

    public void setL(String l) {
        this.l = l;
    }

    public void setM(String m) {
        this.m = m;
    }

    public void setOpt(String opt) {
        this.opt = opt;
    }

    public void setOr(String or) {
        this.or = or;
    }

    public void setOutval(String outval) {
        this.outval = outval;
    }

    public void setR(String r) {
        this.r = r;
    }

    public void setStrip(String strip) {
        this.strip = strip;
    }

    public void setT(String T) {
        this.T = T;
    }

    public void setTJ(String TJ) {
        this.TJ = TJ;
    }

    public void setTree(String tree) {
        this.tree = tree;
    }

    public void setVal(String val) {
        this.val = val;
    }

    public void setWarnings(String warnings) {
        this.warnings = warnings;
    }

    public void setXi(String xi) {
        this.xi = xi;
    }

    public void setRelocate(String relocate) {
        this.relocate = relocate;
    }

    protected void checkValue(String optionName, String value, String ... vals) throws IllegalArgumentException {
        boolean isValid = false;
        for (String v : vals) {
            isValid = isValid || v.equals(value);
        }
        if (!isValid) {
            throw new IllegalArgumentException("Only " + Arrays.toString(vals) + " are valid values for " + optionName + SAXON_CONFIG_PROPERTY);
        }
    }

    public String getCollectionFinderClass() {
        return this.collectionFinderClass;
    }

    public String getDtd() throws IllegalArgumentException {
        if (this.dtd == null) {
            return null;
        }
        this.checkValue("dtd", this.dtd, "on", "off", "recover");
        return this.dtd;
    }

    public String getEa() throws IllegalArgumentException {
        if (this.ea == null) {
            return null;
        }
        this.checkValue("ea", this.ea, "on", "off");
        return this.ea;
    }

    public String getExpand() throws IllegalArgumentException {
        if (this.expand == null) {
            return null;
        }
        this.checkValue("expand", this.expand, "on", "off");
        return this.expand;
    }

    public String getExt() throws IllegalArgumentException {
        if (this.ext == null) {
            return null;
        }
        this.checkValue("ext", this.ext, "on", "off");
        return this.ext;
    }

    public String getL() throws IllegalArgumentException {
        if (this.l == null) {
            return null;
        }
        this.checkValue("l", this.l, "on", "off");
        return this.l;
    }

    public String getM() {
        return this.m;
    }

    public String getR() {
        return this.r;
    }

    public String getOpt() {
        return this.opt;
    }

    public String getOr() {
        return this.or;
    }

    public String getOutval() throws IllegalArgumentException {
        if (this.outval == null) {
            return null;
        }
        this.checkValue("outval", this.outval, "recover", "fatal");
        return this.outval;
    }

    public String getRelocate() throws IllegalArgumentException {
        if (this.relocate == null) {
            return null;
        }
        this.checkValue("relocate", this.relocate, "on", "off");
        return this.relocate;
    }

    public String getStrip() throws IllegalArgumentException {
        if (this.strip == null) {
            return null;
        }
        this.checkValue("strip", this.strip, "all", "none", "ignorable");
        return this.strip;
    }

    public String getT() throws IllegalArgumentException {
        if (this.T == null) {
            return null;
        }
        this.checkValue("T", this.T, "on", "off");
        return this.T;
    }

    public String getTJ() throws IllegalArgumentException {
        if (this.TJ == null) {
            return null;
        }
        this.checkValue("TJ", this.TJ, "on", "off");
        return this.TJ;
    }

    public String getTree() throws IllegalArgumentException {
        if (this.tree == null) {
            return null;
        }
        this.checkValue("tree", this.tree, "linked", "tiny", "tinyc");
        return this.tree;
    }

    public String getVal() throws IllegalArgumentException {
        if (this.val == null) {
            return null;
        }
        this.checkValue("val", this.val, "strict", "lax");
        return this.val;
    }

    public String getWarnings() throws IllegalArgumentException {
        if (this.warnings == null) {
            return null;
        }
        this.checkValue("warnings", this.warnings, "silent", "recover", "fatal");
        return this.warnings;
    }

    public String getXi() throws IllegalArgumentException {
        if (this.xi == null) {
            return null;
        }
        this.checkValue("xi", this.xi, "on", "off");
        return this.xi;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.printf("SaxonOptions[\n\tcollectionFinderClass=%s\n\tdtd=%s\n\tea=%s\n\texpand=%s\n\text=%s\n\tL=%s\n\tm=%s\n\topt=%s\n\tor=%s\n\toutval=%s\n\tr=%s\n\tstrip=%s\n\tT=%s\n\tTJ=%s\n\ttree=%s\n\tval=%s\n\twarnings=%s\n\txi=%s\n]", this.getCollectionFinderClass(), this.getDtd(), this.getEa(), this.getExpand(), this.getExt(), this.getL(), this.getM(), this.getOpt(), this.getOr(), this.getOutval(), this.getR(), this.getStrip(), this.getT(), this.getTJ(), this.getTree(), this.getVal(), this.getWarnings(), this.getXi());
        pw.flush();
        return sw.getBuffer().toString();
    }
}

