/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.xml.maven.plugin.xsl.scandir;

import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import top.marchand.xml.maven.plugin.xsl.FileSet;

public class DirectoryScanner {
    private final File baseDir;
    private final List<String> includes;
    private final List<String> excludes;
    private final Log log;
    private transient List<PathMatcher> includeMatchers;
    private transient List<PathMatcher> excludeMatchers;
    private transient boolean isToRecurse;
    private transient Path basePath;

    public DirectoryScanner(File baseDir, Log log) {
        this.baseDir = baseDir;
        this.includes = FileSet.getDefaultIncludes();
        this.excludes = FileSet.getDefaultExcludes();
        this.log = log;
    }

    public DirectoryScanner(FileSet fileset, Log log) {
        this.baseDir = new File(fileset.getDir());
        this.includes = fileset.getIncludes();
        this.excludes = fileset.getExcludes();
        this.log = log;
    }

    public List<Path> scan() {
        this.prepareFilters();
        return this.scan(this.baseDir);
    }

    protected void prepareFilters() {
        FileSystem fs = FileSystems.getDefault();
        this.includeMatchers = new ArrayList<PathMatcher>(this.includes.size());
        for (String include : this.includes) {
            this.includeMatchers.add(this.buildPathMatcher(fs, include));
            if (!include.contains("**")) continue;
            this.isToRecurse = true;
        }
        this.excludeMatchers = new ArrayList<PathMatcher>(this.excludes.size());
        for (String exclude : this.excludes) {
            this.excludeMatchers.add(this.buildPathMatcher(fs, exclude));
        }
        this.basePath = this.baseDir.toPath().normalize();
    }

    private PathMatcher buildPathMatcher(FileSystem fs, String pattern) {
        String _pattern = pattern.startsWith("glob:") || pattern.startsWith("regex:") ? pattern : "glob:" + pattern;
        return fs.getPathMatcher(_pattern);
    }

    protected List<Path> scan(File dir) {
        ArrayList<Path> ret = new ArrayList<Path>();
        for (File child : dir.listFiles()) {
            if (child.isDirectory()) {
                if (!this.isToRecurse) continue;
                ret.addAll(this.scan(child));
                continue;
            }
            Path rel = this.basePath.relativize(child.toPath());
            boolean acceptable = false;
            for (PathMatcher pm : this.includeMatchers) {
                if (pm.matches(rel)) {
                    if (this.log != null && this.log.isDebugEnabled()) {
                        this.log.debug((CharSequence)("[INCLUDE] " + rel + " matches " + pm));
                    }
                    acceptable = true;
                    break;
                }
                if (this.log == null || !this.log.isDebugEnabled()) continue;
                this.log.debug((CharSequence)("[INCLUDE] " + rel + " does not match " + pm));
            }
            for (PathMatcher pm : this.excludeMatchers) {
                if (!pm.matches(rel)) continue;
                if (this.log != null && this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("[EXCLUDE] " + rel + " matches " + pm));
                }
                acceptable = false;
                break;
            }
            if (!acceptable) continue;
            ret.add(rel);
        }
        return ret;
    }
}

