/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.xml.maven.plugin.xsl;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import top.marchand.xml.maven.plugin.xsl.scandir.DirectoryScanner;

public class FileSet {
    private final List<String> includes = new ArrayList<String>();
    private final List<String> excludes = new ArrayList<String>();
    private List<Path> foundFiles;
    private String dir;

    public FileSet() {
        this.resetIncludeExcludes();
    }

    public FileSet(String dir) {
        this();
        this.dir = dir;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    protected final void resetIncludeExcludes() {
        this.includes.clear();
        this.includes.addAll(FileSet.getDefaultIncludes());
        this.excludes.clear();
        this.excludes.addAll(FileSet.getDefaultExcludes());
    }

    public static List<String> getDefaultIncludes() {
        return Arrays.asList("*.xsl", "**/*.xsl");
    }

    public static List<String> getDefaultExcludes() {
        return Arrays.asList("**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "/.cvsignore", "/SCCS", "/SCCS/**", "/vssver.scc", "/.svn", "/.svn/**", "/.git", "/.git/**", "/.gitattributes", "/.gitignore", "/.gitmodules", "/.hg", "/.hg/**", "/.hgignore", "/.hgsub", "/.hgsubstate", "/.hgtags", "/.bzr", "/.bzr/**", "/.bzrignore", "/.DS_Store");
    }

    public List<Path> getFiles(Log log) {
        if (this.foundFiles == null) {
            DirectoryScanner scanner = new DirectoryScanner(this, log);
            this.foundFiles = scanner.scan();
        }
        return this.foundFiles;
    }
}

