/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.xml.maven.plugin.xsl.scandir;

import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import top.marchand.xml.maven.plugin.xsl.FileSet;

public class DirectoryScanner {
    private File baseDir;
    private final List<String> includes;
    private final List<String> excludes;
    private final Log log;
    private transient List<PathMatcher> includeMatchers;
    private transient List<PathMatcher> excludeMatchers;
    private transient boolean isToRecurse;
    private transient Path basePath;

    public DirectoryScanner(File baseDir, Log log) {
        this.baseDir = baseDir;
        this.includes = this.getDefaultIncludes();
        this.excludes = this.getDefaultExcludes();
        this.log = log;
    }

    public DirectoryScanner(FileSet fileset, File projectBaseDir, Log log) {
        this.baseDir = new File(fileset.getDir());
        if (!this.baseDir.exists() || !this.baseDir.isDirectory()) {
            this.baseDir = new File(projectBaseDir, fileset.getDir());
        }
        this.includes = fileset.getIncludes();
        this.excludes = fileset.getExcludes();
        this.log = log;
        log.debug((CharSequence)("DirectoryScanner<>(FileSet,Log) baseDir=" + this.baseDir.getAbsolutePath()));
    }

    public List<String> getDefaultIncludes() {
        return FileSet.getDefaultIncludes();
    }

    public List<String> getDefaultExcludes() {
        return FileSet.getDefaultExcludes();
    }

    public List<Path> scan() {
        this.prepareFilters();
        return this.scan(this.baseDir);
    }

    protected void prepareFilters() {
        FileSystem fs = FileSystems.getDefault();
        this.includeMatchers = new ArrayList<PathMatcher>(this.includes.size());
        for (String include : this.includes) {
            this.includeMatchers.add(this.buildPathMatcher(fs, include));
            if (include.contains("**")) {
                this.isToRecurse = true;
                continue;
            }
            if (!include.matches(".*/.+/.*")) continue;
            this.isToRecurse = true;
        }
        this.excludeMatchers = new ArrayList<PathMatcher>(this.excludes.size());
        for (String exclude : this.excludes) {
            this.excludeMatchers.add(this.buildPathMatcher(fs, exclude));
        }
        this.basePath = this.baseDir.toPath().normalize();
    }

    private PathMatcher buildPathMatcher(FileSystem fs, String pattern) {
        String _pattern = pattern.startsWith("glob:") || pattern.startsWith("regex:") ? pattern : "glob:" + pattern;
        return fs.getPathMatcher(_pattern);
    }

    protected List<Path> scan(File dir) {
        this.log.debug((CharSequence)("scanning " + dir.getAbsolutePath() + ". it is " + (dir.isDirectory() ? "" : "not ") + "a directory"));
        ArrayList<Path> ret = new ArrayList<Path>();
        Object[] childs = dir.listFiles();
        this.log.debug((CharSequence)("\tchilds=" + Arrays.toString(childs)));
        for (Object child : childs) {
            if (((File)child).isDirectory()) {
                if (!this.isToRecurse) continue;
                ret.addAll(this.scan((File)child));
                continue;
            }
            Path rel = this.basePath.relativize(((File)child).toPath());
            boolean acceptable = false;
            for (PathMatcher pm : this.includeMatchers) {
                if (!pm.matches(rel)) continue;
                acceptable = true;
                break;
            }
            if (acceptable) {
                for (PathMatcher pm : this.excludeMatchers) {
                    if (!pm.matches(rel)) continue;
                    acceptable = false;
                    break;
                }
            }
            if (!acceptable) continue;
            ret.add(rel);
        }
        return ret;
    }

    public File getBaseDir() {
        return this.baseDir;
    }
}

