/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.xml.maven.plugin.xsl;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import top.marchand.xml.maven.plugin.xsl.scandir.DirectoryScanner;
import top.marchand.xml.maven.plugin.xsl.scandir.ScanListener;

public class FileSet {
    private final List<String> includes = new ArrayList<String>();
    private final List<String> excludes = new ArrayList<String>();
    private List<Path> foundFiles;
    private String dir;
    private String uri;

    public FileSet() {
        this.resetIncludeExcludes();
    }

    public FileSet(String dir) {
        this();
        this.dir = dir;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    protected final void resetIncludeExcludes() {
        this.includes.clear();
        this.includes.addAll(FileSet.getDefaultIncludes());
        this.excludes.clear();
        this.excludes.addAll(FileSet.getDefaultExcludes());
    }

    public static List<String> getDefaultIncludes() {
        return Arrays.asList("*.xsl", "**/*.xsl");
    }

    public static List<String> getDefaultExcludes() {
        return Arrays.asList("**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "/.cvsignore", "/SCCS", "/SCCS/**", "/vssver.scc", "/.svn", "/.svn/**", "/.git", "/.git/**", "/.gitattributes", "/.gitignore", "/.gitmodules", "/.hg", "/.hg/**", "/.hgignore", "/.hgsub", "/.hgsubstate", "/.hgtags", "/.bzr", "/.bzr/**", "/.bzrignore", "/.DS_Store");
    }

    public List<Path> getFiles(File projectBaseDir, Log log) {
        return this.getFiles(projectBaseDir, log, null);
    }

    public List<Path> getFiles(File projectBaseDir, Log log, ScanListener listener) {
        if (this.foundFiles == null) {
            DirectoryScanner scanner = new DirectoryScanner(this, projectBaseDir, log);
            scanner.setScanListener(listener);
            this.foundFiles = scanner.scan();
            this.dir = scanner.getBaseDir().getAbsolutePath();
        }
        return this.foundFiles;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[dir=").append(this.dir).append(", includes=").append(this.includes).append(", excludes=").append(this.excludes).append("]");
        return sb.toString();
    }

    public String getUriPath() {
        if (this.getUri() != null) {
            String ret = this.uri.substring(this.uri.indexOf(":") + 1);
            if (ret.startsWith("/")) {
                return ret.substring(1);
            }
            return ret;
        }
        throw new IllegalStateException("getUriPath() can be call only if this FileSet is based on an URI");
    }
}

