/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.xml.maven.plugin.xsl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.trans.XPathException;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.xml.sax.InputSource;
import top.marchand.maven.saxon.utils.SaxonOptions;
import top.marchand.xml.maven.plugin.xsl.AbstractCompiler;
import top.marchand.xml.maven.plugin.xsl.FileSet;
import top.marchand.xml.maven.plugin.xsl.scandir.ScanListener;

@Mojo(name="xsl-compiler", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class XslCompilerMojo
extends AbstractCompiler {
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classesDirectory;
    @Parameter
    private List<FileSet> filesets;
    @Parameter
    protected File catalog;
    @Parameter(defaultValue="${project.basedir}")
    private File projectBaseDir;
    @Parameter
    private boolean logExcludedFiles;
    @Parameter(name="saxonOptions")
    SaxonOptions saxonOptions;
    public static final String ERROR_MESSAGE = "<filesets>\n\t<fileset>\n\t\t<dir>src/main/xsl...</dir>\n\t</fileset>\n</filesets>\n is required in xslCompiler-maven-plugin configuration";
    private static final transient String LOG_PREFIX = "[xslCompiler] ";
    private static final transient String URI_REGEX = "((([A-Za-z])[A-Za-z0-9+\\-\\.]*):((//(((([A-Za-z0-9\\-\\._~!$&'()*+,;=:]|(%[0-9A-Fa-f][0-9A-Fa-f]))*@))?((\\[(((((([0-9A-Fa-f]){0,4}:)){6}((([0-9A-Fa-f]){0,4}:([0-9A-Fa-f]){0,4})|(([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5])))))|(::((([0-9A-Fa-f]){0,4}:)){5}((([0-9A-Fa-f]){0,4}:([0-9A-Fa-f]){0,4})|(([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5])))))|((([0-9A-Fa-f]){0,4})?::((([0-9A-Fa-f]){0,4}:)){4}((([0-9A-Fa-f]){0,4}:([0-9A-Fa-f]){0,4})|(([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5])))))|(((((([0-9A-Fa-f]){0,4}:))?([0-9A-Fa-f]){0,4}))?::((([0-9A-Fa-f]){0,4}:)){3}((([0-9A-Fa-f]){0,4}:([0-9A-Fa-f]){0,4})|(([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5])))))|(((((([0-9A-Fa-f]){0,4}:)){0,2}([0-9A-Fa-f]){0,4}))?::((([0-9A-Fa-f]){0,4}:)){2}((([0-9A-Fa-f]){0,4}:([0-9A-Fa-f]){0,4})|(([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5])))))|(((((([0-9A-Fa-f]){0,4}:)){0,3}([0-9A-Fa-f]){0,4}))?::([0-9A-Fa-f]){0,4}:((([0-9A-Fa-f]){0,4}:([0-9A-Fa-f]){0,4})|(([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5])))))|(((((([0-9A-Fa-f]){0,4}:)){0,4}([0-9A-Fa-f]){0,4}))?::((([0-9A-Fa-f]){0,4}:([0-9A-Fa-f]){0,4})|(([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5])))))|(((((([0-9A-Fa-f]){0,4}:)){0,5}([0-9A-Fa-f]){0,4}))?::([0-9A-Fa-f]){0,4})|(((((([0-9A-Fa-f]){0,4}:)){0,6}([0-9A-Fa-f]){0,4}))?::))|(v([0-9A-Fa-f])+\\.(([A-Za-z0-9\\-\\._~]|[!$&'()*+,;=]|:))+))\\])|(([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1([0-9]){2})|(2[0-4][0-9])|(25[0-5])))|(([A-Za-z0-9\\-\\._~]|(%[0-9A-Fa-f][0-9A-Fa-f])|[!$&'()*+,;=]))*)((:([0-9])*))?)((/(([A-Za-z0-9\\-\\._~]|(%[0-9A-Fa-f][0-9A-Fa-f])|[!$&'()*+,;=]|:|@))*))*)|(/(((([A-Za-z0-9\\-\\._~]|(%[0-9A-Fa-f][0-9A-Fa-f])|[!$&'()*+,;=]|:|@))+((/(([A-Za-z0-9\\-\\._~]|(%[0-9A-Fa-f][0-9A-Fa-f])|[!$&'()*+,;=]|:|@))*))*))?)|((([A-Za-z0-9\\-\\._~]|(%[0-9A-Fa-f][0-9A-Fa-f])|[!$&'()*+,;=]|:|@))+((/(([A-Za-z0-9\\-\\._~]|(%[0-9A-Fa-f][0-9A-Fa-f])|[!$&'()*+,;=]|:|@))*))*)|)((\\?((([A-Za-z0-9\\-\\._~]|(%[0-9A-Fa-f][0-9A-Fa-f])|[!$&'()*+,;=]|:|@)|/|\\?))*))?((#((([A-Za-z0-9\\-\\._~]|(%[0-9A-Fa-f][0-9A-Fa-f])|[!$&'()*+,;=]|:|@)|/|\\?))*))?)";

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        try {
            this.initSaxon();
        }
        catch (XPathException ex) {
            this.getLog().error((CharSequence)"while configuring Saxon:", (Throwable)ex);
        }
        Path targetDir = this.classesDirectory.toPath();
        boolean hasError = false;
        if (this.filesets == null) {
            this.getLog().error((CharSequence)"[xslCompiler] \n<filesets>\n\t<fileset>\n\t\t<dir>src/main/xsl...</dir>\n\t</fileset>\n</filesets>\n is required in xslCompiler-maven-plugin configuration");
            throw new MojoExecutionException(ERROR_MESSAGE);
        }
        ScanListener listener = null;
        if (this.logExcludedFiles) {
            listener = new ScanListener(){

                @Override
                public void scanning(File dir) {
                }

                @Override
                public void fileAccepted(Path rel) {
                }

                @Override
                public void fileRejected(Path rel) {
                    XslCompilerMojo.this.getLog().warn((CharSequence)(rel.toString() + " has been excluded. If it is a resource, this resource may nto be processed as a resource, and will be probably miss in final delivery."));
                }
            };
        }
        for (FileSet fs : this.filesets) {
            if (fs.getUri() != null) {
                try {
                    int pos = fs.getUri().indexOf(":");
                    String sPath = fs.getUriPath();
                    Source source = this.compiler.getURIResolver().resolve(fs.getUri(), null);
                    Path targetPath = targetDir.resolve(sPath);
                    String sourceFileName = sPath.substring(sPath.lastIndexOf("/") + 1);
                    if (sourceFileName.contains("?")) {
                        sourceFileName = sourceFileName.substring(0, sourceFileName.indexOf("?") - 1);
                    }
                    this.getLog().debug((CharSequence)("[xslCompiler]  sourceFileName=" + sourceFileName));
                    String targetFileName = FilenameUtils.getBaseName((String)sourceFileName).concat(".sef");
                    this.getLog().debug((CharSequence)("[xslCompiler]  targetFileName=" + targetFileName));
                    File targetFile = targetPath.resolve(targetFileName).toFile();
                    this.compileFile(source, targetFile);
                }
                catch (IOException | TransformerException | SaxonApiException ex) {
                    hasError = true;
                    this.getLog().error((CharSequence)("[xslCompiler]  while compiling " + fs.getUri()), ex);
                }
                continue;
            }
            Path basedir = new File(fs.getDir()).toPath();
            for (Path p : fs.getFiles(this.projectBaseDir, log, listener)) {
                try {
                    File sourceFile = basedir.resolve(p).toFile();
                    SAXSource source = new SAXSource(new InputSource(new FileInputStream(sourceFile)));
                    Path targetPath = p.getParent() == null ? targetDir : targetDir.resolve(p.getParent());
                    String sourceFileName = sourceFile.getName();
                    this.getLog().debug((CharSequence)("[xslCompiler]  sourceFileName=" + sourceFileName));
                    String targetFileName = FilenameUtils.getBaseName((String)sourceFileName).concat(".sef");
                    this.getLog().debug((CharSequence)("[xslCompiler]  targetFileName=" + targetFileName));
                    File targetFile = targetPath.resolve(targetFileName).toFile();
                    try {
                        this.compileFile(source, targetFile);
                    }
                    catch (FileNotFoundException | SaxonApiException ex) {
                        hasError = true;
                        this.getLog().error((CharSequence)("[xslCompiler]  While compiling " + p), ex);
                    }
                }
                catch (FileNotFoundException ex) {
                    hasError = true;
                    this.getLog().error((CharSequence)("[xslCompiler]  While compiling " + p), (Throwable)ex);
                }
            }
        }
        if (hasError) {
            throw new MojoExecutionException("Error occured while compiling Xslts. See previous log.");
        }
    }

    @Override
    public File getCatalogFile() {
        return this.catalog;
    }

    @Override
    public SaxonOptions getSaxonOptions() {
        return this.saxonOptions;
    }
}

