/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.xml.maven.plugin.xsl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltPackage;
import net.sf.saxon.trans.XPathException;
import org.apache.maven.plugin.AbstractMojo;
import org.xml.sax.ext.EntityResolver2;
import org.xmlresolver.Catalog;
import org.xmlresolver.Resolver;
import top.marchand.maven.saxon.utils.SaxonOptions;
import top.marchand.maven.saxon.utils.SaxonUtils;
import top.marchand.xml.maven.plugin.xsl.parsers.XcSAXParserFactory;

public abstract class AbstractCompiler
extends AbstractMojo {
    protected DocumentBuilder builder;
    protected XsltCompiler compiler;

    public abstract File getCatalogFile();

    protected void compileFile(Source source, File targetFile) throws SaxonApiException, FileNotFoundException {
        XdmNode document = this.builder.build(source);
        XdmNode documentRoot = (XdmNode)document.axisIterator(Axis.CHILD).next();
        if (documentRoot.getNodeName().getLocalName().equals("package")) {
            this.compilePackage(documentRoot, targetFile);
        } else {
            this.compileModule(documentRoot, targetFile);
        }
    }

    protected void compileModule(XdmNode document, File targetFile) throws SaxonApiException, FileNotFoundException {
        XsltExecutable exec = this.compiler.compile(document.asSource());
        targetFile.getParentFile().mkdirs();
        exec.export((OutputStream)new FileOutputStream(targetFile));
    }

    protected void compilePackage(XdmNode document, File targetFile) throws SaxonApiException {
        XsltPackage pack = this.compiler.compilePackage(document.asSource());
        pack.save(targetFile);
        this.compiler.importPackage(pack);
    }

    protected void initSaxon() throws XPathException {
        Resolver uriResolver;
        Configuration config = Configuration.newConfiguration();
        config.setSourceParserClass(XcSAXParserFactory.class.getName());
        Processor proc = new Processor(config);
        SaxonUtils.prepareSaxonConfiguration((Processor)proc, (SaxonOptions)this.getSaxonOptions());
        if (this.getSaxonOptions() != null) {
            this.compiler.setRelocatable("on".equals(this.getSaxonOptions().getRelocate()));
        }
        if (this.getCatalogFile() != null) {
            this.getLog().debug((CharSequence)("Setting catalog to " + this.getCatalogFile().toURI().toString()));
            uriResolver = new Resolver(new Catalog(this.getCatalogFile().toURI().toString()));
        } else {
            uriResolver = new Resolver();
        }
        config.setURIResolver((URIResolver)uriResolver);
        this.compiler = proc.newXsltCompiler();
        this.builder = proc.newDocumentBuilder();
    }

    protected Processor getProcessor() {
        return this.compiler.getProcessor();
    }

    protected XsltCompiler getXsltCompiler() {
        return this.compiler;
    }

    protected URIResolver getUriResolver() {
        return this.compiler.getURIResolver();
    }

    protected EntityResolver2 getEntityResolver() {
        return (EntityResolver2)((Object)this.getUriResolver());
    }

    protected DocumentBuilder getBuilder() {
        return this.builder;
    }

    public abstract SaxonOptions getSaxonOptions();
}

