/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.xml.maven.plugin.xsl;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltPackage;
import net.sf.saxon.trans.XPathException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.xml.sax.ext.EntityResolver2;
import org.xmlresolver.Catalog;
import org.xmlresolver.Resolver;
import top.marchand.maven.saxon.utils.SaxonOptions;
import top.marchand.maven.saxon.utils.SaxonUtils;
import top.marchand.xml.maven.plugin.xsl.parsers.XcSAXParserFactory;

public abstract class AbstractCompiler
extends AbstractMojo {
    protected DocumentBuilder builder;
    protected XsltCompiler compiler;
    private static final String LOG_PREFIX = "[AbstractXslCompiler] ";
    private List<URL> addedToSaxonJars;

    public abstract DependencyGraphBuilder getGraphBuilder();

    public abstract MavenProject getProject();

    public abstract File getCatalogFile();

    protected void compileFile(Source source, File targetFile) throws SaxonApiException, FileNotFoundException {
        XdmNode document = this.builder.build(source);
        XdmNode documentRoot = (XdmNode)document.axisIterator(Axis.CHILD).next();
        if (documentRoot.getNodeName().getLocalName().equals("package")) {
            this.compilePackage(documentRoot, targetFile);
        } else {
            this.compileModule(documentRoot, targetFile);
        }
    }

    protected void compileModule(XdmNode document, File targetFile) throws SaxonApiException, FileNotFoundException {
        XsltExecutable exec = this.compiler.compile(document.asSource());
        targetFile.getParentFile().mkdirs();
        exec.export((OutputStream)new FileOutputStream(targetFile));
    }

    protected void compilePackage(XdmNode document, File targetFile) throws SaxonApiException {
        XsltPackage pack = this.compiler.compilePackage(document.asSource());
        pack.save(targetFile);
        this.compiler.importPackage(pack);
    }

    protected void initSaxon() throws XPathException {
        Resolver uriResolver;
        Configuration config = Configuration.newConfiguration();
        this.addedToSaxonJars = new ArrayList<URL>();
        config.setSourceParserClass(XcSAXParserFactory.class.getName());
        Processor proc = new Processor(config);
        SaxonUtils.prepareSaxonConfiguration((Processor)proc, (SaxonOptions)this.getSaxonOptions());
        if (this.getSaxonOptions() != null) {
            this.compiler.setRelocatable("on".equals(this.getSaxonOptions().getRelocate()));
        }
        if (this.getCatalogFile() != null) {
            this.getLog().debug((CharSequence)("[AbstractXslCompiler] Setting catalog to " + this.getCatalogFile().toURI().toString()));
            uriResolver = new Resolver(new Catalog(this.getCatalogFile().toURI().toString()));
        } else {
            uriResolver = new Resolver();
        }
        config.setURIResolver((URIResolver)uriResolver);
        this.builder = proc.newDocumentBuilder();
        final URLClassLoader saxonClassLoader = (URLClassLoader)config.getClass().getClassLoader();
        try {
            XPathCompiler xpCompiler = proc.newXPathCompiler();
            XPathExecutable xpExec = xpCompiler.compile("/gaulois-services/saxon/extensions/function");
            final List classpath = this.getProject().getCompileClasspathElements();
            DependencyNode rootNode = this.getGraphBuilder().buildDependencyGraph(this.getProject(), new ArtifactFilter(){

                public boolean include(Artifact artfct) {
                    return true;
                }
            });
            rootNode.accept(new DependencyNodeVisitor(){

                public boolean visit(DependencyNode dn) {
                    try {
                        return AbstractCompiler.this.processDependency(dn, classpath, saxonClassLoader);
                    }
                    catch (OverConstrainedVersionException ex) {
                        AbstractCompiler.this.getLog().error((CharSequence)("[AbstractXslCompiler] while processing dependency " + dn.toNodeString()), (Throwable)ex);
                        return false;
                    }
                }

                public boolean endVisit(DependencyNode dn) {
                    return true;
                }
            });
            Enumeration<URL> enumer = saxonClassLoader.findResources("META-INF/services/top.marchand.xml.gaulois.xml");
            while (enumer.hasMoreElements()) {
                URL serviceUrl = enumer.nextElement();
                this.getLog().debug((CharSequence)("[AbstractXslCompiler] loading service " + serviceUrl.toExternalForm()));
                XdmNode document = this.builder.build((Source)new StreamSource(serviceUrl.openStream()));
                XPathSelector selector = xpExec.load();
                selector.setContextItem((XdmItem)document);
                XdmSequenceIterator it = selector.evaluate().iterator();
                while (it.hasNext()) {
                    String className = it.next().getStringValue();
                    try {
                        Class<?> clazz = saxonClassLoader.loadClass(className);
                        if (this.extendsClass(clazz, ExtensionFunctionDefinition.class)) {
                            Class<?> cle = clazz;
                            config.registerExtensionFunction((ExtensionFunctionDefinition)cle.newInstance());
                            this.getLog().debug((CharSequence)(LOG_PREFIX + className + "registered as Saxon extension function"));
                            continue;
                        }
                        this.getLog().warn((CharSequence)(LOG_PREFIX + className + " does not extends " + ExtensionFunctionDefinition.class.getName()));
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                        this.getLog().warn((CharSequence)("[AbstractXslCompiler] unable to load extension function " + className));
                    }
                }
            }
        }
        catch (IOException | SaxonApiException | DependencyResolutionRequiredException | DependencyGraphBuilderException ex) {
            this.getLog().error((CharSequence)"[AbstractXslCompiler] while looking for resources in /META-INF/services/top.marchand.xml.gaulois/", ex);
        }
        this.compiler = proc.newXsltCompiler();
        this.compiler.setJustInTimeCompilation(false);
    }

    private boolean processDependency(DependencyNode dn, List<String> classpath, URLClassLoader saxonClassLoader) throws OverConstrainedVersionException {
        String artifactPath = this.constructArtifactPath(dn.getArtifact());
        String jarFileName = this.getJarFileName(artifactPath, classpath);
        if (jarFileName != null && jarFileName.endsWith(".jar")) {
            try {
                URL jarParentUrl;
                DependencyNode parent;
                String parentArtifactPath;
                String parentJarFileName;
                URL jarUrl = new File(jarFileName).toURI().toURL();
                this.getLog().debug((CharSequence)("[AbstractXslCompiler] url=" + jarUrl.toExternalForm()));
                URL[] urls = new URL[]{jarUrl};
                if (dn.getParent() != null && (parentJarFileName = this.getJarFileName(parentArtifactPath = this.constructArtifactPath((parent = dn.getParent()).getArtifact()), classpath)) != null && this.addedToSaxonJars.contains(jarParentUrl = new File(parentJarFileName).toURI().toURL())) {
                    this.addJarToClassLoader(jarUrl, saxonClassLoader);
                    return true;
                }
                URLClassLoader ucl = new URLClassLoader(urls);
                Enumeration<URL> enumer = ucl.findResources("META-INF/services/top.marchand.xml.gaulois.xml");
                if (enumer.hasMoreElements()) {
                    this.addJarToClassLoader(jarUrl, saxonClassLoader);
                    return true;
                }
                return true;
            }
            catch (IOException ex) {
                this.getLog().error((CharSequence)("while processing dependency " + dn.toNodeString() + " with jarFileName " + jarFileName), (Throwable)ex);
                return false;
            }
        }
        return true;
    }

    private String getJarFileName(String artifactPath, List<String> classpath) {
        String jarFileName = null;
        for (String s : classpath) {
            if (!s.contains(artifactPath)) continue;
            jarFileName = s;
            break;
        }
        return jarFileName;
    }

    private String constructArtifactPath(Artifact art) throws OverConstrainedVersionException {
        String[] groups = art.getGroupId().split("\\.");
        String[] artifacts = art.getArtifactId().split("\\.");
        Object[] elements = new String[groups.length + artifacts.length + 1];
        System.arraycopy(groups, 0, elements, 0, groups.length);
        System.arraycopy(artifacts, 0, elements, groups.length, artifacts.length);
        elements[elements.length - 1] = art.getBaseVersion();
        return Joiner.on((String)File.separator).skipNulls().join(elements);
    }

    protected Processor getProcessor() {
        return this.compiler.getProcessor();
    }

    protected XsltCompiler getXsltCompiler() {
        return this.compiler;
    }

    protected URIResolver getUriResolver() {
        return this.compiler.getURIResolver();
    }

    protected EntityResolver2 getEntityResolver() {
        return (EntityResolver2)((Object)this.getUriResolver());
    }

    protected DocumentBuilder getBuilder() {
        return this.builder;
    }

    public abstract SaxonOptions getSaxonOptions();

    private boolean extendsClass(Class toCheck, Class inheritor) {
        if (toCheck.equals(inheritor)) {
            return true;
        }
        if (toCheck.equals(Object.class)) {
            return false;
        }
        return this.extendsClass(toCheck.getSuperclass(), inheritor);
    }

    protected void addJarToClassLoader(URL url, URLClassLoader ucl) {
        try {
            Method meth = ucl.getClass().getMethod("addURL", URL.class);
            meth.invoke((Object)ucl, url);
            this.addedToSaxonJars.add(url);
            this.getLog().debug((CharSequence)(LOG_PREFIX + url.toExternalForm() + " added to saxon classpath"));
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            this.getLog().error((CharSequence)("while adding " + url.toString() + " to classloader"), (Throwable)ex);
        }
    }
}

