/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.xml.saxon.extension.highlight;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Value;

public class HighlightExtension
extends ExtensionFunctionDefinition {
    public static final String EXT_NAMESPACE_URI = "top:marchand:xml:extfunctions";
    public static final String EXT_FUNCTION_NAME = "highlight";
    public static final String EXT_PREFIX = "chm";
    public static final StructuredQName FUNCTION_QNAME = new StructuredQName("chm", "top:marchand:xml:extfunctions", "highlight");
    public static final SequenceType[] PARAMETERS_TYPES = new SequenceType[]{SequenceType.SINGLE_STRING, SequenceType.SINGLE_STRING, MapType.OPTIONAL_MAP_ITEM};
    public static final String JS = "js";
    private static final String JS_RESOURCE = "/top/marchand/xml/saxon/extension/highlight/highlight.min.js";
    public static final String DEFAULT_RESULT_NAMESPACE = "http://www.w3.org/1999/xhtml";
    public static final AtomicValue NAMESPACE_ENTRY = new StringValue((CharSequence)"result-ns");
    public static final QName PARAM_TARGET_NS = new QName("targetNS");
    private Context context;
    private Value function;

    public HighlightExtension() {
        try {
            this.context = Context.create((String[])new String[0]);
            this.context.eval(org.graalvm.polyglot.Source.newBuilder((String)JS, (Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(JS_RESOURCE)), (String)"highlight.min.js").build());
            Value obj = this.context.getBindings(JS).getMember("hljs");
            this.function = obj.getMember(EXT_FUNCTION_NAME);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    public StructuredQName getFunctionQName() {
        return FUNCTION_QNAME;
    }

    public SequenceType[] getArgumentTypes() {
        return PARAMETERS_TYPES;
    }

    public SequenceType getResultType(SequenceType[] sts) {
        return SequenceType.OPTIONAL_ITEM;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            public Sequence call(XPathContext xpc, Sequence[] parameters) throws XPathException {
                MapItem config;
                if (parameters.length < 2) {
                    throw new XPathException("chm:highlight requires 2 parameters at least: (language as xs:string, sourceCode as xs:string, config as map()?)");
                }
                String language = parameters[0].head().getStringValue();
                if (language.isEmpty()) {
                    throw new XPathException("chm:highlight first parameter language must not be empty");
                }
                String sourceCode = parameters[1].head().getStringValue();
                String resultNamespace = HighlightExtension.DEFAULT_RESULT_NAMESPACE;
                if (parameters.length == 3 && (config = (MapItem)parameters[2].head()).get(NAMESPACE_ENTRY) != null) {
                    resultNamespace = config.get(NAMESPACE_ENTRY).getStringValue();
                }
                String escaped = HighlightExtension.this.function.execute(new Object[]{language, sourceCode}).getMember("value").asString();
                String wrapped = "<wrapper>" + escaped + "</wrapper>";
                Processor proc = new Processor(xpc.getConfiguration());
                try {
                    XdmNode tree = proc.newDocumentBuilder().build((Source)new StreamSource(new StringReader(wrapped)));
                    XsltTransformer tr = proc.newXsltCompiler().compile((Source)new StreamSource(((Object)((Object)this)).getClass().getResourceAsStream("/top/marchand/xml/saxon/extension/highlight/namespace-changer.sef"))).load();
                    tr.setInitialContextNode(tree);
                    tr.setParameter(PARAM_TARGET_NS, XdmValue.makeValue((Object)resultNamespace));
                    XdmDestination xslResult = new XdmDestination();
                    tr.setDestination((Destination)xslResult);
                    tr.transform();
                    XPathCompiler compiler = proc.newXPathCompiler();
                    compiler.declareNamespace("h", resultNamespace);
                    XPathSelector xs = compiler.compile("/h:wrapper/node()").load();
                    xs.setContextItem((XdmItem)xslResult.getXdmNode());
                    XdmValue ret = xs.evaluate();
                    return ret.getUnderlyingValue();
                }
                catch (SaxonApiException ex) {
                    throw new XPathException((Throwable)ex);
                }
            }
        };
    }

    public int getMaximumNumberOfArguments() {
        return 3;
    }

    public int getMinimumNumberOfArguments() {
        return 2;
    }

    public boolean trustResultType() {
        return true;
    }
}

