/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.xml.xsl.doc;

import fr.efl.chaine.xslt.StepJava;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumulatorStep
extends StepJava {
    public static final String NS = "top:marchand:xml:xsl:doc";
    private static final Logger LOGGER = LoggerFactory.getLogger(AccumulatorStep.class);
    private static final HashMap<String, CharSequence> inputFiles = new HashMap();
    private static String outputDir;
    private static String absoluteRootFolder;
    String currentInputFile;

    public Receiver getReceiver(Configuration c) throws SaxonApiException {
        this.currentInputFile = this.getParameter(new QName("input-absolute")).toString();
        outputDir = this.getParameter(new QName("outputFolder")).toString();
        absoluteRootFolder = this.getParameter(new QName("absoluteRootFolder")).toString();
        return new AccumulatorStepReceiver(this.getNextReceiver(c));
    }

    static void generateIndex(String projectName) throws IOException, SaxonApiException, URISyntaxException {
        String outputPath = new File(new URI(outputDir)).getAbsolutePath();
        String absoluteRootPath = new File(new URI(absoluteRootFolder)).getAbsolutePath();
        StringBuilder sb = new StringBuilder();
        for (String input : inputFiles.keySet()) {
            String targetReadUri = new File(new URI(inputFiles.get(input).toString())).getAbsolutePath();
            String targetUri = targetReadUri.subSequence(outputPath.length() + 1, targetReadUri.length()).toString();
            String sourceUri = input.substring(absoluteRootPath.length() + 1);
            sb.append(sourceUri).append("@").append(targetUri).append("|");
        }
        String data = sb.deleteCharAt(sb.length() - 1).toString();
        LOGGER.debug("data=" + data);
        Processor proc = new Processor(Configuration.newConfiguration());
        XsltExecutable exec = proc.newXsltCompiler().compile((Source)new StreamSource(new URL("cp:/generateWholeIndex.xsl").openStream()));
        XsltTransformer transformer = exec.load();
        transformer.setInitialTemplate(new QName(NS, "main"));
        transformer.setParameter(new QName(NS, "programName"), (XdmValue)new XdmAtomicValue(projectName));
        transformer.setParameter(new QName(NS, "absoluteRootDir"), (XdmValue)new XdmAtomicValue(absoluteRootFolder));
        transformer.setParameter(new QName(NS, "sData"), (XdmValue)new XdmAtomicValue(data));
        Serializer serializer = proc.newSerializer(new File(new File(outputPath), "entries.xml"));
        transformer.setDestination((Destination)serializer);
        transformer.transform();
    }

    private class AccumulatorStepReceiver
    extends ProxyReceiver {
        private final Stack<NodeName> stack;
        private String currentElementName;

        public AccumulatorStepReceiver(Receiver nextReceiver) {
            super(nextReceiver);
            this.stack = new Stack();
        }

        public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
            super.startElement(elemName, typeCode, location, properties);
            this.currentElementName = elemName.getLocalPart();
            this.stack.push(elemName);
        }

        public void endElement() throws XPathException {
            super.endElement();
            this.stack.pop();
        }

        public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
            super.attribute(nameCode, typeCode, value, locationId, properties);
            if ("file".equals(this.currentElementName) && this.stack.size() == 1 && nameCode.getLocalPart().equals("welcomeOutputUri")) {
                inputFiles.put(AccumulatorStep.this.currentInputFile, value);
                LOGGER.debug("[Accumulator] " + AccumulatorStep.this.currentInputFile + "->" + value);
            }
        }
    }
}

