/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.xml.xsl.doc;

import fr.efl.chaine.xslt.GauloisPipe;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Arrays;
import net.sf.saxon.s9api.SaxonApiException;
import top.marchand.xml.xsl.doc.AccumulatorStep;

public class GauloisPipeRunner {
    public static void main(String[] args) throws IOException, SaxonApiException, URISyntaxException {
        String[] gauloisArgs = Arrays.copyOfRange(args, 2, args.length);
        String projectName = args[1];
        GauloisPipe.main((String[])gauloisArgs);
        File indexFile = AccumulatorStep.generateIndex(projectName);
        if (indexFile == null) {
            String s = args[args.length - 1];
            String sOutputFolder = s.substring("outputFolder=".length());
            File outputFolder = new File(new URI(sOutputFolder));
            boolean ret = outputFolder.mkdirs();
            if (!ret) {
                System.err.println("[ERROR] not able to create " + outputFolder.getAbsolutePath() + " directory");
            }
            File entriesFile = new File(outputFolder, "entries.xml");
            try (PrintWriter writer = new PrintWriter(entriesFile, Charset.forName("UTF-8").name());){
                writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<entries/>");
                writer.flush();
            }
        }
    }
}

