/*
 * Decompiled with CFR 0.152.
 */
package top.mindse.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PolicyConditions;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.mindse.model.OssPolicy;
import top.mindse.oss.Storage;

public class AliyunStorage
implements Storage {
    private static final Logger log = LoggerFactory.getLogger(AliyunStorage.class);
    private static final String SEPARATOR = "/";
    private final OSSClient ossClient;

    public AliyunStorage(OSSClient ossClient) {
        this.ossClient = ossClient;
    }

    @Override
    public void uploadFile(String bucketName, String storagePath, String fileName, InputStream inputStream, String contentType) {
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentType(contentType);
        this.ossClient.putObject(bucketName, this.getKey(storagePath, fileName), inputStream, objectMetadata);
    }

    @Override
    public InputStream getFile(String bucketName, String storagePath, String fileName) {
        return this.ossClient.getObject(bucketName, this.getKey(storagePath, fileName)).getObjectContent();
    }

    @Override
    public String getFileUrl(String bucketName, String storagePath, String fileName) {
        return "https://" + bucketName + "." + this.ossClient.getEndpoint().getHost() + SEPARATOR + this.getKey(storagePath, fileName);
    }

    @Override
    public void removeFile(String bucketName, String storagePath, String fileName) {
        this.ossClient.deleteObject(bucketName, this.getKey(storagePath, fileName));
    }

    @Override
    public OssPolicy getOssPolicy(String bucketName, String storagePath, int maxSize, int policeExpire) {
        OssPolicy ossPolicy = new OssPolicy();
        long expireEndTime = System.currentTimeMillis() + (long)(policeExpire * 1000);
        Date expiration = new Date(expireEndTime);
        long maxFileSize = maxSize * 1024 * 1024;
        String action = "https://" + bucketName + "." + this.ossClient.getEndpoint().getHost();
        String key = this.getStoragePath(storagePath);
        try {
            PolicyConditions policyConditions = new PolicyConditions();
            policyConditions.addConditionItem("content-length-range", 0L, maxFileSize);
            policyConditions.addConditionItem(MatchMode.StartWith, "key", this.getStoragePath(storagePath));
            String postPolicy = this.ossClient.generatePostPolicy(expiration, policyConditions);
            byte[] binaryData = postPolicy.getBytes(StandardCharsets.UTF_8);
            String policy = BinaryUtil.toBase64String((byte[])binaryData);
            String signature = this.ossClient.calculatePostSignature(postPolicy);
            ossPolicy.setOssaccessKeyId(this.ossClient.getCredentialsProvider().getCredentials().getAccessKeyId());
            ossPolicy.setPolicy(policy);
            ossPolicy.setSignature(signature);
            ossPolicy.setKey(key);
            ossPolicy.setHost(action);
            ossPolicy.setUrl(action + SEPARATOR + key);
            ossPolicy.setSuccess_action_status(200);
        }
        catch (Exception e) {
            log.error("\u7b7e\u540d\u751f\u6210\u5931\u8d25", (Throwable)e);
        }
        return ossPolicy;
    }

    private String getKey(String storagePath, String fileName) {
        if (storagePath == null || "".equals(storagePath)) {
            return fileName;
        }
        return this.getStoragePath(storagePath) + fileName;
    }

    private String getStoragePath(String storagePath) {
        if (storagePath.endsWith(SEPARATOR)) {
            return storagePath;
        }
        return storagePath + SEPARATOR;
    }
}

