/*
 * Decompiled with CFR 0.152.
 */
package capstone.jni;

import capstone.Capstone;
import capstone.api.Instruction;
import capstone.jni.FastDisassembler;
import capstone.jni.InsnDeallocator;
import capstone.jni.RegsAccess;

public class FastInstruction
extends Instruction {
    private final FastDisassembler disassembler;
    private final int id;
    private final long address;
    private final String mnemonic;
    private final String opStr;
    private final byte[] bytes;
    private final InsnDeallocator deallocator;
    private final long insn;
    private boolean operandsTried;
    private Capstone.OpInfo operands;
    private boolean regsAccessTried;
    private RegsAccess regsAccess;

    public FastInstruction(FastDisassembler disassembler, long address, String mnemonic, String opStr, byte[] bytes, InsnDeallocator deallocator, long insn) {
        this(disassembler, 0, address, mnemonic, opStr, bytes, deallocator, insn);
    }

    public FastInstruction(FastDisassembler disassembler, int id, long address, String mnemonic, String opStr, byte[] bytes, InsnDeallocator deallocator, long insn) {
        this.disassembler = disassembler;
        this.id = id;
        this.address = address;
        this.mnemonic = mnemonic;
        this.opStr = opStr;
        this.bytes = bytes;
        this.deallocator = deallocator;
        this.insn = insn;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public long getAddress() {
        return this.address;
    }

    @Override
    public String getMnemonic() {
        return this.mnemonic;
    }

    @Override
    public String getOpStr() {
        return this.opStr;
    }

    @Override
    public short getSize() {
        return (short)this.bytes.length;
    }

    @Override
    public Capstone.OpInfo getOperands() {
        if (this.operandsTried) {
            return this.operands;
        }
        try {
            this.operands = this.disassembler.getOpInfo(this.insn);
        }
        finally {
            this.operandsTried = true;
        }
        return this.operands;
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public capstone.api.RegsAccess regsAccess() {
        if (this.regsAccessTried) {
            return this.regsAccess;
        }
        try {
            this.regsAccess = this.disassembler.regsAccess(this.insn);
        }
        finally {
            this.regsAccessTried = true;
        }
        return this.regsAccess;
    }

    @Override
    public String regName(int regId) {
        return this.disassembler.regName(regId);
    }

    @Override
    public int mapToUnicornReg(int capstoneReg) {
        return this.disassembler.mapToUnicornReg(capstoneReg);
    }

    @Override
    public int mapToCapstoneReg(int unicornReg) {
        return this.disassembler.mapToCapstoneReg(unicornReg);
    }
}

