/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm;

import capstone.api.Instruction;
import capstone.api.OpShift;
import capstone.api.arm.OpInfo;
import capstone.api.arm64.MemType;
import capstone.api.arm64.Operand;
import com.github.unidbg.Alignment;
import com.github.unidbg.Emulator;
import com.github.unidbg.Module;
import com.github.unidbg.Utils;
import com.github.unidbg.arm.Arguments;
import com.github.unidbg.arm.Cpsr;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.memory.MemRegion;
import com.github.unidbg.memory.Memory;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import com.sun.jna.Pointer;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ARM {
    private static final int[] ARM_ARG_REGS = new int[]{66, 67, 68, 69};
    private static final int[] ARM64_ARG_REGS = new int[]{199, 200, 201, 202, 203, 204, 205, 206};
    private static final int[] THUMB_REGS = new int[]{66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 12, 10, 11, 3, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29};
    private static final int[] ARM_REGS = new int[]{66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 12, 10, 11, 3, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29};
    private static final int[] ARM64_REGS = new int[]{199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 1, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 2, 4, 260, 3};
    private static final int ALIGN_SIZE_BASE = 16;
    private static final Log log = LogFactory.getLog(ARM.class);

    public static boolean isThumb(Backend backend) {
        return Cpsr.getArm(backend).isThumb();
    }

    static boolean isThumb32(short ins) {
        return (ins & 0xE000) == 57344 && (ins & 0x1800) != 0;
    }

    public static void showThumbRegs(Emulator<?> emulator) {
        ARM.showRegs(emulator, THUMB_REGS);
    }

    public static void showRegs(Emulator<?> emulator, int[] regs) {
        Backend backend = emulator.getBackend();
        boolean thumb = ARM.isThumb(backend);
        if (regs == null || regs.length < 1) {
            regs = ARM.getAllRegisters(thumb);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(">>>");
        block35: for (int reg : regs) {
            switch (reg) {
                case 3: {
                    Cpsr cpsr = Cpsr.getArm(backend);
                    builder.append(String.format(Locale.US, " cpsr: N=%d, Z=%d, C=%d, V=%d, T=%d, mode=0b", cpsr.isNegative() ? 1 : 0, cpsr.isZero() ? 1 : 0, cpsr.hasCarry() ? 1 : 0, cpsr.isOverflow() ? 1 : 0, cpsr.isThumb() ? 1 : 0)).append(Integer.toBinaryString(cpsr.getMode()));
                    continue block35;
                }
                case 66: {
                    Number number = backend.reg_read(reg);
                    int value = number.intValue();
                    builder.append(String.format(Locale.US, " r0=0x%x", value));
                    if (value >= 0) continue block35;
                    builder.append('(').append(value).append(')');
                    continue block35;
                }
                case 67: {
                    Number number = backend.reg_read(reg);
                    int value = number.intValue();
                    builder.append(String.format(Locale.US, " r1=0x%x", value));
                    continue block35;
                }
                case 68: {
                    Number number = backend.reg_read(reg);
                    int value = number.intValue();
                    builder.append(String.format(Locale.US, " r2=0x%x", value));
                    continue block35;
                }
                case 69: {
                    Number number = backend.reg_read(reg);
                    int value = number.intValue();
                    builder.append(String.format(Locale.US, " r3=0x%x", value));
                    continue block35;
                }
                case 70: {
                    Number number = backend.reg_read(reg);
                    int value = number.intValue();
                    builder.append(String.format(Locale.US, " r4=0x%x", value));
                    continue block35;
                }
                case 71: {
                    Number number = backend.reg_read(reg);
                    int value = number.intValue();
                    builder.append(String.format(Locale.US, " r5=0x%x", value));
                    continue block35;
                }
                case 72: {
                    Number number = backend.reg_read(reg);
                    int value = number.intValue();
                    builder.append(String.format(Locale.US, " r6=0x%x", value));
                    continue block35;
                }
                case 73: {
                    Number number = backend.reg_read(reg);
                    int value = number.intValue();
                    builder.append(String.format(Locale.US, " r7=0x%x", value));
                    continue block35;
                }
                case 74: {
                    Number number = backend.reg_read(reg);
                    int value = number.intValue();
                    builder.append(String.format(Locale.US, " r8=0x%x", value));
                    continue block35;
                }
                case 75: {
                    Number number = backend.reg_read(reg);
                    int value = number.intValue();
                    builder.append(String.format(Locale.US, " sb=0x%x", value));
                    continue block35;
                }
                case 76: {
                    Number number = backend.reg_read(reg);
                    int value = number.intValue();
                    builder.append(String.format(Locale.US, " sl=0x%x", value));
                    continue block35;
                }
                case 77: {
                    Number number = backend.reg_read(reg);
                    int value = number.intValue();
                    builder.append(String.format(Locale.US, " fp=0x%x", value));
                    continue block35;
                }
                case 78: {
                    Number number = backend.reg_read(reg);
                    int value = number.intValue();
                    builder.append(String.format(Locale.US, " ip=0x%x", value));
                    continue block35;
                }
                case 12: {
                    Number number = backend.reg_read(reg);
                    int value = number.intValue();
                    builder.append(String.format(Locale.US, "\n>>> SP=0x%x", value));
                    continue block35;
                }
                case 10: {
                    builder.append(String.format(Locale.US, " LR=%s", UnidbgPointer.register(emulator, 10)));
                    continue block35;
                }
                case 11: {
                    UnidbgPointer pc = UnidbgPointer.register(emulator, 11);
                    builder.append(String.format(Locale.US, " PC=%s", pc));
                    continue block35;
                }
                case 14: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block35;
                    builder.append("\n>>>");
                    builder.append(String.format(Locale.US, " d0=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block35;
                }
                case 15: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block35;
                    builder.append(String.format(Locale.US, " d1=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block35;
                }
                case 16: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block35;
                    builder.append(String.format(Locale.US, " d2=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block35;
                }
                case 17: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block35;
                    builder.append(String.format(Locale.US, " d3=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block35;
                }
                case 18: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block35;
                    builder.append(String.format(Locale.US, " d4=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block35;
                }
                case 19: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block35;
                    builder.append(String.format(Locale.US, " d5=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block35;
                }
                case 20: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block35;
                    builder.append(String.format(Locale.US, " d6=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block35;
                }
                case 21: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block35;
                    builder.append(String.format(Locale.US, " d7=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block35;
                }
                case 22: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block35;
                    builder.append("\n>>>");
                    builder.append(String.format(Locale.US, " d8=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block35;
                }
                case 23: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block35;
                    builder.append(String.format(Locale.US, " d9=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block35;
                }
                case 24: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block35;
                    builder.append(String.format(Locale.US, " d10=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block35;
                }
                case 25: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block35;
                    builder.append(String.format(Locale.US, " d11=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block35;
                }
                case 26: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block35;
                    builder.append(String.format(Locale.US, " d12=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block35;
                }
                case 27: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block35;
                    builder.append(String.format(Locale.US, " d13=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block35;
                }
                case 28: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block35;
                    builder.append(String.format(Locale.US, " d14=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block35;
                }
                case 29: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block35;
                    builder.append(String.format(Locale.US, " d15=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                }
            }
        }
        System.out.println(builder);
    }

    public static void showRegs64(Emulator<?> emulator, int[] regs) {
        Backend backend = emulator.getBackend();
        if (regs == null || regs.length < 1) {
            regs = ARM.getAll64Registers();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(">>>");
        block68: for (int reg : regs) {
            switch (reg) {
                case 3: {
                    Cpsr cpsr = Cpsr.getArm64(backend);
                    if (cpsr.isA32()) {
                        builder.append(String.format(Locale.US, " cpsr: N=%d, Z=%d, C=%d, V=%d, T=%d, mode=0b", cpsr.isNegative() ? 1 : 0, cpsr.isZero() ? 1 : 0, cpsr.hasCarry() ? 1 : 0, cpsr.isOverflow() ? 1 : 0, cpsr.isThumb() ? 1 : 0)).append(Integer.toBinaryString(cpsr.getMode()));
                        continue block68;
                    }
                    int el = cpsr.getEL();
                    builder.append(String.format(Locale.US, "\nnzcv: N=%d, Z=%d, C=%d, V=%d, EL%d, use SP_EL", cpsr.isNegative() ? 1 : 0, cpsr.isZero() ? 1 : 0, cpsr.hasCarry() ? 1 : 0, cpsr.isOverflow() ? 1 : 0, el)).append((cpsr.getValue() & 1) == 0 ? 0 : el);
                    continue block68;
                }
                case 199: {
                    int iv;
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " x0=0x%x", value));
                    if (value < 0L) {
                        builder.append('(').append(value).append(')');
                        continue block68;
                    }
                    if ((value & 0x7FFFFFFF00000000L) != 0L || (iv = (int)value) >= 0) continue block68;
                    builder.append('(').append(iv).append(')');
                    continue block68;
                }
                case 200: {
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " x1=0x%x", value));
                    continue block68;
                }
                case 201: {
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " x2=0x%x", value));
                    continue block68;
                }
                case 202: {
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " x3=0x%x", value));
                    continue block68;
                }
                case 203: {
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " x4=0x%x", value));
                    continue block68;
                }
                case 204: {
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " x5=0x%x", value));
                    continue block68;
                }
                case 205: {
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " x6=0x%x", value));
                    continue block68;
                }
                case 206: {
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " x7=0x%x", value));
                    continue block68;
                }
                case 207: {
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " x8=0x%x", value));
                    continue block68;
                }
                case 208: {
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " x9=0x%x", value));
                    continue block68;
                }
                case 209: {
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " x10=0x%x", value));
                    continue block68;
                }
                case 210: {
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " x11=0x%x", value));
                    continue block68;
                }
                case 211: {
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " x12=0x%x", value));
                    continue block68;
                }
                case 212: {
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " x13=0x%x", value));
                    continue block68;
                }
                case 213: {
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " x14=0x%x", value));
                    continue block68;
                }
                case 214: {
                    builder.append("\n>>>");
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " x15=0x%x", value));
                    continue block68;
                }
                case 215: {
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " x16=0x%x", value));
                    continue block68;
                }
                case 216: {
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " x17=0x%x", value));
                    continue block68;
                }
                case 217: {
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " x18=0x%x", value));
                    continue block68;
                }
                case 218: {
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " x19=0x%x", value));
                    continue block68;
                }
                case 219: {
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " x20=0x%x", value));
                    continue block68;
                }
                case 220: {
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " x21=0x%x", value));
                    continue block68;
                }
                case 221: {
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " x22=0x%x", value));
                    continue block68;
                }
                case 222: {
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " x23=0x%x", value));
                    continue block68;
                }
                case 223: {
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " x24=0x%x", value));
                    continue block68;
                }
                case 224: {
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " x25=0x%x", value));
                    continue block68;
                }
                case 225: {
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " x26=0x%x", value));
                    continue block68;
                }
                case 226: {
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " x27=0x%x", value));
                    continue block68;
                }
                case 227: {
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " x28=0x%x", value));
                    continue block68;
                }
                case 1: {
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, " fp=0x%x", value));
                    continue block68;
                }
                case 4: {
                    Number number = backend.reg_read(reg);
                    long value = number.longValue();
                    builder.append(String.format(Locale.US, "\nSP=0x%x", value));
                    continue block68;
                }
                case 2: {
                    UnidbgPointer lr = UnidbgPointer.register(emulator, 2);
                    builder.append(String.format(Locale.US, "\nLR=%s", lr));
                    continue block68;
                }
                case 260: {
                    UnidbgPointer pc = UnidbgPointer.register(emulator, 260);
                    builder.append(String.format(Locale.US, "\nPC=%s", pc));
                    continue block68;
                }
                case 104: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append("\n>>>");
                    builder.append(String.format(Locale.US, " q0=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 105: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q1=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 106: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q2=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 107: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q3=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 108: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q4=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 109: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q5=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 110: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q6=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 111: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q7=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 112: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q8=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 113: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q9=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 114: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q10=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 115: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q11=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 116: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q12=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 117: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q13=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 118: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q14=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 119: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q15=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 120: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append("\n>>>");
                    builder.append(String.format(Locale.US, " q16=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 121: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q17=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 122: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q18=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 123: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q19=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 124: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q20=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 125: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q21=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 126: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q22=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 127: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q23=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 128: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q24=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 129: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q25=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 130: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q26=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 131: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q27=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 132: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q28=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 133: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q29=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 134: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q30=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                    continue block68;
                }
                case 135: {
                    byte[] data2 = backend.reg_read_vector(reg);
                    if (data2 == null) continue block68;
                    builder.append(String.format(Locale.US, " q31=0x%s%s", ARM.newBigInteger(data2).toString(16), Utils.decodeVectorRegister(data2)));
                }
            }
        }
        System.out.println(builder);
    }

    private static BigInteger newBigInteger(byte[] data2) {
        if (data2.length != 16) {
            throw new IllegalStateException("data.length=" + data2.length);
        }
        byte[] copy = Arrays.copyOf(data2, data2.length);
        for (int i = 0; i < 8; ++i) {
            byte b = copy[i];
            copy[i] = copy[15 - i];
            copy[15 - i] = b;
        }
        byte[] bytes = new byte[copy.length + 1];
        System.arraycopy(copy, 0, bytes, 1, copy.length);
        return new BigInteger(bytes);
    }

    private static int[] getRegArgs(Emulator<?> emulator) {
        return emulator.is32Bit() ? ARM_ARG_REGS : ARM64_ARG_REGS;
    }

    public static int[] getAllRegisters(boolean thumb) {
        return thumb ? THUMB_REGS : ARM_REGS;
    }

    public static int[] getAll64Registers() {
        return ARM64_REGS;
    }

    public static int alignSize(int size) {
        return (int)ARM.alignSize(size, 16L);
    }

    public static Alignment align(long addr, long size, long alignment) {
        long mask = -alignment;
        long right = addr + size;
        right = right + alignment - 1L & mask;
        size = right - (addr &= mask);
        size = size + alignment - 1L & mask;
        return new Alignment(addr, size);
    }

    public static long alignSize(long size, long align) {
        return ((size - 1L) / align + 1L) * align;
    }

    static String assembleDetail(Emulator<?> emulator, Instruction ins, long address, boolean thumb, int maxLengthLibraryName) {
        return ARM.assembleDetail(emulator, ins, address, thumb, false, maxLengthLibraryName);
    }

    private static void appendMemoryDetails32(Emulator<?> emulator, Instruction ins, OpInfo opInfo, boolean thumb, StringBuilder sb) {
        long base_value;
        UnidbgPointer base;
        Memory memory = emulator.getMemory();
        capstone.api.arm.MemType mem = null;
        long addr = -1L;
        capstone.api.arm.Operand[] op = opInfo.getOperands();
        if (op.length == 2 && op[0].getType() == 1 && op[1].getType() == 3) {
            OpShift shift;
            mem = op[1].getValue().getMem();
            if (mem.getIndex() == 0 && mem.getScale() == 1 && mem.getLshift() == 0) {
                base = UnidbgPointer.register(emulator, ins.mapToUnicornReg(mem.getBase()));
                long base_value2 = base == null ? 0L : base.peer;
                addr = base_value2 + (long)mem.getDisp();
            }
            if (mem.getIndex() > 0 && mem.getScale() == 1 && mem.getLshift() == 0 && mem.getDisp() == 0 && (shift = op[1].getShift()) != null) {
                int index_value;
                UnidbgPointer base2 = UnidbgPointer.register(emulator, ins.mapToUnicornReg(mem.getBase()));
                base_value = base2 == null ? 0L : base2.peer;
                UnidbgPointer index = UnidbgPointer.register(emulator, ins.mapToUnicornReg(mem.getIndex()));
                int n = index_value = index == null ? 0 : (int)index.peer;
                if (shift.getType() == 2) {
                    addr = base_value + ((long)index_value << shift.getValue());
                } else if (shift.getType() == 0) {
                    addr = base_value + (long)index_value;
                }
            }
        }
        if (op.length == 3 && op[0].getType() == 1 && op[1].getType() == 3 && op[2].getType() == 2 && (mem = op[1].getValue().getMem()).getIndex() == 0 && mem.getScale() == 1 && mem.getLshift() == 0) {
            base = UnidbgPointer.register(emulator, ins.mapToUnicornReg(mem.getBase()));
            long l = addr = base == null ? 0L : base.peer;
        }
        if (addr != -1L) {
            if (ins.mapToUnicornReg(mem.getBase()) == 11) {
                addr += (long)(thumb ? 4 : 8);
            }
            int bytesRead = 4;
            if (ins.getMnemonic().startsWith("ldrb") || ins.getMnemonic().startsWith("strb")) {
                bytesRead = 1;
            }
            if (ins.getMnemonic().startsWith("ldrh") || ins.getMnemonic().startsWith("strh")) {
                bytesRead = 2;
            }
            ARM.appendAddrValue(sb, addr, memory, emulator.is64Bit(), bytesRead);
            return;
        }
        if ("ldrd".equals(ins.getMnemonic()) && op.length == 3 && op[0].getType() == 1 && op[1].getType() == 1 && op[2].getType() == 3 && (mem = op[2].getValue().getMem()).getIndex() == 0 && mem.getScale() == 1 && mem.getLshift() == 0) {
            int regId = ins.mapToUnicornReg(mem.getBase());
            UnidbgPointer base3 = UnidbgPointer.register(emulator, regId);
            base_value = base3 == null ? 0L : base3.peer;
            addr = base_value + (long)mem.getDisp();
            if (regId == 11) {
                addr += (long)(thumb ? 4 : 8);
            }
            ARM.appendAddrValue(sb, addr, memory, emulator.is64Bit(), 4);
            ARM.appendAddrValue(sb, addr + (long)emulator.getPointerSize(), memory, emulator.is64Bit(), 4);
        }
    }

    private static void appendMemoryDetails64(Emulator<?> emulator, Instruction ins, capstone.api.arm64.OpInfo opInfo, StringBuilder sb) {
        UnidbgPointer base;
        MemType mem;
        int regId;
        Memory memory = emulator.getMemory();
        long addr = -1L;
        int bytesRead = 8;
        Operand[] op = opInfo.getOperands();
        if (op.length == 2 && op[0].getType() == 1 && op[1].getType() == 3) {
            regId = ins.mapToUnicornReg(op[0].getValue().getReg());
            if (regId >= 168 && regId <= 198) {
                bytesRead = 4;
            }
            if ((mem = op[1].getValue().getMem()).getIndex() == 0) {
                base = UnidbgPointer.register(emulator, ins.mapToUnicornReg(mem.getBase()));
                long base_value = base == null ? 0L : base.peer;
                addr = base_value + (long)mem.getDisp();
            }
        }
        if (op.length == 3 && op[0].getType() == 1 && op[1].getType() == 3 && op[2].getType() == 2) {
            regId = ins.mapToUnicornReg(op[0].getValue().getReg());
            if (regId >= 168 && regId <= 198) {
                bytesRead = 4;
            }
            if ((mem = op[1].getValue().getMem()).getIndex() == 0) {
                base = UnidbgPointer.register(emulator, ins.mapToUnicornReg(mem.getBase()));
                addr = base == null ? 0L : base.peer;
                addr += (long)mem.getDisp();
            }
        }
        if (addr != -1L) {
            if (ins.getMnemonic().startsWith("ldrb") || ins.getMnemonic().startsWith("strb")) {
                bytesRead = 1;
            }
            if (ins.getMnemonic().startsWith("ldrh") || ins.getMnemonic().startsWith("strh")) {
                bytesRead = 2;
            }
            ARM.appendAddrValue(sb, addr, memory, emulator.is64Bit(), bytesRead);
        }
    }

    public static void appendHex(StringBuilder builder, long value, int width, char placeholder, boolean reverse) {
        builder.append("0x");
        String hex = Long.toHexString(value);
        ARM.appendHex(builder, hex, width, placeholder, reverse);
    }

    public static void appendHex(StringBuilder builder, String str, int width, char placeholder, boolean reverse) {
        if (reverse) {
            builder.append(str);
            for (int i = 0; i < width - str.length(); ++i) {
                builder.append(placeholder);
            }
        } else {
            for (int i = 0; i < width - str.length(); ++i) {
                builder.append(placeholder);
            }
            builder.append(str);
        }
    }

    public static String assembleDetail(Emulator<?> emulator, Instruction ins, long address, boolean thumb, boolean current, int maxLengthLibraryName) {
        Module module;
        SvcMemory svcMemory = emulator.getSvcMemory();
        MemRegion region = svcMemory.findRegion(address);
        Memory memory = emulator.getMemory();
        char space = current ? (char)'*' : ' ';
        StringBuilder builder = new StringBuilder();
        Module module2 = module = region != null ? null : memory.findModuleByAddress(address);
        if (module != null) {
            builder.append('[');
            ARM.appendHex(builder, module.name, maxLengthLibraryName, ' ', true);
            builder.append(space);
            ARM.appendHex(builder, address - module.base + (long)(thumb ? 1 : 0), Long.toHexString(memory.getMaxSizeOfLibrary()).length(), '0', false);
            builder.append(']').append(space);
        } else if (address >= svcMemory.getBase()) {
            builder.append('[');
            if (region == null) {
                ARM.appendHex(builder, "0x" + Long.toHexString(address), maxLengthLibraryName, ' ', true);
            } else {
                ARM.appendHex(builder, region.getName().substring(0, Math.min(maxLengthLibraryName, region.getName().length())), maxLengthLibraryName, ' ', true);
            }
            builder.append(space);
            ARM.appendHex(builder, address - svcMemory.getBase() + (long)(thumb ? 1 : 0), Long.toHexString(memory.getMaxSizeOfLibrary()).length(), '0', false);
            builder.append(']').append(space);
        }
        builder.append("[");
        ARM.appendHex(builder, Hex.encodeHexString(ins.getBytes()), 8, ' ', true);
        builder.append("]");
        builder.append(space);
        ARM.appendHex(builder, ins.getAddress(), 8, '0', false);
        builder.append(":").append(space);
        builder.append('\"').append(ins).append('\"');
        OpInfo opInfo = null;
        capstone.api.arm64.OpInfo opInfo64 = null;
        if (ins.getOperands() instanceof OpInfo) {
            opInfo = (OpInfo)ins.getOperands();
        }
        if (ins.getOperands() instanceof capstone.api.arm64.OpInfo) {
            opInfo64 = (capstone.api.arm64.OpInfo)ins.getOperands();
        }
        if (current && (ins.getMnemonic().startsWith("ldr") || ins.getMnemonic().startsWith("str")) && opInfo != null) {
            ARM.appendMemoryDetails32(emulator, ins, opInfo, thumb, builder);
        }
        if (current && (ins.getMnemonic().startsWith("ldr") || ins.getMnemonic().startsWith("str")) && opInfo64 != null) {
            ARM.appendMemoryDetails64(emulator, ins, opInfo64, builder);
        }
        return builder.toString();
    }

    private static void appendAddrValue(StringBuilder sb, long addr, Memory memory, boolean is64Bit, int bytesRead) {
        long mask = -bytesRead;
        UnidbgPointer pointer = memory.pointer(addr & mask);
        sb.append(" [0x").append(Long.toHexString(addr)).append(']');
        try {
            if (is64Bit) {
                if (pointer != null) {
                    int iv;
                    long value;
                    switch (bytesRead) {
                        case 1: {
                            value = ((Pointer)pointer).getByte(0L) & 0xFF;
                            break;
                        }
                        case 2: {
                            value = ((Pointer)pointer).getShort(0L) & 0xFFFF;
                            break;
                        }
                        case 4: {
                            value = ((Pointer)pointer).getInt(0L);
                            break;
                        }
                        case 8: {
                            value = ((Pointer)pointer).getLong(0L);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("bytesRead=" + bytesRead);
                        }
                    }
                    sb.append(" => 0x").append(Long.toHexString(value));
                    if (value < 0L) {
                        sb.append(" (-0x").append(Long.toHexString(-value)).append(')');
                    } else if ((value & 0x7FFFFFFF00000000L) == 0L && (iv = (int)value) < 0) {
                        sb.append(" (-0x").append(Integer.toHexString(-iv)).append(')');
                    }
                } else {
                    sb.append(" => null");
                }
            } else {
                int value;
                switch (bytesRead) {
                    case 1: {
                        value = ((Pointer)pointer).getByte(0L) & 0xFF;
                        break;
                    }
                    case 2: {
                        value = ((Pointer)pointer).getShort(0L) & 0xFFFF;
                        break;
                    }
                    case 4: {
                        value = ((Pointer)pointer).getInt(0L);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("bytesRead=" + bytesRead);
                    }
                }
                sb.append(" => 0x").append(Long.toHexString((long)value & 0xFFFFFFFFL));
                if (value < 0) {
                    sb.append(" (-0x").append(Integer.toHexString(-value)).append(")");
                }
            }
        }
        catch (RuntimeException exception) {
            sb.append(" => ").append(exception.getMessage());
        }
    }

    public static void initArgs(Emulator<?> emulator, boolean padding, Number ... arguments) {
        Backend backend = emulator.getBackend();
        Memory memory = emulator.getMemory();
        int[] regArgs = ARM.getRegArgs(emulator);
        ArrayList<Number> argList = new ArrayList<Number>(arguments.length * 2);
        int regVector = 104;
        for (Number arg : arguments) {
            ByteBuffer buffer;
            if (emulator.is64Bit()) {
                if (arg instanceof Float) {
                    buffer = ByteBuffer.allocate(16);
                    buffer.order(ByteOrder.LITTLE_ENDIAN);
                    buffer.putFloat(((Float)arg).floatValue());
                    emulator.getBackend().reg_write_vector(regVector++, buffer.array());
                    continue;
                }
                if (arg instanceof Double) {
                    buffer = ByteBuffer.allocate(16);
                    buffer.order(ByteOrder.LITTLE_ENDIAN);
                    buffer.putDouble((Double)arg);
                    emulator.getBackend().reg_write_vector(regVector++, buffer.array());
                    continue;
                }
                argList.add(arg);
                continue;
            }
            if (arg instanceof Long) {
                if (log.isDebugEnabled()) {
                    log.debug("initLongArgs size=" + argList.size() + ", length=" + regArgs.length, new Exception("initArgs long=" + arg));
                }
                if (padding && argList.size() % 2 != 0) {
                    argList.add(0);
                }
                buffer = ByteBuffer.allocate(8);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                buffer.putLong((Long)arg);
                buffer.flip();
                int v1 = buffer.getInt();
                int v2 = buffer.getInt();
                argList.add(v1);
                argList.add(v2);
                continue;
            }
            if (arg instanceof Double) {
                if (log.isDebugEnabled()) {
                    log.debug("initDoubleArgs size=" + argList.size() + ", length=" + regArgs.length, new Exception("initArgs double=" + arg));
                }
                if (padding && argList.size() % 2 != 0) {
                    argList.add(0);
                }
                buffer = ByteBuffer.allocate(8);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                buffer.putDouble((Double)arg);
                buffer.flip();
                argList.add(buffer.getInt());
                argList.add(buffer.getInt());
                continue;
            }
            if (arg instanceof Float) {
                if (log.isDebugEnabled()) {
                    log.debug("initFloatArgs size=" + argList.size() + ", length=" + regArgs.length, new Exception("initArgs float=" + arg));
                }
                buffer = ByteBuffer.allocate(4);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                buffer.putFloat(((Float)arg).floatValue());
                buffer.flip();
                argList.add(buffer.getInt());
                continue;
            }
            argList.add(arg);
        }
        Arguments args = new Arguments(memory, argList.toArray(new Number[0]));
        ArrayList list = new ArrayList();
        if (args.args != null) {
            Collections.addAll(list, args.args);
        }
        for (int i = 0; !list.isEmpty() && i < regArgs.length; ++i) {
            backend.reg_write(regArgs[i], (Number)list.remove(0));
        }
        Collections.reverse(list);
        if (list.size() % 2 != 0) {
            memory.allocateStack(emulator.getPointerSize());
        }
        while (!list.isEmpty()) {
            Number number = (Number)list.remove(0);
            UnidbgPointer pointer = memory.allocateStack(emulator.getPointerSize());
            assert (pointer != null);
            if (emulator.is64Bit()) {
                if (pointer.peer % 8L != 0L) {
                    log.warn("initArgs pointer=" + pointer);
                }
                pointer.setLong(0L, number.longValue());
                continue;
            }
            if (pointer.toUIntPeer() % 4L != 0L) {
                log.warn("initArgs pointer=" + pointer);
            }
            pointer.setInt(0L, number.intValue());
        }
    }

    public static UnidbgPointer adjust_ip(UnidbgPointer ip) {
        int value;
        boolean thumb;
        int adjust = 4;
        boolean bl = thumb = (ip.peer & 1L) == 1L;
        if (thumb && ((long)(value = ip.share(-5L).getInt(0L)) & 0xE000F000L) != 0xE000F000L) {
            adjust = 2;
        }
        return ip.share(-adjust, 0L);
    }
}

