/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.Arm64Svc;
import com.github.unidbg.arm.HookStatus;
import com.github.unidbg.arm.RegContext;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import keystone.Keystone;
import keystone.KeystoneArchitecture;
import keystone.KeystoneEncoded;
import keystone.KeystoneMode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Arm64Hook
extends Arm64Svc {
    private static final Log log = LogFactory.getLog(Arm64Hook.class);
    private final boolean enablePostCall;
    private RegContext regContext;

    protected Arm64Hook() {
        this(false);
    }

    protected Arm64Hook(boolean enablePostCall) {
        this.enablePostCall = enablePostCall;
    }

    public Arm64Hook(String name, boolean enablePostCall) {
        super(name);
        this.enablePostCall = enablePostCall;
    }

    @Override
    public final UnidbgPointer onRegister(SvcMemory svcMemory, int svcNumber) {
        byte[] code;
        if (this.enablePostCall) {
            try (Keystone keystone = new Keystone(KeystoneArchitecture.Arm64, KeystoneMode.LittleEndian);){
                KeystoneEncoded encoded = keystone.assemble(Arrays.asList("svc #0x" + Integer.toHexString(svcNumber), "ldr x13, [sp]", "add sp, sp, #0x8", "cmp x13, #0", "b.eq #0x30", "blr x13", "mov x8, #0", "mov x12, #0x" + Integer.toHexString(svcNumber), "mov x16, #0x" + Integer.toHexString(34952), "svc #0", "ret"));
                code = encoded.getMachineCode();
            }
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(12);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(Arm64Svc.assembleSvc(svcNumber));
            buffer.putInt(-129988623);
            buffer.putInt(-702610912);
            code = buffer.array();
        }
        String name = this.getName();
        UnidbgPointer pointer = svcMemory.allocate(code.length, name == null ? "Arm64Hook" : name);
        pointer.write(0L, code, 0, code.length);
        if (log.isDebugEnabled()) {
            log.debug("ARM64 hook: pointer=" + pointer);
        }
        return pointer;
    }

    @Override
    public void handlePostCallback(Emulator<?> emulator) {
        super.handlePostCallback(emulator);
        if (this.regContext == null) {
            throw new IllegalStateException();
        }
        this.regContext.restore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long handle(Emulator<?> emulator) {
        Backend backend = emulator.getBackend();
        if (this.enablePostCall) {
            this.regContext = RegContext.backupContext(emulator, 1, 2);
        }
        UnidbgPointer sp = UnidbgPointer.register(emulator, 4);
        try {
            HookStatus status = this.hook(emulator);
            if (status.forward || !this.enablePostCall) {
                sp = sp.share(-8L, 0L);
                sp.setLong(0L, status.jump);
            } else {
                sp = sp.share(-8L, 0L);
                sp.setLong(0L, 0L);
            }
            long l = status.returnValue;
            return l;
        }
        finally {
            backend.reg_write(4, sp.peer);
        }
    }

    protected abstract HookStatus hook(Emulator<?> var1);
}

