/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm;

import com.github.unidbg.Emulator;
import com.github.unidbg.Svc;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Arm64Svc
implements Svc {
    private static final Log log = LogFactory.getLog(Arm64Svc.class);
    public static final int SVC_MAX = 65535;
    private final String name;

    public static int assembleSvc(int svcNumber) {
        if (svcNumber >= 0 && svcNumber < 65534) {
            return 0xD4000001 | svcNumber << 5;
        }
        throw new IllegalStateException("svcNumber=0x" + Integer.toHexString(svcNumber));
    }

    public Arm64Svc() {
        this(null);
    }

    public Arm64Svc(String name) {
        this.name = name;
    }

    @Override
    public UnidbgPointer onRegister(SvcMemory svcMemory, int svcNumber) {
        String name;
        if (log.isDebugEnabled()) {
            log.debug("onRegister: " + this.getClass(), new Exception("svcNumber=0x" + Integer.toHexString(svcNumber)));
        }
        return Arm64Svc.register(svcMemory, svcNumber, (name = this.getName()) == null ? "Arm64Svc" : name);
    }

    private static UnidbgPointer register(SvcMemory svcMemory, int svcNumber, String name) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(Arm64Svc.assembleSvc(svcNumber));
        buffer.putInt(-698416192);
        byte[] code = buffer.array();
        UnidbgPointer pointer = svcMemory.allocate(code.length, name);
        pointer.write(0L, code, 0, code.length);
        return pointer;
    }

    @Override
    public void handlePostCallback(Emulator<?> emulator) {
    }

    @Override
    public void handlePreCallback(Emulator<?> emulator) {
    }

    @Override
    public String getName() {
        return this.name;
    }
}

