/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm;

import com.github.unidbg.Emulator;
import com.github.unidbg.Svc;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class ArmSvc
implements Svc {
    public static final int SVC_MAX = 0xFFFFFF;
    private final String name;

    public static int assembleSvc(int svcNumber) {
        if (svcNumber >= 0 && svcNumber < 0xFFFFFE) {
            return 0xEF000000 | svcNumber;
        }
        throw new IllegalStateException("svcNumber=0x" + Integer.toHexString(svcNumber));
    }

    public ArmSvc() {
        this(null);
    }

    public ArmSvc(String name) {
        this.name = name;
    }

    @Override
    public UnidbgPointer onRegister(SvcMemory svcMemory, int svcNumber) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(ArmSvc.assembleSvc(svcNumber));
        buffer.putInt(-516948194);
        byte[] code = buffer.array();
        String name = this.getName();
        UnidbgPointer pointer = svcMemory.allocate(code.length, name == null ? "ArmSvc" : name);
        pointer.write(code);
        return pointer;
    }

    @Override
    public void handlePostCallback(Emulator<?> emulator) {
    }

    @Override
    public void handlePreCallback(Emulator<?> emulator) {
    }

    @Override
    public String getName() {
        return this.name;
    }
}

