/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm;

import capstone.api.Disassembler;
import capstone.api.DisassemblerFactory;
import capstone.api.Instruction;
import com.github.unidbg.Emulator;
import com.github.unidbg.arm.ARM;
import com.github.unidbg.arm.ArmSvc;
import com.github.unidbg.arm.ThumbSvc;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.hook.HookCallback;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import com.sun.jna.Pointer;
import java.io.IOException;
import java.util.Arrays;
import keystone.Keystone;
import keystone.KeystoneArchitecture;
import keystone.KeystoneEncoded;
import keystone.KeystoneMode;

public class InlineHook {
    public static void simpleThumbHook(Emulator<?> emulator, long address, final HookCallback callback2) {
        final Backend backend = emulator.getBackend();
        final UnidbgPointer pointer = UnidbgPointer.pointer(emulator, address);
        if (pointer == null) {
            throw new IllegalArgumentException();
        }
        try (Disassembler disassembler = DisassemblerFactory.createArmDisassembler(true);){
            disassembler.setDetail(true);
            byte[] code = InlineHook.readThumbCode(pointer);
            Instruction[] insns = disassembler.disasm(code, 0L, 1L);
            if (insns == null || insns.length < 1) {
                throw new IllegalArgumentException("Invalid hook address: " + pointer);
            }
            Instruction insn = insns[0];
            String asm = insn.toString();
            if (!"push {r4, r5, r6, r7, lr}".equals(asm)) {
                throw new IllegalArgumentException("Invalid hook address: " + pointer + ", asm: " + asm);
            }
            emulator.getSvcMemory().registerSvc(new ThumbSvc(){

                @Override
                public UnidbgPointer onRegister(SvcMemory svcMemory, int svcNumber) {
                    if (svcNumber < 0 || svcNumber > 255) {
                        throw new IllegalStateException("service number out of range");
                    }
                    try (Keystone keystone = new Keystone(KeystoneArchitecture.Arm, KeystoneMode.ArmThumb);){
                        KeystoneEncoded encoded = keystone.assemble(Arrays.asList("svc #0x" + Integer.toHexString(svcNumber), "mov pc, lr"));
                        byte[] code = encoded.getMachineCode();
                        pointer.write(0L, code, 0, code.length);
                        UnidbgPointer unidbgPointer = null;
                        return unidbgPointer;
                    }
                }

                @Override
                public long handle(Emulator<?> emulator) {
                    if (callback2 != null) {
                        return callback2.onHook(emulator);
                    }
                    return backend.reg_read(66).intValue();
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void simpleArmHook(Emulator<?> emulator, long address, final HookCallback callback2) {
        final UnidbgPointer pointer = UnidbgPointer.pointer(emulator, address);
        if (pointer == null) {
            throw new IllegalArgumentException();
        }
        try (Disassembler disassembler = DisassemblerFactory.createArmDisassembler(false);){
            disassembler.setDetail(true);
            byte[] code = ((Pointer)pointer).getByteArray(0L, 4);
            Instruction[] insns = disassembler.disasm(code, 0L, 1L);
            if (insns == null || insns.length < 1) {
                throw new IllegalArgumentException("Invalid hook address: " + pointer);
            }
            Instruction insn = insns[0];
            String asm = insn.toString();
            if (!"push {r4, r5, r6, r7, r8, sb, lr}".equals(asm) && !"push {r4, r5, r6, r7, r8, sb, sl, fp, lr}".equals(asm)) {
                throw new IllegalArgumentException("Invalid hook address: " + pointer + ", asm: " + asm);
            }
            emulator.getSvcMemory().registerSvc(new ArmSvc(){

                @Override
                public UnidbgPointer onRegister(SvcMemory svcMemory, int svcNumber) {
                    try (Keystone keystone = new Keystone(KeystoneArchitecture.Arm, KeystoneMode.Arm);){
                        KeystoneEncoded encoded = keystone.assemble(Arrays.asList("svc #0x" + Integer.toHexString(svcNumber), "mov pc, lr"));
                        byte[] code = encoded.getMachineCode();
                        pointer.write(0L, code, 0, code.length);
                        UnidbgPointer unidbgPointer = null;
                        return unidbgPointer;
                    }
                }

                @Override
                public long handle(Emulator<?> emulator) {
                    if (callback2 != null) {
                        return callback2.onHook(emulator);
                    }
                    return emulator.getBackend().reg_read(66).intValue();
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static byte[] readThumbCode(Pointer pointer) {
        short ins = pointer.getShort(0L);
        if (ARM.isThumb32(ins)) {
            return pointer.getByteArray(0L, 4);
        }
        return pointer.getByteArray(0L, 2);
    }
}

