/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm.backend.dynarmic;

import com.github.unidbg.arm.backend.dynarmic.DynarmicCallback;
import com.github.unidbg.arm.backend.dynarmic.DynarmicException;
import java.io.Closeable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Dynarmic
implements Closeable {
    private static final Log log = LogFactory.getLog(Dynarmic.class);
    private final long nativeHandle;

    private static native int setDynarmicCallback(long var0, DynarmicCallback var2);

    private static native long nativeInitialize(boolean var0);

    private static native void nativeDestroy(long var0);

    private static native int mem_unmap(long var0, long var2, long var4);

    private static native int mem_map(long var0, long var2, long var4, int var6);

    private static native int mem_protect(long var0, long var2, long var4, int var6);

    private static native int mem_write(long var0, long var2, byte[] var4);

    private static native byte[] mem_read(long var0, long var2, int var4);

    private static native long reg_read_pc64(long var0);

    private static native int reg_set_sp64(long var0, long var2);

    private static native long reg_read_sp64(long var0);

    private static native long reg_read_nzcv(long var0);

    private static native int reg_set_nzcv(long var0, long var2);

    private static native int reg_set_tpidr_el0(long var0, long var2);

    private static native int reg_set_tpidrro_el0(long var0, long var2);

    private static native int reg_set_vector(long var0, int var2, byte[] var3);

    private static native byte[] reg_read_vector(long var0, int var2);

    private static native int reg_write(long var0, int var2, long var3);

    private static native long reg_read(long var0, int var2);

    private static native int reg_read_cpsr(long var0);

    private static native int reg_write_cpsr(long var0, int var2);

    private static native int reg_write_c13_c0_3(long var0, int var2);

    private static native int emu_start(long var0, long var2);

    private static native int emu_stop(long var0);

    private static native long context_alloc(long var0);

    private static native void context_save(long var0, long var2);

    private static native void context_restore(long var0, long var2);

    public static native void free(long var0);

    public Dynarmic(boolean is64Bit) {
        this.nativeHandle = Dynarmic.nativeInitialize(is64Bit);
    }

    public long context_alloc() {
        return Dynarmic.context_alloc(this.nativeHandle);
    }

    public void context_save(long context) {
        Dynarmic.context_save(this.nativeHandle, context);
    }

    public void context_restore(long context) {
        Dynarmic.context_restore(this.nativeHandle, context);
    }

    public void setDynarmicCallback(DynarmicCallback callback2) {
        int ret;
        if (log.isDebugEnabled()) {
            log.debug("setDynarmicCallback callback" + callback2);
        }
        if ((ret = Dynarmic.setDynarmicCallback(this.nativeHandle, callback2)) != 0) {
            throw new DynarmicException("ret=" + ret);
        }
    }

    public void emu_start(long begin) {
        int ret = Dynarmic.emu_start(this.nativeHandle, begin);
        if (ret != 0) {
            throw new DynarmicException("ret=" + ret);
        }
    }

    public void emu_stop() {
        int ret;
        if (log.isDebugEnabled()) {
            log.debug("emu_stop");
        }
        if ((ret = Dynarmic.emu_stop(this.nativeHandle)) != 0) {
            throw new DynarmicException("ret=" + ret);
        }
    }

    public void mem_unmap(long address, long size) {
        long start = log.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        int ret = Dynarmic.mem_unmap(this.nativeHandle, address, size);
        if (log.isDebugEnabled()) {
            log.debug("mem_unmap address=0x" + Long.toHexString(address) + ", size=0x" + Long.toHexString(size) + ", offset=" + (System.currentTimeMillis() - start) + "ms");
        }
        if (ret != 0) {
            throw new DynarmicException("ret=" + ret);
        }
    }

    public void mem_map(long address, long size, int perms) {
        long start = log.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        int ret = Dynarmic.mem_map(this.nativeHandle, address, size, perms);
        if (log.isDebugEnabled()) {
            log.debug("mem_map address=0x" + Long.toHexString(address) + ", size=0x" + Long.toHexString(size) + ", perms=0b" + Integer.toBinaryString(perms) + ", offset=" + (System.currentTimeMillis() - start) + "ms");
        }
        if (ret != 0) {
            throw new DynarmicException("ret=" + ret);
        }
    }

    public void mem_protect(long address, long size, int perms) {
        long start = log.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        int ret = Dynarmic.mem_protect(this.nativeHandle, address, size, perms);
        if (log.isDebugEnabled()) {
            log.debug("mem_protect address=0x" + Long.toHexString(address) + ", size=0x" + Long.toHexString(size) + ", perms=0b" + Integer.toBinaryString(perms) + ", offset=" + (System.currentTimeMillis() - start) + "ms");
        }
        if (ret != 0) {
            throw new DynarmicException("ret=" + ret);
        }
    }

    public void reg_set_sp64(long value) {
        int ret;
        if (log.isDebugEnabled()) {
            log.debug("reg_set_sp64 value=0x" + Long.toHexString(value));
        }
        if ((ret = Dynarmic.reg_set_sp64(this.nativeHandle, value)) != 0) {
            throw new DynarmicException("ret=" + ret);
        }
    }

    public long reg_read_pc64() {
        long pc = Dynarmic.reg_read_pc64(this.nativeHandle);
        if (log.isDebugEnabled()) {
            log.debug("reg_read_pc64=0x" + Long.toHexString(pc));
        }
        return pc;
    }

    public long reg_read_sp64() {
        long sp = Dynarmic.reg_read_sp64(this.nativeHandle);
        if (log.isDebugEnabled()) {
            log.debug("reg_read_sp64=0x" + Long.toHexString(sp));
        }
        return sp;
    }

    public long reg_read_nzcv() {
        long nzcv = Dynarmic.reg_read_nzcv(this.nativeHandle);
        if (log.isDebugEnabled()) {
            log.debug("reg_read_nzcv=0x" + Long.toHexString(nzcv));
        }
        return nzcv;
    }

    public void reg_set_nzcv(long value) {
        int ret;
        if (log.isDebugEnabled()) {
            log.debug("reg_set_nzcv value=0x" + Long.toHexString(value));
        }
        if ((ret = Dynarmic.reg_set_nzcv(this.nativeHandle, value)) != 0) {
            throw new DynarmicException("ret=" + ret);
        }
    }

    public void reg_set_tpidr_el0(long value) {
        int ret;
        if (log.isDebugEnabled()) {
            log.debug("reg_set_tpidr_el0 value=0x" + Long.toHexString(value));
        }
        if ((ret = Dynarmic.reg_set_tpidr_el0(this.nativeHandle, value)) != 0) {
            throw new DynarmicException("ret=" + ret);
        }
    }

    public void reg_set_tpidrro_el0(long value) {
        int ret;
        if (log.isDebugEnabled()) {
            log.debug("reg_set_tpidrro_el0 value=0x" + Long.toHexString(value));
        }
        if ((ret = Dynarmic.reg_set_tpidrro_el0(this.nativeHandle, value)) != 0) {
            throw new DynarmicException("ret=" + ret);
        }
    }

    public void reg_set_vector(int index, byte[] vector) {
        int ret = Dynarmic.reg_set_vector(this.nativeHandle, index, vector);
        if (ret != 0) {
            throw new DynarmicException("ret=" + ret);
        }
    }

    public byte[] reg_read_vector(int index) {
        byte[] ret = Dynarmic.reg_read_vector(this.nativeHandle, index);
        if (ret == null) {
            throw new DynarmicException("ret is null");
        }
        return ret;
    }

    public void reg_write32(int index, long value) {
        int ret;
        if (index < 0 || index > 15) {
            throw new IllegalArgumentException("index=" + index);
        }
        value &= 0xFFFFFFFFL;
        if (log.isDebugEnabled()) {
            log.debug("reg_write32 index=" + index + ", value=0x" + Long.toHexString(value));
        }
        if ((ret = Dynarmic.reg_write(this.nativeHandle, index, value)) != 0) {
            throw new DynarmicException("ret=" + ret);
        }
    }

    public void reg_write_c13_c0_3(int value) {
        int ret;
        if (log.isDebugEnabled()) {
            log.debug("reg_write_c13_c0_3 value=0x" + Long.toHexString(value));
        }
        if ((ret = Dynarmic.reg_write_c13_c0_3(this.nativeHandle, value)) != 0) {
            throw new DynarmicException("ret=" + ret);
        }
    }

    public void reg_write64(int index, long value) {
        int ret;
        if (index < 0 || index > 30) {
            throw new IllegalArgumentException("index=" + index);
        }
        if (log.isDebugEnabled()) {
            log.debug("reg_write64 index=" + index + ", value=0x" + Long.toHexString(value));
        }
        if ((ret = Dynarmic.reg_write(this.nativeHandle, index, value)) != 0) {
            throw new DynarmicException("ret=" + ret);
        }
    }

    public int reg_read32(int index) {
        if (index < 0 || index > 15) {
            throw new IllegalArgumentException("index=" + index);
        }
        if (log.isDebugEnabled()) {
            log.debug("reg_read32 index=" + index);
        }
        return (int)(Dynarmic.reg_read(this.nativeHandle, index) & 0xFFFFFFFFL);
    }

    public int reg_read_cpsr() {
        if (log.isDebugEnabled()) {
            log.debug("reg_read_cpsr");
        }
        return Dynarmic.reg_read_cpsr(this.nativeHandle);
    }

    public void reg_write_cpsr(int value) {
        int ret;
        if (log.isDebugEnabled()) {
            log.debug("reg_write_cpsr value=0x" + Integer.toHexString(value));
        }
        if ((ret = Dynarmic.reg_write_cpsr(this.nativeHandle, value)) != 0) {
            throw new DynarmicException("ret=" + ret);
        }
    }

    public long reg_read64(int index) {
        if (index < 0 || index > 30) {
            throw new IllegalArgumentException("index=" + index);
        }
        if (log.isDebugEnabled()) {
            log.debug("reg_read64 index=" + index);
        }
        return Dynarmic.reg_read(this.nativeHandle, index);
    }

    public void mem_write(long address, byte[] bytes) {
        long start = log.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        int ret = Dynarmic.mem_write(this.nativeHandle, address, bytes);
        if (log.isDebugEnabled()) {
            log.debug("mem_write address=0x" + Long.toHexString(address) + ", size=" + bytes.length + ", offset=" + (System.currentTimeMillis() - start) + "ms");
        }
        if (ret != 0) {
            throw new DynarmicException("ret=" + ret);
        }
    }

    public byte[] mem_read(long address, int size) {
        long start = log.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        byte[] ret = Dynarmic.mem_read(this.nativeHandle, address, size);
        if (log.isDebugEnabled()) {
            log.debug("mem_read address=0x" + Long.toHexString(address) + ", size=" + size + ", offset=" + (System.currentTimeMillis() - start) + "ms");
        }
        if (ret == null) {
            throw new DynarmicException();
        }
        return ret;
    }

    @Override
    public void close() {
        Dynarmic.nativeDestroy(this.nativeHandle);
    }
}

