/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm.backend.unicorn;

import com.github.unidbg.arm.backend.unicorn.BlockHook;
import com.github.unidbg.arm.backend.unicorn.CodeHook;
import com.github.unidbg.arm.backend.unicorn.DebugHook;
import com.github.unidbg.arm.backend.unicorn.EventMemHook;
import com.github.unidbg.arm.backend.unicorn.Hook;
import com.github.unidbg.arm.backend.unicorn.InterruptHook;
import com.github.unidbg.arm.backend.unicorn.ReadHook;
import com.github.unidbg.arm.backend.unicorn.WriteHook;
import com.github.unidbg.thread.ThreadContextSwitchException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import unicorn.UnicornException;

public class Unicorn {
    private static final Hashtable<Integer, Integer> eventMemMap = new Hashtable();
    private final List<UnHook> newHookList = new ArrayList<UnHook>();
    private final long nativeHandle;

    private static native long nativeInitialize(int var0, int var1) throws UnicornException;

    private static native void nativeDestroy(long var0) throws UnicornException;

    private static native void hook_del(long var0) throws UnicornException;

    public byte[] reg_read(int regid, int regsz) throws UnicornException {
        return Unicorn.reg_read(this.nativeHandle, regid, regsz);
    }

    private static native byte[] reg_read(long var0, int var2, int var3) throws UnicornException;

    public void reg_write(int regid, byte[] value) throws UnicornException {
        Unicorn.reg_write(this.nativeHandle, regid, value);
    }

    private static native void reg_write(long var0, int var2, byte[] var3) throws UnicornException;

    public long reg_read(int regid) throws UnicornException {
        return Unicorn.reg_read(this.nativeHandle, regid);
    }

    private static native long reg_read(long var0, int var2) throws UnicornException;

    public void reg_write(int regid, long value) throws UnicornException {
        Unicorn.reg_write(this.nativeHandle, regid, value);
    }

    private static native void reg_write(long var0, int var2, long var3) throws UnicornException;

    public UnHook registerEmuCountHook(long emu_count) {
        NewHook hook = new NewHook(new CodeHook(){

            @Override
            public void hook(Unicorn u, long address, int size, Object user) {
                throw new ThreadContextSwitchException();
            }
        }, null);
        return new UnHook(Unicorn.register_emu_count_hook(this.nativeHandle, emu_count, hook));
    }

    private static native long register_emu_count_hook(long var0, long var2, NewHook var4);

    public byte[] mem_read(long address, long size) throws UnicornException {
        return Unicorn.mem_read(this.nativeHandle, address, size);
    }

    private static native byte[] mem_read(long var0, long var2, long var4) throws UnicornException;

    public void mem_write(long address, byte[] bytes) throws UnicornException {
        Unicorn.mem_write(this.nativeHandle, address, bytes);
    }

    private static native void mem_write(long var0, long var2, byte[] var4) throws UnicornException;

    public void mem_map(long address, long size, int perms) throws UnicornException {
        Unicorn.mem_map(this.nativeHandle, address, size, perms);
    }

    private static native void mem_map(long var0, long var2, long var4, int var6) throws UnicornException;

    public void mem_protect(long address, long size, int perms) throws UnicornException {
        Unicorn.mem_protect(this.nativeHandle, address, size, perms);
    }

    private static native void mem_protect(long var0, long var2, long var4, int var6) throws UnicornException;

    public void mem_unmap(long address, long size) throws UnicornException {
        Unicorn.mem_unmap(this.nativeHandle, address, size);
    }

    private static native void mem_unmap(long var0, long var2, long var4) throws UnicornException;

    public void setFastDebug(boolean fastDebug) {
        Unicorn.setFastDebug(this.nativeHandle, fastDebug);
    }

    private static native void setFastDebug(long var0, boolean var2);

    public void setSingleStep(int singleStep) {
        Unicorn.setSingleStep(this.nativeHandle, singleStep);
    }

    private static native void setSingleStep(long var0, int var2);

    public void addBreakPoint(long address) {
        Unicorn.addBreakPoint(this.nativeHandle, address);
    }

    private static native void addBreakPoint(long var0, long var2);

    public void removeBreakPoint(long address) {
        Unicorn.removeBreakPoint(this.nativeHandle, address);
    }

    private static native void removeBreakPoint(long var0, long var2);

    private static native long registerHook(long var0, int var2, long var3, long var5, NewHook var7);

    private static native long registerHook(long var0, int var2, NewHook var3);

    private static native long registerDebugger(long var0, long var2, long var4, NewHook var6);

    public void emu_start(long begin, long until, long timeout, long count) throws UnicornException {
        Unicorn.emu_start(this.nativeHandle, begin, until, timeout, count);
    }

    private static native void emu_start(long var0, long var2, long var4, long var6, long var8) throws UnicornException;

    public void emu_stop() throws UnicornException {
        Unicorn.emu_stop(this.nativeHandle);
    }

    private static native void emu_stop(long var0) throws UnicornException;

    public long context_alloc() {
        return Unicorn.context_alloc(this.nativeHandle);
    }

    private static native long context_alloc(long var0);

    public static native void free(long var0);

    public void context_save(long context) {
        Unicorn.context_save(this.nativeHandle, context);
    }

    private static native void context_save(long var0, long var2);

    public void context_restore(long context) {
        Unicorn.context_restore(this.nativeHandle, context);
    }

    private static native void context_restore(long var0, long var2);

    public static native void testSampleArm();

    public static native void testSampleArm64();

    public UnHook hook_add_new(BlockHook callback2, long begin, long end, Object user_data) throws UnicornException {
        NewHook hook = new NewHook(callback2, user_data);
        long handle = Unicorn.registerHook(this.nativeHandle, 8, begin, end, hook);
        return new UnHook(handle);
    }

    public UnHook hook_add_new(InterruptHook callback2, Object user_data) throws UnicornException {
        NewHook hook = new NewHook(callback2, user_data);
        long handle = Unicorn.registerHook(this.nativeHandle, 1, hook);
        return new UnHook(handle);
    }

    public Map<Integer, UnHook> hook_add_new(EventMemHook callback2, int type, Object user_data) throws UnicornException {
        HashMap<Integer, UnHook> map = new HashMap<Integer, UnHook>(eventMemMap.size());
        for (Integer htype : eventMemMap.keySet()) {
            if ((type & htype) == 0) continue;
            NewHook hook = new NewHook(callback2, user_data);
            long handle = Unicorn.registerHook(this.nativeHandle, htype, hook);
            map.put(htype, new UnHook(handle));
        }
        return map;
    }

    public UnHook hook_add_new(ReadHook callback2, long begin, long end, Object user_data) throws UnicornException {
        NewHook hook = new NewHook(callback2, user_data);
        long handle = Unicorn.registerHook(this.nativeHandle, 1024, begin, end, hook);
        return new UnHook(handle);
    }

    public UnHook hook_add_new(WriteHook callback2, long begin, long end, Object user_data) throws UnicornException {
        NewHook hook = new NewHook(callback2, user_data);
        long handle = Unicorn.registerHook(this.nativeHandle, 2048, begin, end, hook);
        return new UnHook(handle);
    }

    public UnHook hook_add_new(CodeHook callback2, long begin, long end, Object user_data) throws UnicornException {
        NewHook hook = new NewHook(callback2, user_data);
        long handle = Unicorn.registerHook(this.nativeHandle, 4, begin, end, hook);
        return new UnHook(handle);
    }

    public UnHook debugger_add(DebugHook callback2, long begin, long end, Object user_data) throws UnicornException {
        NewHook hook = new NewHook(callback2, user_data);
        long handle = Unicorn.registerDebugger(this.nativeHandle, begin, end, hook);
        return new UnHook(handle);
    }

    public Unicorn(int arch, int mode) throws UnicornException {
        this.nativeHandle = Unicorn.nativeInitialize(arch, mode);
    }

    public void closeAll() throws UnicornException {
        for (UnHook unHook : this.newHookList) {
            unHook.unhookInternal();
        }
        Unicorn.nativeDestroy(this.nativeHandle);
    }

    static {
        eventMemMap.put(16, 19);
        eventMemMap.put(32, 20);
        eventMemMap.put(64, 21);
        eventMemMap.put(128, 23);
        eventMemMap.put(256, 22);
        eventMemMap.put(512, 24);
        eventMemMap.put(1024, 16);
        eventMemMap.put(2048, 17);
        eventMemMap.put(4096, 18);
        eventMemMap.put(8192, 25);
    }

    private class NewHook
    extends Tuple {
        public NewHook(Hook f, Object d) {
            super(f, d);
        }

        void onBlock(long address, int size) {
            BlockHook hook = (BlockHook)this.function;
            hook.hook(Unicorn.this, address, size, this.data);
        }

        void onCode(long address, int size) {
            CodeHook hook = (CodeHook)this.function;
            hook.hook(Unicorn.this, address, size, this.data);
        }

        void onBreak(long address, int size) {
            DebugHook hook = (DebugHook)this.function;
            hook.onBreak(Unicorn.this, address, size, this.data);
        }

        void onRead(long address, int size) {
            ReadHook hook = (ReadHook)this.function;
            hook.hook(Unicorn.this, address, size, this.data);
        }

        void onWrite(long address, int size, long value) {
            WriteHook hook = (WriteHook)this.function;
            hook.hook(Unicorn.this, address, size, value, this.data);
        }

        void onInterrupt(int intno) {
            InterruptHook hook = (InterruptHook)this.function;
            hook.hook(Unicorn.this, intno, this.data);
        }

        boolean onMemEvent(int type, long address, int size, long value) {
            EventMemHook hook = (EventMemHook)this.function;
            return hook.hook(Unicorn.this, address, size, value, this.data);
        }
    }

    public class UnHook {
        private final long handle;
        private boolean unhooked;

        public UnHook(long handle) {
            this.handle = handle;
            Unicorn.this.newHookList.add(this);
        }

        public void unhook() {
            this.unhookInternal();
            Unicorn.this.newHookList.remove(this);
        }

        private void unhookInternal() {
            if (!this.unhooked && this.handle != 0L) {
                Unicorn.hook_del(this.handle);
            }
            this.unhooked = true;
        }
    }

    private static class Tuple {
        public Hook function;
        public Object data;

        public Tuple(Hook f, Object d) {
            this.function = f;
            this.data = d;
        }
    }
}

