/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm.context;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.context.BaseRegisterContext;
import com.github.unidbg.arm.context.EditableArm32RegisterContext;
import com.github.unidbg.pointer.UnidbgPointer;
import com.sun.jna.Pointer;

public class BackendArm32RegisterContext
extends BaseRegisterContext
implements EditableArm32RegisterContext {
    private final Backend backend;

    public BackendArm32RegisterContext(Backend backend, Emulator<?> emulator) {
        super(emulator, 66, 4);
        this.backend = backend;
    }

    private long reg(int regId) {
        return (long)this.backend.reg_read(regId).intValue() & 0xFFFFFFFFL;
    }

    private void set(int regId, int value) {
        this.backend.reg_write(regId, value);
    }

    @Override
    public long getR0Long() {
        return this.reg(66);
    }

    @Override
    public long getR1Long() {
        return this.reg(67);
    }

    @Override
    public long getR2Long() {
        return this.reg(68);
    }

    @Override
    public long getR3Long() {
        return this.reg(69);
    }

    @Override
    public long getR4Long() {
        return this.reg(70);
    }

    @Override
    public long getR5Long() {
        return this.reg(71);
    }

    @Override
    public long getR6Long() {
        return this.reg(72);
    }

    @Override
    public long getR7Long() {
        return this.reg(73);
    }

    @Override
    public long getR8Long() {
        return this.reg(74);
    }

    @Override
    public long getR9Long() {
        return this.reg(75);
    }

    @Override
    public long getR10Long() {
        return this.reg(76);
    }

    @Override
    public long getR11Long() {
        return this.reg(77);
    }

    @Override
    public long getR12Long() {
        return this.reg(78);
    }

    @Override
    public void setR0(int r0) {
        this.set(66, r0);
    }

    @Override
    public void setR1(int r1) {
        this.set(67, r1);
    }

    @Override
    public void setR2(int r2) {
        this.set(68, r2);
    }

    @Override
    public void setR3(int r3) {
        this.set(69, r3);
    }

    @Override
    public void setR4(int r4) {
        this.set(70, r4);
    }

    @Override
    public void setR5(int r5) {
        this.set(71, r5);
    }

    @Override
    public void setR6(int r6) {
        this.set(72, r6);
    }

    @Override
    public void setR7(int r7) {
        this.set(73, r7);
    }

    @Override
    public int getR0Int() {
        return (int)this.getR0Long();
    }

    @Override
    public int getR1Int() {
        return (int)this.getR1Long();
    }

    @Override
    public int getR2Int() {
        return (int)this.getR2Long();
    }

    @Override
    public int getR3Int() {
        return (int)this.getR3Long();
    }

    @Override
    public int getR4Int() {
        return (int)this.getR4Long();
    }

    @Override
    public int getR5Int() {
        return (int)this.getR5Long();
    }

    @Override
    public int getR6Int() {
        return (int)this.getR6Long();
    }

    @Override
    public int getR7Int() {
        return (int)this.getR7Long();
    }

    @Override
    public int getR8Int() {
        return (int)this.getR8Long();
    }

    @Override
    public int getR9Int() {
        return (int)this.getR9Long();
    }

    @Override
    public int getR10Int() {
        return (int)this.getR10Long();
    }

    @Override
    public int getR11Int() {
        return (int)this.getR11Long();
    }

    @Override
    public int getR12Int() {
        return (int)this.getR12Long();
    }

    @Override
    public UnidbgPointer getR0Pointer() {
        return UnidbgPointer.pointer(this.emulator, this.getR0Long());
    }

    @Override
    public UnidbgPointer getR1Pointer() {
        return UnidbgPointer.pointer(this.emulator, this.getR1Long());
    }

    @Override
    public UnidbgPointer getR2Pointer() {
        return UnidbgPointer.pointer(this.emulator, this.getR2Long());
    }

    @Override
    public UnidbgPointer getR3Pointer() {
        return UnidbgPointer.pointer(this.emulator, this.getR3Long());
    }

    @Override
    public UnidbgPointer getR4Pointer() {
        return UnidbgPointer.pointer(this.emulator, this.getR4Long());
    }

    @Override
    public UnidbgPointer getR5Pointer() {
        return UnidbgPointer.pointer(this.emulator, this.getR5Long());
    }

    @Override
    public UnidbgPointer getR6Pointer() {
        return UnidbgPointer.pointer(this.emulator, this.getR6Long());
    }

    @Override
    public UnidbgPointer getR7Pointer() {
        return UnidbgPointer.pointer(this.emulator, this.getR7Long());
    }

    @Override
    public UnidbgPointer getR8Pointer() {
        return UnidbgPointer.pointer(this.emulator, this.getR8Long());
    }

    @Override
    public UnidbgPointer getR9Pointer() {
        return UnidbgPointer.pointer(this.emulator, this.getR9Long());
    }

    @Override
    public UnidbgPointer getR10Pointer() {
        return UnidbgPointer.pointer(this.emulator, this.getR10Long());
    }

    @Override
    public UnidbgPointer getR11Pointer() {
        return UnidbgPointer.pointer(this.emulator, this.getR11Long());
    }

    @Override
    public UnidbgPointer getR12Pointer() {
        return UnidbgPointer.pointer(this.emulator, this.getR12Long());
    }

    @Override
    public UnidbgPointer getLRPointer() {
        return UnidbgPointer.pointer(this.emulator, this.getLR());
    }

    @Override
    public UnidbgPointer getPCPointer() {
        return UnidbgPointer.register(this.emulator, 11);
    }

    @Override
    public long getLR() {
        return this.reg(10);
    }

    @Override
    public UnidbgPointer getStackPointer() {
        return UnidbgPointer.register(this.emulator, 12);
    }

    @Override
    public void setStackPointer(Pointer sp) {
        this.backend.reg_write(12, ((UnidbgPointer)sp).peer);
    }
}

