/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.debugger.gdb;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.BackendException;
import com.github.unidbg.debugger.gdb.GdbStub;
import com.github.unidbg.debugger.gdb.GdbStubCommand;
import com.github.unidbg.pointer.UnidbgPointer;
import com.sun.jna.Pointer;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

class MemoryCommand
implements GdbStubCommand {
    MemoryCommand() {
    }

    @Override
    public boolean processCommand(Emulator<?> emulator, GdbStub stub, String command) {
        try {
            int divider = command.indexOf(",");
            long address = Long.parseLong(command.substring(1, divider), 16);
            UnidbgPointer pointer = UnidbgPointer.pointer(emulator, address);
            if (pointer == null) {
                stub.makePacketAndSend("E01");
                return true;
            }
            if (command.startsWith("m")) {
                int len = Integer.parseInt(command.substring(divider + 1), 16);
                String resp = Hex.encodeHexString(((Pointer)pointer).getByteArray(0L, len)).toUpperCase();
                stub.makePacketAndSend(resp);
                return true;
            }
            int dividerForValue = command.indexOf(":");
            int len = Integer.parseInt(command.substring(divider + 1, dividerForValue), 16);
            byte[] val = Hex.decodeHex(command.substring(dividerForValue + 1).toCharArray());
            ((Pointer)pointer).write(0L, val, 0, len);
            stub.makePacketAndSend("OK");
            return true;
        }
        catch (BackendException e) {
            stub.makePacketAndSend("E01");
            return true;
        }
        catch (DecoderException e) {
            throw new IllegalStateException("process memory command failed: " + command, e);
        }
    }
}

