/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.debugger.gdb;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.debugger.gdb.GdbStub;
import com.github.unidbg.debugger.gdb.GdbStubCommand;

class RegisterCommand
implements GdbStubCommand {
    RegisterCommand() {
    }

    @Override
    public boolean processCommand(Emulator<?> emulator, GdbStub stub, String command) {
        Backend backend = emulator.getBackend();
        if (command.startsWith("p")) {
            int reg = Integer.parseInt(command.substring(1), 16);
            long val = this.readRegister(backend, stub, reg);
            if (emulator.is32Bit()) {
                stub.makePacketAndSend(String.format("%08x", Integer.reverseBytes((int)(val & 0xFFFFFFFFL))));
            } else {
                stub.makePacketAndSend(String.format("%016x", Long.reverseBytes(val)));
            }
        } else {
            int reg = Integer.parseInt(command.substring(1, command.indexOf(61)), 16);
            long val = Long.parseLong(command.substring(command.indexOf(61) + 1), 16);
            this.writeRegister(emulator, stub, reg, val);
            stub.makePacketAndSend("OK");
        }
        return true;
    }

    private long readRegister(Backend backend, GdbStub stub, int reg) {
        int index = reg >= 0 && reg < stub.registers.length ? stub.registers[reg] : (reg == 24 ? 77 : (reg == 25 ? 3 : -1));
        if (index != -1) {
            return backend.reg_read(index).longValue();
        }
        return 0L;
    }

    private void writeRegister(Emulator<?> emulator, GdbStub stub, int reg, long val) {
        Backend backend = emulator.getBackend();
        if (reg >= 0 && reg < stub.registers.length) {
            if (emulator.is32Bit()) {
                backend.reg_write(stub.registers[reg], (int)(val & 0xFFFFFFFFL));
            } else {
                backend.reg_write(stub.registers[reg], val);
            }
        } else if (reg == 25) {
            backend.reg_write(3, Integer.reverseBytes((int)(val & 0xFFFFFFFFL)));
        }
    }
}

