/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.file;

import com.github.unidbg.Emulator;
import com.github.unidbg.file.FileResult;
import com.github.unidbg.file.FileSystem;
import com.github.unidbg.file.NewFileIO;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseFileSystem<T extends NewFileIO>
implements FileSystem<T> {
    private static final Log log = LogFactory.getLog(BaseFileSystem.class);
    protected final Emulator<T> emulator;
    protected final File rootDir;

    public BaseFileSystem(Emulator<T> emulator, File rootDir) {
        this.emulator = emulator;
        this.rootDir = rootDir;
        try {
            this.initialize(this.rootDir);
        }
        catch (IOException e) {
            throw new IllegalStateException("initialize file system failed", e);
        }
    }

    protected void initialize(File rootDir) throws IOException {
        FileUtils.forceMkdir(new File(rootDir, "tmp"));
    }

    @Override
    public FileResult<T> open(String pathname, int oflags) {
        if ("".equals(pathname)) {
            return FileResult.failed(2);
        }
        if ("stdin".equals(pathname)) {
            return FileResult.success(this.createStdin(oflags));
        }
        if ("stdout".equals(pathname) || "stderr".equals(pathname)) {
            try {
                File stdio = new File(this.rootDir, pathname + ".txt");
                if (!stdio.exists() && !stdio.createNewFile()) {
                    throw new IOException("create new file failed: " + stdio);
                }
                return FileResult.success(this.createStdout(oflags, stdio, pathname));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        File file = new File(this.rootDir, pathname);
        return this.createFileIO(file, oflags, pathname);
    }

    protected abstract T createStdout(int var1, File var2, String var3);

    protected abstract T createStdin(int var1);

    private FileResult<T> createFileIO(File file, int oflags, String path) {
        boolean directory = this.hasDirectory(oflags);
        if (file.isFile() && directory) {
            return FileResult.failed(20);
        }
        boolean create = this.hasCreat(oflags);
        if (file.exists()) {
            if (create && this.hasExcl(oflags)) {
                return FileResult.failed(17);
            }
            return FileResult.success(file.isDirectory() ? this.createDirectoryFileIO(file, oflags, path) : this.createSimpleFileIO(file, oflags, path));
        }
        if (!create) {
            return FileResult.failed(2);
        }
        try {
            if (directory) {
                FileUtils.forceMkdir(file);
                return FileResult.success(this.createDirectoryFileIO(file, oflags, path));
            }
            if (!file.getParentFile().exists()) {
                FileUtils.forceMkdir(file.getParentFile());
            }
            FileUtils.touch(file);
            return FileResult.success(this.createSimpleFileIO(file, oflags, path));
        }
        catch (IOException e) {
            throw new IllegalStateException("createNewFile failed: " + file, e);
        }
    }

    @Override
    public boolean mkdir(String path, int mode) {
        File dir = new File(this.rootDir, path);
        if (this.emulator.getSyscallHandler().isVerbose()) {
            System.out.printf("mkdir '%s' with mode 0x%x from %s%n", path, mode, this.emulator.getContext().getLRPointer());
        }
        if (dir.exists()) {
            return true;
        }
        return dir.mkdirs();
    }

    @Override
    public void rmdir(String path) {
        File dir = new File(this.rootDir, path);
        FileUtils.deleteQuietly(dir);
        if (this.emulator.getSyscallHandler().isVerbose()) {
            System.out.printf("rmdir '%s' from %s%n", path, this.emulator.getContext().getLRPointer());
        }
    }

    protected abstract boolean hasCreat(int var1);

    protected abstract boolean hasDirectory(int var1);

    protected abstract boolean hasAppend(int var1);

    protected abstract boolean hasExcl(int var1);

    @Override
    public void unlink(String path) {
        File file = new File(this.rootDir, path);
        FileUtils.deleteQuietly(file);
        if (log.isDebugEnabled()) {
            log.debug("unlink path=" + path + ", file=" + file);
        }
        if (this.emulator.getSyscallHandler().isVerbose()) {
            System.out.printf("unlink '%s' from %s%n", path, this.emulator.getContext().getLRPointer());
        }
    }

    @Override
    public File getRootDir() {
        return this.rootDir;
    }

    @Override
    public File createWorkDir() {
        File workDir = new File(this.rootDir, "unidbg_work");
        if (!workDir.exists() && !workDir.mkdirs()) {
            throw new IllegalStateException("mkdirs failed: " + workDir);
        }
        return workDir;
    }

    @Override
    public int rename(String oldPath, String newPath) {
        File oldFile = new File(this.rootDir, oldPath);
        File newFile = new File(this.rootDir, newPath);
        try {
            FileUtils.forceMkdir(newFile.getParentFile());
            if (oldFile.exists()) {
                Files.move(oldFile.toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            if (this.emulator.getSyscallHandler().isVerbose()) {
                System.out.printf("rename '%s' to '%s' from %s%n", oldPath, newPath, this.emulator.getContext().getLRPointer());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return 0;
    }
}

