/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android;

import com.github.unidbg.Emulator;
import com.github.unidbg.Svc;
import com.github.unidbg.arm.Arm64Hook;
import com.github.unidbg.arm.ArmHook;
import com.github.unidbg.arm.HookStatus;
import com.github.unidbg.arm.backend.BackendException;
import com.github.unidbg.hook.HookListener;
import com.github.unidbg.linux.android.SystemPropertyProvider;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import com.sun.jna.Pointer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SystemPropertyHook
implements HookListener {
    private static final Log log = LogFactory.getLog(SystemPropertyHook.class);
    private static final int PROP_VALUE_MAX = 92;
    private final Emulator<?> emulator;
    private SystemPropertyProvider propertyProvider;

    public SystemPropertyHook(Emulator<?> emulator) {
        this.emulator = emulator;
    }

    @Override
    public long hook(SvcMemory svcMemory, String libraryName, String symbolName, final long old) {
        if ("libc.so".equals(libraryName)) {
            if ("__system_property_get".equals(symbolName)) {
                if (log.isDebugEnabled()) {
                    log.debug("Hook " + symbolName);
                }
                if (this.emulator.is64Bit()) {
                    return svcMemory.registerSvc((Svc)new Arm64Hook(){

                        @Override
                        protected HookStatus hook(Emulator<?> emulator) {
                            Object context = emulator.getContext();
                            int index = 0;
                            UnidbgPointer pointer = context.getPointerArg(index);
                            String key = ((Pointer)pointer).getString(0L);
                            return SystemPropertyHook.this.__system_property_get(old, key, index);
                        }
                    }).peer;
                }
                return svcMemory.registerSvc((Svc)new ArmHook(){

                    @Override
                    protected HookStatus hook(Emulator<?> emulator) {
                        Object context = emulator.getContext();
                        int index = 0;
                        UnidbgPointer pointer = context.getPointerArg(index);
                        String key = ((Pointer)pointer).getString(0L);
                        return SystemPropertyHook.this.__system_property_get(old, key, index);
                    }
                }).peer;
            }
            if ("__system_property_read".equals(symbolName)) {
                if (log.isDebugEnabled()) {
                    log.debug("Hook " + symbolName);
                }
                if (this.emulator.is64Bit()) {
                    return svcMemory.registerSvc((Svc)new Arm64Hook(){

                        @Override
                        protected HookStatus hook(Emulator<?> emulator) {
                            Object context = emulator.getContext();
                            UnidbgPointer pi = context.getPointerArg(0);
                            String key = pi.share(96L).getString(0L);
                            return SystemPropertyHook.this.__system_property_get(old, key, 1);
                        }
                    }).peer;
                }
                return svcMemory.registerSvc((Svc)new ArmHook(){

                    @Override
                    protected HookStatus hook(Emulator<?> emulator) {
                        Object context = emulator.getContext();
                        UnidbgPointer pi = context.getPointerArg(0);
                        String key = pi.share(96L).getString(0L);
                        return SystemPropertyHook.this.__system_property_get(old, key, 1);
                    }
                }).peer;
            }
            if ("__system_property_find".equals(symbolName)) {
                if (log.isDebugEnabled()) {
                    log.debug("Hook " + symbolName);
                }
                if (this.emulator.is64Bit()) {
                    return svcMemory.registerSvc((Svc)new Arm64Hook(){

                        @Override
                        protected HookStatus hook(Emulator<?> emulator) {
                            Object context = emulator.getContext();
                            UnidbgPointer name = context.getPointerArg(0);
                            if (log.isDebugEnabled()) {
                                log.debug("__system_property_find key=" + ((Pointer)name).getString(0L));
                            }
                            return HookStatus.RET(emulator, old);
                        }
                    }).peer;
                }
                return svcMemory.registerSvc((Svc)new ArmHook(){

                    @Override
                    protected HookStatus hook(Emulator<?> emulator) {
                        Object context = emulator.getContext();
                        UnidbgPointer name = context.getPointerArg(0);
                        if (log.isDebugEnabled()) {
                            log.debug("__system_property_find key=" + ((Pointer)name).getString(0L));
                        }
                        return HookStatus.RET(emulator, old);
                    }
                }).peer;
            }
        }
        return 0L;
    }

    private HookStatus __system_property_get(long old, String key, int index) {
        String value;
        Object context = this.emulator.getContext();
        if (this.propertyProvider != null && (value = this.propertyProvider.getProperty(key)) != null) {
            byte[] data2;
            if (log.isDebugEnabled()) {
                log.debug("__system_property_get key=" + key + ", value=" + value);
            }
            if ((data2 = value.getBytes(StandardCharsets.UTF_8)).length >= 92) {
                throw new BackendException("invalid property value length: key=" + key + ", value=" + value);
            }
            context.getPointerArg(index + 1).write(0L, Arrays.copyOf(data2, data2.length + 1), 0, data2.length + 1);
            return HookStatus.LR(this.emulator, data2.length);
        }
        if (log.isDebugEnabled()) {
            log.debug("__system_property_get key=" + key);
        }
        return HookStatus.RET(this.emulator, old);
    }

    public void setPropertyProvider(SystemPropertyProvider propertyProvider) {
        this.propertyProvider = propertyProvider;
    }
}

