/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm;

import com.github.unidbg.linux.android.dvm.ArrayListObject;
import com.github.unidbg.linux.android.dvm.BaseVM;
import com.github.unidbg.linux.android.dvm.DvmClass;
import com.github.unidbg.linux.android.dvm.DvmField;
import com.github.unidbg.linux.android.dvm.DvmMethod;
import com.github.unidbg.linux.android.dvm.DvmObject;
import com.github.unidbg.linux.android.dvm.Enumeration;
import com.github.unidbg.linux.android.dvm.Jni;
import com.github.unidbg.linux.android.dvm.StringObject;
import com.github.unidbg.linux.android.dvm.VaList;
import com.github.unidbg.linux.android.dvm.VarArg;
import com.github.unidbg.linux.android.dvm.api.ApplicationInfo;
import com.github.unidbg.linux.android.dvm.api.AssetManager;
import com.github.unidbg.linux.android.dvm.api.Binder;
import com.github.unidbg.linux.android.dvm.api.Bundle;
import com.github.unidbg.linux.android.dvm.api.ClassLoader;
import com.github.unidbg.linux.android.dvm.api.PackageInfo;
import com.github.unidbg.linux.android.dvm.api.ServiceManager;
import com.github.unidbg.linux.android.dvm.api.Signature;
import com.github.unidbg.linux.android.dvm.api.SystemService;
import com.github.unidbg.linux.android.dvm.array.ArrayObject;
import com.github.unidbg.linux.android.dvm.array.ByteArray;
import com.github.unidbg.linux.android.dvm.wrapper.DvmBoolean;
import com.github.unidbg.linux.android.dvm.wrapper.DvmInteger;
import com.github.unidbg.linux.android.dvm.wrapper.DvmLong;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import net.dongliu.apk.parser.bean.CertificateMeta;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractJni
implements Jni {
    private static final Log log = LogFactory.getLog(AbstractJni.class);

    @Override
    public DvmObject<?> getStaticObjectField(BaseVM vm, DvmClass dvmClass, DvmField dvmField) {
        return this.getStaticObjectField(vm, dvmClass, dvmField.getSignature());
    }

    @Override
    public DvmObject<?> getStaticObjectField(BaseVM vm, DvmClass dvmClass, String signature) {
        switch (signature) {
            case "android/content/Context->TELEPHONY_SERVICE:Ljava/lang/String;": {
                return new StringObject(vm, "phone");
            }
            case "android/content/Context->WIFI_SERVICE:Ljava/lang/String;": {
                return new StringObject(vm, "wifi");
            }
            case "android/content/Context->CONNECTIVITY_SERVICE:Ljava/lang/String;": {
                return new StringObject(vm, "connectivity");
            }
            case "android/content/Context->ACCESSIBILITY_SERVICE:Ljava/lang/String;": {
                return new StringObject(vm, "accessibility");
            }
            case "android/content/Context->KEYGUARD_SERVICE:Ljava/lang/String;": {
                return new StringObject(vm, "keyguard");
            }
            case "android/content/Context->ACTIVITY_SERVICE:Ljava/lang/String;": {
                return new StringObject(vm, "activity");
            }
            case "android/content/Context->LOCATION_SERVICE:Ljava/lang/String;": {
                return new StringObject(vm, "location");
            }
            case "android/content/Context->WINDOW_SERVICE:Ljava/lang/String;": {
                return new StringObject(vm, "window");
            }
            case "android/content/Context->SENSOR_SERVICE:Ljava/lang/String;": {
                return new StringObject(vm, "sensor");
            }
            case "android/content/Context->UI_MODE_SERVICE:Ljava/lang/String;": {
                return new StringObject(vm, "uimode");
            }
            case "android/content/Context->DISPLAY_SERVICE:Ljava/lang/String;": {
                return new StringObject(vm, "display");
            }
            case "android/content/Context->AUDIO_SERVICE:Ljava/lang/String;": {
                return new StringObject(vm, "audio");
            }
            case "java/lang/Void->TYPE:Ljava/lang/Class;": {
                return vm.resolveClass("java/lang/Void", new DvmClass[0]);
            }
            case "java/lang/Boolean->TYPE:Ljava/lang/Class;": {
                return vm.resolveClass("java/lang/Boolean", new DvmClass[0]);
            }
            case "java/lang/Byte->TYPE:Ljava/lang/Class;": {
                return vm.resolveClass("java/lang/Byte", new DvmClass[0]);
            }
            case "java/lang/Character->TYPE:Ljava/lang/Class;": {
                return vm.resolveClass("java/lang/Character", new DvmClass[0]);
            }
            case "java/lang/Short->TYPE:Ljava/lang/Class;": {
                return vm.resolveClass("java/lang/Short", new DvmClass[0]);
            }
            case "java/lang/Integer->TYPE:Ljava/lang/Class;": {
                return vm.resolveClass("java/lang/Integer", new DvmClass[0]);
            }
            case "java/lang/Long->TYPE:Ljava/lang/Class;": {
                return vm.resolveClass("java/lang/Long", new DvmClass[0]);
            }
            case "java/lang/Float->TYPE:Ljava/lang/Class;": {
                return vm.resolveClass("java/lang/Float", new DvmClass[0]);
            }
            case "java/lang/Double->TYPE:Ljava/lang/Class;": {
                return vm.resolveClass("java/lang/Double", new DvmClass[0]);
            }
        }
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public boolean getStaticBooleanField(BaseVM vm, DvmClass dvmClass, DvmField dvmField) {
        return this.getStaticBooleanField(vm, dvmClass, dvmField.getSignature());
    }

    @Override
    public boolean getStaticBooleanField(BaseVM vm, DvmClass dvmClass, String signature) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public byte getStaticByteField(BaseVM vm, DvmClass dvmClass, DvmField dvmField) {
        return this.getStaticByteField(vm, dvmClass, dvmField.getSignature());
    }

    @Override
    public byte getStaticByteField(BaseVM vm, DvmClass dvmClass, String signature) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public int getStaticIntField(BaseVM vm, DvmClass dvmClass, DvmField dvmField) {
        return this.getStaticIntField(vm, dvmClass, dvmField.getSignature());
    }

    @Override
    public int getStaticIntField(BaseVM vm, DvmClass dvmClass, String signature) {
        if ("android/content/pm/PackageManager->GET_SIGNATURES:I".equals(signature)) {
            return 64;
        }
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public DvmObject<?> getObjectField(BaseVM vm, DvmObject<?> dvmObject, DvmField dvmField) {
        return this.getObjectField(vm, dvmObject, dvmField.getSignature());
    }

    @Override
    public DvmObject<?> getObjectField(BaseVM vm, DvmObject<?> dvmObject, String signature) {
        String versionName;
        CertificateMeta[] metas;
        PackageInfo packageInfo;
        if ("android/content/pm/PackageInfo->signatures:[Landroid/content/pm/Signature;".equals(signature) && dvmObject instanceof PackageInfo && (packageInfo = (PackageInfo)dvmObject).getPackageName().equals(vm.getPackageName()) && (metas = vm.getSignatures()) != null) {
            Signature[] signatures = new Signature[metas.length];
            for (int i = 0; i < metas.length; ++i) {
                signatures[i] = new Signature(vm, metas[i]);
            }
            return new ArrayObject(signatures);
        }
        if ("android/content/pm/PackageInfo->versionName:Ljava/lang/String;".equals(signature) && dvmObject instanceof PackageInfo && (packageInfo = (PackageInfo)dvmObject).getPackageName().equals(vm.getPackageName()) && (versionName = vm.getVersionName()) != null) {
            return new StringObject(vm, versionName);
        }
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public boolean callStaticBooleanMethod(BaseVM vm, DvmClass dvmClass, DvmMethod dvmMethod, VarArg varArg) {
        return this.callStaticBooleanMethod(vm, dvmClass, dvmMethod.getSignature(), varArg);
    }

    @Override
    public boolean callStaticBooleanMethod(BaseVM vm, DvmClass dvmClass, String signature, VarArg varArg) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public boolean callStaticBooleanMethodV(BaseVM vm, DvmClass dvmClass, DvmMethod dvmMethod, VaList vaList) {
        return this.callStaticBooleanMethodV(vm, dvmClass, dvmMethod.getSignature(), vaList);
    }

    @Override
    public boolean callStaticBooleanMethodV(BaseVM vm, DvmClass dvmClass, String signature, VaList vaList) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public int callStaticIntMethod(BaseVM vm, DvmClass dvmClass, DvmMethod dvmMethod, VarArg varArg) {
        return this.callStaticIntMethod(vm, dvmClass, dvmMethod.getSignature(), varArg);
    }

    @Override
    public int callStaticIntMethod(BaseVM vm, DvmClass dvmClass, String signature, VarArg varArg) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public int callStaticIntMethodV(BaseVM vm, DvmClass dvmClass, DvmMethod dvmMethod, VaList vaList) {
        return this.callStaticIntMethodV(vm, dvmClass, dvmMethod.getSignature(), vaList);
    }

    @Override
    public int callStaticIntMethodV(BaseVM vm, DvmClass dvmClass, String signature, VaList vaList) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public long callLongMethod(BaseVM vm, DvmObject<?> dvmObject, DvmMethod dvmMethod, VarArg varArg) {
        return this.callLongMethod(vm, dvmObject, dvmMethod.getSignature(), varArg);
    }

    @Override
    public long callLongMethod(BaseVM vm, DvmObject<?> dvmObject, String signature, VarArg varArg) {
        if ("java/lang/Long->longValue()J".equals(signature)) {
            DvmLong val = (DvmLong)dvmObject;
            return (Long)val.value;
        }
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public long callLongMethodV(BaseVM vm, DvmObject<?> dvmObject, DvmMethod dvmMethod, VaList vaList) {
        return this.callLongMethodV(vm, dvmObject, dvmMethod.getSignature(), vaList);
    }

    @Override
    public long callLongMethodV(BaseVM vm, DvmObject<?> dvmObject, String signature, VaList vaList) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public char callCharMethodV(BaseVM vm, DvmObject<?> dvmObject, DvmMethod dvmMethod, VaList vaList) {
        return this.callCharMethodV(vm, dvmObject, dvmMethod.getSignature(), vaList);
    }

    @Override
    public char callCharMethodV(BaseVM vm, DvmObject<?> dvmObject, String signature, VaList vaList) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public float callFloatMethodV(BaseVM vm, DvmObject<?> dvmObject, DvmMethod dvmMethod, VaList vaList) {
        return this.callFloatMethodV(vm, dvmObject, dvmMethod.getSignature(), vaList);
    }

    @Override
    public float callFloatMethodV(BaseVM vm, DvmObject<?> dvmObject, String signature, VaList vaList) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public DvmObject<?> callObjectMethodV(BaseVM vm, DvmObject<?> dvmObject, DvmMethod dvmMethod, VaList vaList) {
        return this.callObjectMethodV(vm, dvmObject, dvmMethod.getSignature(), vaList);
    }

    @Override
    public DvmObject<?> callObjectMethodV(BaseVM vm, DvmObject<?> dvmObject, String signature, VaList vaList) {
        switch (signature) {
            case "android/app/Application->getAssets()Landroid/content/res/AssetManager;": {
                return new AssetManager(vm, signature);
            }
            case "android/app/Application->getClassLoader()Ljava/lang/ClassLoader;": {
                return new ClassLoader(vm, signature);
            }
            case "android/app/Application->getContentResolver()Landroid/content/ContentResolver;": {
                return vm.resolveClass("android/content/ContentResolver", new DvmClass[0]).newObject(signature);
            }
            case "java/util/ArrayList->get(I)Ljava/lang/Object;": {
                int index = vaList.getIntArg(0);
                ArrayListObject arrayList = (ArrayListObject)dvmObject;
                return (DvmObject)((List)arrayList.getValue()).get(index);
            }
            case "android/app/Application->getSystemService(Ljava/lang/String;)Ljava/lang/Object;": {
                StringObject serviceName = (StringObject)vaList.getObjectArg(0);
                assert (serviceName != null);
                return new SystemService(vm, (String)serviceName.getValue());
            }
            case "java/lang/String->toString()Ljava/lang/String;": {
                return dvmObject;
            }
            case "java/lang/Class->getName()Ljava/lang/String;": {
                return new StringObject(vm, ((DvmClass)dvmObject).getName());
            }
            case "android/view/accessibility/AccessibilityManager->getEnabledAccessibilityServiceList(I)Ljava/util/List;": {
                return new ArrayListObject(vm, Collections.emptyList());
            }
            case "java/util/Enumeration->nextElement()Ljava/lang/Object;": {
                return ((Enumeration)dvmObject).nextElement();
            }
            case "java/util/Locale->getLanguage()Ljava/lang/String;": {
                Locale locale = (Locale)dvmObject.getValue();
                return new StringObject(vm, locale.getLanguage());
            }
            case "java/util/Locale->getCountry()Ljava/lang/String;": {
                Locale locale = (Locale)dvmObject.getValue();
                return new StringObject(vm, locale.getCountry());
            }
            case "android/os/IServiceManager->getService(Ljava/lang/String;)Landroid/os/IBinder;": {
                ServiceManager serviceManager = (ServiceManager)dvmObject;
                StringObject serviceName = (StringObject)vaList.getObjectArg(0);
                assert (serviceName != null);
                return serviceManager.getService(vm, (String)serviceName.getValue());
            }
            case "java/io/File->getAbsolutePath()Ljava/lang/String;": {
                File file = (File)dvmObject.getValue();
                String fake = file.getAbsolutePath();
                if (fake.startsWith("C:") || fake.startsWith("D:")) {
                    fake = fake.substring(2);
                }
                if (fake.contains("\\")) {
                    fake = fake.replace("\\", "/");
                }
                return new StringObject(vm, fake);
            }
            case "android/app/Application->getPackageManager()Landroid/content/pm/PackageManager;": 
            case "android/content/ContextWrapper->getPackageManager()Landroid/content/pm/PackageManager;": 
            case "android/content/Context->getPackageManager()Landroid/content/pm/PackageManager;": {
                DvmClass clazz = vm.resolveClass("android/content/pm/PackageManager", new DvmClass[0]);
                return clazz.newObject(signature);
            }
            case "android/content/pm/PackageManager->getPackageInfo(Ljava/lang/String;I)Landroid/content/pm/PackageInfo;": {
                StringObject packageName = (StringObject)vaList.getObjectArg(0);
                assert (packageName != null);
                int flags = vaList.getIntArg(1);
                if (log.isDebugEnabled()) {
                    log.debug("getPackageInfo packageName=" + (String)packageName.getValue() + ", flags=0x" + Integer.toHexString(flags));
                }
                return new PackageInfo(vm, (String)packageName.value, flags);
            }
            case "android/app/Application->getPackageName()Ljava/lang/String;": 
            case "android/content/ContextWrapper->getPackageName()Ljava/lang/String;": 
            case "android/content/Context->getPackageName()Ljava/lang/String;": {
                String packageName = vm.getPackageName();
                if (packageName == null) break;
                return new StringObject(vm, packageName);
            }
            case "android/content/pm/Signature->toByteArray()[B": {
                if (!(dvmObject instanceof Signature)) break;
                Signature sig = (Signature)dvmObject;
                return new ByteArray(vm, sig.toByteArray());
            }
            case "android/content/pm/Signature->toCharsString()Ljava/lang/String;": {
                if (!(dvmObject instanceof Signature)) break;
                Signature sig = (Signature)dvmObject;
                return new StringObject(vm, sig.toCharsString());
            }
            case "java/lang/String->getBytes()[B": {
                String str = (String)dvmObject.getValue();
                return new ByteArray(vm, str.getBytes());
            }
            case "java/lang/String->getBytes(Ljava/lang/String;)[B": {
                String str = (String)dvmObject.getValue();
                StringObject charsetName = (StringObject)vaList.getObjectArg(0);
                assert (charsetName != null);
                try {
                    return new ByteArray(vm, str.getBytes((String)charsetName.value));
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException(e);
                }
            }
            case "java/security/cert/CertificateFactory->generateCertificate(Ljava/io/InputStream;)Ljava/security/cert/Certificate;": {
                CertificateFactory factory = (CertificateFactory)dvmObject.value;
                Object stream = vaList.getObjectArg(0);
                assert (stream != null);
                InputStream inputStream = (InputStream)((DvmObject)stream).value;
                try {
                    return vm.resolveClass("java/security/cert/Certificate", new DvmClass[0]).newObject(factory.generateCertificate(inputStream));
                }
                catch (CertificateException e) {
                    throw new IllegalStateException(e);
                }
            }
            case "java/security/cert/Certificate->getEncoded()[B": {
                Certificate certificate = (Certificate)dvmObject.value;
                try {
                    return new ByteArray(vm, certificate.getEncoded());
                }
                catch (CertificateEncodingException e) {
                    throw new IllegalStateException(e);
                }
            }
            case "java/security/MessageDigest->digest([B)[B": {
                MessageDigest messageDigest = (MessageDigest)dvmObject.value;
                ByteArray array = (ByteArray)vaList.getObjectArg(0);
                assert (array != null);
                return new ByteArray(vm, messageDigest.digest((byte[])array.value));
            }
            case "java/util/ArrayList->remove(I)Ljava/lang/Object;": {
                int index = vaList.getIntArg(0);
                ArrayListObject list = (ArrayListObject)dvmObject;
                return (DvmObject)((List)list.value).remove(index);
            }
            case "java/util/List->get(I)Ljava/lang/Object;": {
                List list = (List)dvmObject.getValue();
                return (DvmObject)list.get(vaList.getIntArg(0));
            }
            case "java/util/Map->entrySet()Ljava/util/Set;": {
                Map map = (Map)dvmObject.getValue();
                return vm.resolveClass("java/util/Set", new DvmClass[0]).newObject(map.entrySet());
            }
            case "java/util/Set->iterator()Ljava/util/Iterator;": {
                Set set = (Set)dvmObject.getValue();
                return vm.resolveClass("java/util/Iterator", new DvmClass[0]).newObject(set.iterator());
            }
            case "java/util/UUID->toString()Ljava/lang/String;": {
                UUID uuid = (UUID)dvmObject.getValue();
                return new StringObject(vm, uuid.toString());
            }
            case "java/lang/CharSequence->toString()Ljava/lang/String;": {
                return new StringObject(vm, dvmObject.value.toString());
            }
            case "java/lang/String->toLowerCase()Ljava/lang/String;": {
                return new StringObject(vm, dvmObject.value.toString().toLowerCase());
            }
            case "android/content/pm/PackageManager->getApplicationInfo(Ljava/lang/String;I)Landroid/content/pm/ApplicationInfo;": {
                StringObject packageName = (StringObject)vaList.getObjectArg(0);
                if (((String)packageName.value).equals(vm.getPackageName())) {
                    return new ApplicationInfo(vm);
                }
                throw new UnsupportedOperationException(signature);
            }
            case "java/lang/String->trim()Ljava/lang/String;": {
                StringObject stringObject = (StringObject)dvmObject;
                return new StringObject(vm, ((String)stringObject.value).trim());
            }
        }
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public DvmObject<?> callStaticObjectMethod(BaseVM vm, DvmClass dvmClass, DvmMethod dvmMethod, VarArg varArg) {
        return this.callStaticObjectMethod(vm, dvmClass, dvmMethod.getSignature(), varArg);
    }

    @Override
    public DvmObject<?> callStaticObjectMethod(BaseVM vm, DvmClass dvmClass, String signature, VarArg varArg) {
        String packageName;
        if ("android/app/ActivityThread->currentPackageName()Ljava/lang/String;".equals(signature) && (packageName = vm.getPackageName()) != null) {
            return new StringObject(vm, packageName);
        }
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public DvmObject<?> callStaticObjectMethodV(BaseVM vm, DvmClass dvmClass, DvmMethod dvmMethod, VaList vaList) {
        return this.callStaticObjectMethodV(vm, dvmClass, dvmMethod.getSignature(), vaList);
    }

    @Override
    public DvmObject<?> callStaticObjectMethodV(BaseVM vm, DvmClass dvmClass, String signature, VaList vaList) {
        switch (signature) {
            case "com/android/internal/os/BinderInternal->getContextObject()Landroid/os/IBinder;": {
                return new Binder(vm, signature);
            }
            case "android/app/ActivityThread->currentActivityThread()Landroid/app/ActivityThread;": {
                return dvmClass.newObject(null);
            }
            case "android/app/ActivityThread->currentApplication()Landroid/app/Application;": {
                return vm.resolveClass("android/app/Application", vm.resolveClass("android/content/ContextWrapper", vm.resolveClass("android/content/Context", new DvmClass[0]))).newObject(signature);
            }
            case "java/util/Locale->getDefault()Ljava/util/Locale;": {
                return dvmClass.newObject(Locale.getDefault());
            }
            case "android/os/ServiceManagerNative->asInterface(Landroid/os/IBinder;)Landroid/os/IServiceManager;": {
                return new ServiceManager(vm, signature);
            }
            case "com/android/internal/telephony/ITelephony$Stub->asInterface(Landroid/os/IBinder;)Lcom/android/internal/telephony/ITelephony;": {
                return vaList.getObjectArg(0);
            }
            case "java/security/cert/CertificateFactory->getInstance(Ljava/lang/String;)Ljava/security/cert/CertificateFactory;": {
                StringObject type = (StringObject)vaList.getObjectArg(0);
                assert (type != null);
                try {
                    return dvmClass.newObject(CertificateFactory.getInstance((String)type.value));
                }
                catch (CertificateException e) {
                    throw new IllegalStateException(e);
                }
            }
            case "java/security/KeyFactory->getInstance(Ljava/lang/String;)Ljava/security/KeyFactory;": {
                StringObject algorithm = (StringObject)vaList.getObjectArg(0);
                assert (algorithm != null);
                try {
                    return dvmClass.newObject(KeyFactory.getInstance((String)algorithm.value));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException(e);
                }
            }
            case "javax/crypto/Cipher->getInstance(Ljava/lang/String;)Ljavax/crypto/Cipher;": {
                StringObject transformation = (StringObject)vaList.getObjectArg(0);
                assert (transformation != null);
                try {
                    return dvmClass.newObject(Cipher.getInstance((String)transformation.value));
                }
                catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
                    throw new IllegalStateException(e);
                }
            }
            case "java/security/MessageDigest->getInstance(Ljava/lang/String;)Ljava/security/MessageDigest;": {
                StringObject type = (StringObject)vaList.getObjectArg(0);
                assert (type != null);
                try {
                    return dvmClass.newObject(MessageDigest.getInstance((String)type.value));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException(e);
                }
            }
            case "java/util/UUID->randomUUID()Ljava/util/UUID;": {
                return dvmClass.newObject(UUID.randomUUID());
            }
            case "android/app/ActivityThread->currentPackageName()Ljava/lang/String;": {
                String packageName = vm.getPackageName();
                if (packageName == null) break;
                return new StringObject(vm, packageName);
            }
        }
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public byte callByteMethodV(BaseVM vm, DvmObject<?> dvmObject, DvmMethod dvmMethod, VaList vaList) {
        return this.callByteMethodV(vm, dvmObject, dvmMethod.getSignature(), vaList);
    }

    @Override
    public byte callByteMethodV(BaseVM vm, DvmObject<?> dvmObject, String signature, VaList vaList) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public short callShortMethodV(BaseVM vm, DvmObject<?> dvmObject, DvmMethod dvmMethod, VaList vaList) {
        return this.callShortMethodV(vm, dvmObject, dvmMethod.getSignature(), vaList);
    }

    @Override
    public short callShortMethodV(BaseVM vm, DvmObject<?> dvmObject, String signature, VaList vaList) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public int callIntMethodV(BaseVM vm, DvmObject<?> dvmObject, DvmMethod dvmMethod, VaList vaList) {
        return this.callIntMethodV(vm, dvmObject, dvmMethod.getSignature(), vaList);
    }

    @Override
    public int callIntMethodV(BaseVM vm, DvmObject<?> dvmObject, String signature, VaList vaList) {
        switch (signature) {
            case "android/os/Bundle->getInt(Ljava/lang/String;)I": {
                Bundle bundle = (Bundle)dvmObject;
                StringObject key = (StringObject)vaList.getObjectArg(0);
                assert (key != null);
                return bundle.getInt((String)key.getValue());
            }
            case "java/util/ArrayList->size()I": {
                ArrayListObject list = (ArrayListObject)dvmObject;
                return list.size();
            }
            case "android/content/pm/Signature->hashCode()I": {
                if (!(dvmObject instanceof Signature)) break;
                Signature sig = (Signature)dvmObject;
                return sig.getHashCode();
            }
            case "java/lang/Integer->intValue()I": {
                DvmInteger integer = (DvmInteger)dvmObject;
                return (Integer)integer.value;
            }
            case "java/util/List->size()I": {
                List list = (List)dvmObject.getValue();
                return list.size();
            }
            case "java/util/Map->size()I": {
                Map map = (Map)dvmObject.getValue();
                return map.size();
            }
        }
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public long callStaticLongMethod(BaseVM vm, DvmClass dvmClass, DvmMethod dvmMethod, VarArg varArg) {
        return this.callStaticLongMethod(vm, dvmClass, dvmMethod.getSignature(), varArg);
    }

    @Override
    public long callStaticLongMethod(BaseVM vm, DvmClass dvmClass, String signature, VarArg varArg) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public long callStaticLongMethodV(BaseVM vm, DvmClass dvmClass, DvmMethod dvmMethod, VaList vaList) {
        return this.callStaticLongMethodV(vm, dvmClass, dvmMethod.getSignature(), vaList);
    }

    @Override
    public long callStaticLongMethodV(BaseVM vm, DvmClass dvmClass, String signature, VaList vaList) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public boolean callBooleanMethod(BaseVM vm, DvmObject<?> dvmObject, DvmMethod dvmMethod, VarArg varArg) {
        return this.callBooleanMethod(vm, dvmObject, dvmMethod.getSignature(), varArg);
    }

    @Override
    public boolean callBooleanMethod(BaseVM vm, DvmObject<?> dvmObject, String signature, VarArg varArg) {
        if ("java/lang/Boolean->booleanValue()Z".equals(signature)) {
            DvmBoolean dvmBoolean = (DvmBoolean)dvmObject;
            return (Boolean)dvmBoolean.value;
        }
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public boolean callBooleanMethodV(BaseVM vm, DvmObject<?> dvmObject, DvmMethod dvmMethod, VaList vaList) {
        return this.callBooleanMethodV(vm, dvmObject, dvmMethod.getSignature(), vaList);
    }

    @Override
    public boolean callBooleanMethodV(BaseVM vm, DvmObject<?> dvmObject, String signature, VaList vaList) {
        switch (signature) {
            case "java/util/Enumeration->hasMoreElements()Z": {
                return ((Enumeration)dvmObject).hasMoreElements();
            }
            case "java/util/ArrayList->isEmpty()Z": {
                return ((ArrayListObject)dvmObject).isEmpty();
            }
            case "java/util/Iterator->hasNext()Z": {
                Object iterator = dvmObject.getValue();
                if (iterator instanceof Iterator) {
                    return ((Iterator)iterator).hasNext();
                }
            }
            case "java/lang/String->startsWith(Ljava/lang/String;)Z": {
                String str = (String)dvmObject.getValue();
                StringObject prefix = (StringObject)vaList.getObjectArg(0);
                return str.startsWith((String)prefix.value);
            }
        }
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public int getIntField(BaseVM vm, DvmObject<?> dvmObject, DvmField dvmField) {
        return this.getIntField(vm, dvmObject, dvmField.getSignature());
    }

    @Override
    public int getIntField(BaseVM vm, DvmObject<?> dvmObject, String signature) {
        if ("android/content/pm/PackageInfo->versionCode:I".equals(signature)) {
            return (int)vm.getVersionCode();
        }
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public long getLongField(BaseVM vm, DvmObject<?> dvmObject, DvmField dvmField) {
        return this.getLongField(vm, dvmObject, dvmField.getSignature());
    }

    @Override
    public long getLongField(BaseVM vm, DvmObject<?> dvmObject, String signature) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public float getFloatField(BaseVM vm, DvmObject<?> dvmObject, DvmField dvmField) {
        return this.getFloatField(vm, dvmObject, dvmField.getSignature());
    }

    @Override
    public float getFloatField(BaseVM vm, DvmObject<?> dvmObject, String signature) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public float callStaticFloatMethod(BaseVM vm, DvmClass dvmClass, DvmMethod dvmMethod, VarArg varArg) {
        return this.callStaticFloatMethod(vm, dvmClass, dvmMethod.getSignature(), varArg);
    }

    @Override
    public float callStaticFloatMethod(BaseVM vm, DvmClass dvmClass, String signature, VarArg varArg) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public double callStaticDoubleMethod(BaseVM vm, DvmClass dvmClass, DvmMethod dvmMethod, VarArg varArg) {
        return this.callStaticDoubleMethod(vm, dvmClass, dvmMethod.getSignature(), varArg);
    }

    @Override
    public double callStaticDoubleMethod(BaseVM vm, DvmClass dvmClass, String signature, VarArg varArg) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public void callStaticVoidMethod(BaseVM vm, DvmClass dvmClass, DvmMethod dvmMethod, VarArg varArg) {
        this.callStaticVoidMethod(vm, dvmClass, dvmMethod.getSignature(), varArg);
    }

    @Override
    public void callStaticVoidMethod(BaseVM vm, DvmClass dvmClass, String signature, VarArg varArg) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public void callStaticVoidMethodV(BaseVM vm, DvmClass dvmClass, DvmMethod dvmMethod, VaList vaList) {
        this.callStaticVoidMethodV(vm, dvmClass, dvmMethod.getSignature(), vaList);
    }

    @Override
    public void callStaticVoidMethodV(BaseVM vm, DvmClass dvmClass, String signature, VaList vaList) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public void setObjectField(BaseVM vm, DvmObject<?> dvmObject, DvmField dvmField, DvmObject<?> value) {
        this.setObjectField(vm, dvmObject, dvmField.getSignature(), value);
    }

    @Override
    public void setObjectField(BaseVM vm, DvmObject<?> dvmObject, String signature, DvmObject<?> value) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public boolean getBooleanField(BaseVM vm, DvmObject<?> dvmObject, DvmField dvmField) {
        return this.getBooleanField(vm, dvmObject, dvmField.getSignature());
    }

    @Override
    public boolean getBooleanField(BaseVM vm, DvmObject<?> dvmObject, String signature) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public DvmObject<?> newObject(BaseVM vm, DvmClass dvmClass, DvmMethod dvmMethod, VarArg varArg) {
        return this.newObject(vm, dvmClass, dvmMethod.getSignature(), varArg);
    }

    @Override
    public DvmObject<?> newObject(BaseVM vm, DvmClass dvmClass, String signature, VarArg varArg) {
        switch (signature) {
            case "java/lang/String-><init>([B)V": {
                ByteArray array = (ByteArray)varArg.getObjectArg(0);
                return new StringObject(vm, new String((byte[])array.getValue()));
            }
            case "java/lang/String-><init>([BLjava/lang/String;)V": {
                ByteArray array = (ByteArray)varArg.getObjectArg(0);
                StringObject string = (StringObject)varArg.getObjectArg(1);
                try {
                    return new StringObject(vm, new String((byte[])array.getValue(), (String)string.getValue()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public DvmObject<?> newObjectV(BaseVM vm, DvmClass dvmClass, DvmMethod dvmMethod, VaList vaList) {
        return this.newObjectV(vm, dvmClass, dvmMethod.getSignature(), vaList);
    }

    @Override
    public DvmObject<?> newObjectV(BaseVM vm, DvmClass dvmClass, String signature, VaList vaList) {
        switch (signature) {
            case "java/io/ByteArrayInputStream-><init>([B)V": {
                ByteArray array = (ByteArray)vaList.getObjectArg(0);
                assert (array != null);
                return vm.resolveClass("java/io/ByteArrayInputStream", new DvmClass[0]).newObject(new ByteArrayInputStream((byte[])array.value));
            }
            case "java/lang/String-><init>([B)V": {
                ByteArray array = (ByteArray)vaList.getObjectArg(0);
                assert (array != null);
                return new StringObject(vm, new String((byte[])array.value));
            }
            case "java/lang/String-><init>([BLjava/lang/String;)V": {
                ByteArray array = (ByteArray)vaList.getObjectArg(0);
                assert (array != null);
                StringObject charsetName = (StringObject)vaList.getObjectArg(1);
                assert (charsetName != null);
                try {
                    return new StringObject(vm, new String((byte[])array.value, (String)charsetName.value));
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException(e);
                }
            }
            case "javax/crypto/spec/SecretKeySpec-><init>([BLjava/lang/String;)V": {
                byte[] key = (byte[])((DvmObject)vaList.getObjectArg((int)0)).value;
                StringObject algorithm = (StringObject)vaList.getObjectArg(1);
                assert (algorithm != null);
                SecretKeySpec secretKeySpec = new SecretKeySpec(key, (String)algorithm.value);
                return dvmClass.newObject(secretKeySpec);
            }
            case "java/lang/Integer-><init>(I)V": {
                int i = vaList.getIntArg(0);
                return DvmInteger.valueOf(vm, i);
            }
            case "java/lang/Boolean-><init>(Z)V": {
                boolean b = vaList.getIntArg(0) != 0;
                return DvmBoolean.valueOf(vm, b);
            }
        }
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public DvmObject<?> allocObject(BaseVM vm, DvmClass dvmClass, String signature) {
        if ("java/util/HashMap->allocObject".equals(signature)) {
            return dvmClass.newObject(new HashMap());
        }
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public void setIntField(BaseVM vm, DvmObject<?> dvmObject, DvmField dvmField, int value) {
        this.setIntField(vm, dvmObject, dvmField.getSignature(), value);
    }

    @Override
    public void setIntField(BaseVM vm, DvmObject<?> dvmObject, String signature, int value) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public void setLongField(BaseVM vm, DvmObject<?> dvmObject, DvmField dvmField, long value) {
        this.setLongField(vm, dvmObject, dvmField.getSignature(), value);
    }

    @Override
    public void setLongField(BaseVM vm, DvmObject<?> dvmObject, String signature, long value) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public void setBooleanField(BaseVM vm, DvmObject<?> dvmObject, DvmField dvmField, boolean value) {
        this.setBooleanField(vm, dvmObject, dvmField.getSignature(), value);
    }

    @Override
    public void setBooleanField(BaseVM vm, DvmObject<?> dvmObject, String signature, boolean value) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public void setFloatField(BaseVM vm, DvmObject<?> dvmObject, DvmField dvmField, float value) {
        this.setFloatField(vm, dvmObject, dvmField.getSignature(), value);
    }

    @Override
    public void setFloatField(BaseVM vm, DvmObject<?> dvmObject, String signature, float value) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public void setDoubleField(BaseVM vm, DvmObject<?> dvmObject, DvmField dvmField, double value) {
        this.setDoubleField(vm, dvmObject, dvmField.getSignature(), value);
    }

    @Override
    public void setDoubleField(BaseVM vm, DvmObject<?> dvmObject, String signature, double value) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public DvmObject<?> callObjectMethod(BaseVM vm, DvmObject<?> dvmObject, DvmMethod dvmMethod, VarArg varArg) {
        return this.callObjectMethod(vm, dvmObject, dvmMethod.getSignature(), varArg);
    }

    @Override
    public DvmObject<?> callObjectMethod(BaseVM vm, DvmObject<?> dvmObject, String signature, VarArg varArg) {
        switch (signature) {
            case "java/lang/String->getBytes(Ljava/lang/String;)[B": {
                StringObject string = (StringObject)dvmObject;
                StringObject encoding = (StringObject)varArg.getObjectArg(0);
                System.err.println("string=" + (String)string.getValue() + ", encoding=" + (String)encoding.getValue());
                try {
                    return new ByteArray(vm, ((String)string.getValue()).getBytes((String)encoding.value));
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException(e);
                }
            }
            case "android/content/Context->getPackageManager()Landroid/content/pm/PackageManager;": 
            case "android/app/Activity->getPackageManager()Landroid/content/pm/PackageManager;": {
                return vm.resolveClass("android/content/pm/PackageManager", new DvmClass[0]).newObject(null);
            }
            case "android/content/Context->getApplicationInfo()Landroid/content/pm/ApplicationInfo;": 
            case "android/app/Activity->getApplicationInfo()Landroid/content/pm/ApplicationInfo;": {
                return new ApplicationInfo(vm);
            }
            case "android/app/Application->getPackageName()Ljava/lang/String;": 
            case "android/content/ContextWrapper->getPackageName()Ljava/lang/String;": 
            case "android/app/Activity->getPackageName()Ljava/lang/String;": 
            case "android/content/Context->getPackageName()Ljava/lang/String;": {
                String packageName = vm.getPackageName();
                if (packageName == null) break;
                return new StringObject(vm, packageName);
            }
            case "android/content/pm/PackageManager->getPackageInfo(Ljava/lang/String;I)Landroid/content/pm/PackageInfo;": {
                StringObject packageName = (StringObject)varArg.getObjectArg(0);
                int flags = varArg.getIntArg(1);
                if (log.isDebugEnabled()) {
                    log.debug("getPackageInfo packageName=" + (String)packageName.getValue() + ", flags=0x" + Integer.toHexString(flags));
                }
                return new PackageInfo(vm, (String)packageName.value, flags);
            }
            case "android/content/pm/Signature->toByteArray()[B": {
                if (!(dvmObject instanceof Signature)) break;
                Signature sig = (Signature)dvmObject;
                return new ByteArray(vm, sig.toByteArray());
            }
            case "android/content/pm/Signature->toCharsString()Ljava/lang/String;": {
                if (!(dvmObject instanceof Signature)) break;
                Signature sig = (Signature)dvmObject;
                return new StringObject(vm, sig.toCharsString());
            }
            case "java/lang/Class->getName()Ljava/lang/String;": {
                DvmClass clazz = (DvmClass)dvmObject;
                return new StringObject(vm, clazz.getName());
            }
            case "java/lang/String->getClass()Ljava/lang/Class;": 
            case "java/lang/Integer->getClass()Ljava/lang/Class;": {
                return dvmObject.getObjectType();
            }
            case "java/lang/Class->getClassLoader()Ljava/lang/ClassLoader;": {
                return new ClassLoader(vm, signature);
            }
        }
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public int callIntMethod(BaseVM vm, DvmObject<?> dvmObject, DvmMethod dvmMethod, VarArg varArg) {
        return this.callIntMethod(vm, dvmObject, dvmMethod.getSignature(), varArg);
    }

    @Override
    public int callIntMethod(BaseVM vm, DvmObject<?> dvmObject, String signature, VarArg varArg) {
        switch (signature) {
            case "java/lang/Integer->intValue()I": {
                DvmInteger integer = (DvmInteger)dvmObject;
                return (Integer)integer.value;
            }
            case "java/io/InputStream->read([B)I": {
                try {
                    InputStream inputStream = (InputStream)dvmObject.getValue();
                    ByteArray array = (ByteArray)varArg.getObjectArg(0);
                    return inputStream.read((byte[])array.getValue());
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            case "android/content/pm/Signature->hashCode()I": {
                if (!(dvmObject instanceof Signature)) break;
                Signature sig = (Signature)dvmObject;
                return sig.getHashCode();
            }
        }
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public double callDoubleMethod(BaseVM vm, DvmObject<?> dvmObject, DvmMethod dvmMethod, VarArg varArg) {
        return this.callDoubleMethod(vm, dvmObject, dvmMethod.getSignature(), varArg);
    }

    @Override
    public double callDoubleMethod(BaseVM vm, DvmObject<?> dvmObject, String signature, VarArg varArg) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public void callVoidMethod(BaseVM vm, DvmObject<?> dvmObject, DvmMethod dvmMethod, VarArg varArg) {
        this.callVoidMethod(vm, dvmObject, dvmMethod.getSignature(), varArg);
    }

    @Override
    public void callVoidMethod(BaseVM vm, DvmObject<?> dvmObject, String signature, VarArg varArg) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public void callVoidMethodV(BaseVM vm, DvmObject<?> dvmObject, DvmMethod dvmMethod, VaList vaList) {
        this.callVoidMethodV(vm, dvmObject, dvmMethod.getSignature(), vaList);
    }

    @Override
    public void callVoidMethodV(BaseVM vm, DvmObject<?> dvmObject, String signature, VaList vaList) {
        if ("javax/crypto/Cipher->init(ILjava/security/Key;)V".equals(signature)) {
            Cipher cipher = (Cipher)dvmObject.getValue();
            int opmode = vaList.getIntArg(0);
            Key key = (Key)((DvmObject)vaList.getObjectArg(1)).getValue();
            assert (key != null);
            try {
                cipher.init(opmode, key);
            }
            catch (InvalidKeyException e) {
                throw new IllegalStateException(e);
            }
            return;
        }
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public void setStaticBooleanField(BaseVM vm, DvmClass dvmClass, DvmField dvmField, boolean value) {
        this.setStaticBooleanField(vm, dvmClass, dvmField.getSignature(), value);
    }

    @Override
    public void setStaticBooleanField(BaseVM vm, DvmClass dvmClass, String signature, boolean value) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public void setStaticIntField(BaseVM vm, DvmClass dvmClass, DvmField dvmField, int value) {
        this.setStaticIntField(vm, dvmClass, dvmField.getSignature(), value);
    }

    @Override
    public void setStaticIntField(BaseVM vm, DvmClass dvmClass, String signature, int value) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public void setStaticObjectField(BaseVM vm, DvmClass dvmClass, DvmField dvmField, DvmObject<?> value) {
        this.setStaticObjectField(vm, dvmClass, dvmField.getSignature(), value);
    }

    @Override
    public void setStaticObjectField(BaseVM vm, DvmClass dvmClass, String signature, DvmObject<?> value) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public void setStaticLongField(BaseVM vm, DvmClass dvmClass, DvmField dvmField, long value) {
        this.setStaticLongField(vm, dvmClass, dvmField.getSignature(), value);
    }

    @Override
    public void setStaticLongField(BaseVM vm, DvmClass dvmClass, String signature, long value) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public void setStaticFloatField(BaseVM vm, DvmClass dvmClass, DvmField dvmField, float value) {
        this.setStaticFloatField(vm, dvmClass, dvmField.getSignature(), value);
    }

    @Override
    public void setStaticFloatField(BaseVM vm, DvmClass dvmClass, String signature, float value) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public void setStaticDoubleField(BaseVM vm, DvmClass dvmClass, DvmField dvmField, double value) {
        this.setStaticDoubleField(vm, dvmClass, dvmField.getSignature(), value);
    }

    @Override
    public void setStaticDoubleField(BaseVM vm, DvmClass dvmClass, String signature, double value) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public long getStaticLongField(BaseVM vm, DvmClass dvmClass, DvmField dvmField) {
        return this.getStaticLongField(vm, dvmClass, dvmField.getSignature());
    }

    @Override
    public long getStaticLongField(BaseVM vm, DvmClass dvmClass, String signature) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public DvmObject<?> toReflectedMethod(BaseVM vm, DvmClass dvmClass, DvmMethod dvmMethod) {
        return this.toReflectedMethod(vm, dvmClass, dvmMethod.getSignature());
    }

    @Override
    public DvmObject<?> toReflectedMethod(BaseVM vm, DvmClass dvmClass, String signature) {
        throw new UnsupportedOperationException(signature);
    }

    @Override
    public boolean acceptMethod(DvmClass dvmClass, String signature, boolean isStatic) {
        return true;
    }

    @Override
    public boolean acceptField(DvmClass dvmClass, String signature, boolean isStatic) {
        return true;
    }
}

