/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm;

import com.github.unidbg.Emulator;
import com.github.unidbg.Module;
import com.github.unidbg.Symbol;
import com.github.unidbg.linux.android.dvm.BaseVM;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DalvikModule {
    private static final Log log = LogFactory.getLog(DalvikModule.class);
    private final BaseVM vm;
    private final Module module;

    DalvikModule(BaseVM vm, Module module) {
        this.vm = vm;
        this.module = module;
    }

    public Module getModule() {
        return this.module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callJNI_OnLoad(Emulator<?> emulator) {
        Symbol onLoad2 = this.module.findSymbolByName("JNI_OnLoad", false);
        if (onLoad2 != null) {
            try {
                long start = System.currentTimeMillis();
                if (log.isDebugEnabled()) {
                    log.debug("Call [" + this.module.name + "]JNI_OnLoad: 0x" + Long.toHexString(onLoad2.getAddress()));
                }
                Number ret = onLoad2.call(emulator, this.vm.getJavaVM(), null);
                int version = ret.intValue();
                if (log.isDebugEnabled()) {
                    log.debug("Call [" + this.module.name + "]JNI_OnLoad finished: version=0x" + Integer.toHexString(version) + ", offset=" + (System.currentTimeMillis() - start) + "ms");
                }
                this.vm.checkVersion(version);
            }
            finally {
                this.vm.deleteLocalRefs();
            }
        }
    }
}

