/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm;

import com.github.unidbg.Emulator;
import com.github.unidbg.linux.android.dvm.BaseVM;
import com.github.unidbg.linux.android.dvm.DvmMethod;
import com.github.unidbg.linux.android.dvm.Shorty;
import com.github.unidbg.linux.android.dvm.VaList;
import com.github.unidbg.pointer.UnidbgPointer;
import com.sun.jna.Pointer;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class VaList64
extends VaList {
    private static final Log log = LogFactory.getLog(VaList64.class);

    VaList64(Emulator<?> emulator, BaseVM vm, UnidbgPointer va_list, DvmMethod method) {
        super(vm, method);
        long base_p = va_list.getLong(0L);
        long base_integer = va_list.getLong(8L);
        long base_float = va_list.getLong(16L);
        int mask_integer = va_list.getInt(24L);
        int mask_float = va_list.getInt(28L);
        block7: for (Shorty shorty : this.shorties) {
            switch (shorty.getType()) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    UnidbgPointer pointer;
                    if ((mask_integer & Integer.MIN_VALUE) != 0) {
                        if (mask_integer + 8 <= 0) {
                            pointer = UnidbgPointer.pointer(emulator, base_integer + (long)mask_integer);
                            mask_integer += 8;
                        } else {
                            pointer = UnidbgPointer.pointer(emulator, base_p);
                            mask_integer += 8;
                            base_p = base_p + 11L & 0xFFFFFFFFFFFFFFF8L;
                        }
                    } else {
                        pointer = UnidbgPointer.pointer(emulator, base_p);
                        base_p = base_p + 11L & 0xFFFFFFFFFFFFFFF8L;
                    }
                    assert (pointer != null);
                    this.args.add(((Pointer)pointer).getInt(0L));
                    continue block7;
                }
                case 'D': {
                    UnidbgPointer pointer;
                    if ((mask_float & Integer.MIN_VALUE) != 0) {
                        if (mask_float + 16 <= 0) {
                            pointer = UnidbgPointer.pointer(emulator, base_float + (long)mask_float);
                            mask_float += 16;
                        } else {
                            pointer = UnidbgPointer.pointer(emulator, base_p);
                            mask_float += 16;
                            base_p = base_p + 15L & 0xFFFFFFFFFFFFFFF8L;
                        }
                    } else {
                        pointer = UnidbgPointer.pointer(emulator, base_p);
                        base_p = base_p + 15L & 0xFFFFFFFFFFFFFFF8L;
                    }
                    assert (pointer != null);
                    this.args.add(((Pointer)pointer).getDouble(0L));
                    continue block7;
                }
                case 'F': {
                    UnidbgPointer pointer;
                    if ((mask_float & Integer.MIN_VALUE) != 0) {
                        if (mask_float + 16 <= 0) {
                            pointer = UnidbgPointer.pointer(emulator, base_float + (long)mask_float);
                            mask_float += 16;
                        } else {
                            pointer = UnidbgPointer.pointer(emulator, base_p);
                            mask_float += 16;
                            base_p = base_p + 15L & 0xFFFFFFFFFFFFFFF8L;
                        }
                    } else {
                        pointer = UnidbgPointer.pointer(emulator, base_p);
                        base_p = base_p + 15L & 0xFFFFFFFFFFFFFFF8L;
                    }
                    assert (pointer != null);
                    this.args.add(Float.valueOf((float)((Pointer)pointer).getDouble(0L)));
                    continue block7;
                }
                case 'J': {
                    UnidbgPointer pointer;
                    if ((mask_integer & Integer.MIN_VALUE) != 0) {
                        if (mask_integer + 8 <= 0) {
                            pointer = UnidbgPointer.pointer(emulator, base_integer + (long)mask_integer);
                            mask_integer += 8;
                        } else {
                            pointer = UnidbgPointer.pointer(emulator, base_p);
                            mask_integer += 8;
                            base_p = base_p + 15L & 0xFFFFFFFFFFFFFFF8L;
                        }
                    } else {
                        pointer = UnidbgPointer.pointer(emulator, base_p);
                        base_p = base_p + 15L & 0xFFFFFFFFFFFFFFF8L;
                    }
                    assert (pointer != null);
                    this.args.add(((Pointer)pointer).getLong(0L));
                    continue block7;
                }
                case 'L': {
                    UnidbgPointer pointer;
                    if ((mask_integer & Integer.MIN_VALUE) != 0) {
                        if (mask_integer + 8 <= 0) {
                            pointer = UnidbgPointer.pointer(emulator, base_integer + (long)mask_integer);
                            mask_integer += 8;
                        } else {
                            pointer = UnidbgPointer.pointer(emulator, base_p);
                            mask_integer += 8;
                            base_p = base_p + 15L & 0xFFFFFFFFFFFFFFF8L;
                        }
                    } else {
                        pointer = UnidbgPointer.pointer(emulator, base_p);
                        base_p = base_p + 15L & 0xFFFFFFFFFFFFFFF8L;
                    }
                    assert (pointer != null);
                    this.args.add(((Pointer)pointer).getInt(0L));
                    continue block7;
                }
                default: {
                    throw new IllegalStateException("c=" + shorty.getType());
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("VaList64 base_p=0x" + Long.toHexString(base_p) + ", base_integer=0x" + Long.toHexString(base_integer) + ", base_float=0x" + Long.toHexString(base_float) + ", mask_integer=0x" + Long.toHexString((long)mask_integer & 0xFFFFFFFFL) + ", mask_float=0x" + Long.toHexString((long)mask_float & 0xFFFFFFFFL) + ", args=" + method.args + ", shorty=" + Arrays.toString(this.shorties));
        }
    }
}

