/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm.array;

import com.github.unidbg.linux.android.dvm.Array;
import com.github.unidbg.linux.android.dvm.DvmObject;
import com.github.unidbg.linux.android.dvm.StringObject;
import com.github.unidbg.linux.android.dvm.VM;
import com.github.unidbg.linux.android.dvm.array.BaseArray;
import java.util.Arrays;

public class ArrayObject
extends BaseArray<DvmObject<?>[]>
implements Array<DvmObject<?>[]> {
    public static ArrayObject newStringArray(VM vm, String ... strings) {
        StringObject[] objects = new StringObject[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            String str = strings[i];
            if (str == null) continue;
            objects[i] = new StringObject(vm, str);
        }
        return new ArrayObject(objects);
    }

    public ArrayObject(DvmObject<?> ... value) {
        super(null, value);
    }

    @Override
    public int length() {
        return ((DvmObject[])this.value).length;
    }

    @Override
    public void setData(int start, DvmObject<?>[] data2) {
        System.arraycopy(data2, 0, this.value, start, data2.length);
    }

    @Override
    public String toString() {
        return Arrays.toString((Object[])this.value);
    }
}

