/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.file;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.file.linux.BaseAndroidFileIO;
import com.github.unidbg.file.linux.StatStructure;
import com.github.unidbg.utils.Inspector;
import com.sun.jna.Pointer;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ByteArrayFileIO
extends BaseAndroidFileIO {
    private static final Log log = LogFactory.getLog(ByteArrayFileIO.class);
    protected final byte[] bytes;
    protected final String path;
    private int pos;

    public ByteArrayFileIO(int oflags, String path, byte[] bytes) {
        super(oflags);
        this.path = path;
        this.bytes = bytes;
    }

    @Override
    public void close() {
        this.pos = 0;
    }

    @Override
    public int write(byte[] data2) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int pread(Backend backend, Pointer buffer, int count, long offset) {
        int pos = this.pos;
        try {
            this.pos = (int)offset;
            int n = this.read(backend, buffer, count);
            return n;
        }
        finally {
            this.pos = pos;
        }
    }

    @Override
    public int read(Backend backend, Pointer buffer, int count) {
        if (this.pos >= this.bytes.length) {
            return 0;
        }
        int remain = this.bytes.length - this.pos;
        if (count > remain) {
            count = remain;
        }
        buffer.write(0L, this.bytes, this.pos, count);
        if (log.isDebugEnabled()) {
            log.debug(Inspector.inspectString(Arrays.copyOfRange(this.bytes, this.pos, this.pos + count), "read path=" + this.path + ", fp=" + this.pos + ", _count=" + count + ", length=" + this.bytes.length + ", buffer=" + buffer));
        }
        this.pos += count;
        return count;
    }

    @Override
    public int lseek(int offset, int whence) {
        switch (whence) {
            case 0: {
                this.pos = offset;
                return this.pos;
            }
            case 1: {
                this.pos += offset;
                return this.pos;
            }
            case 2: {
                this.pos = this.bytes.length + offset;
                return this.pos;
            }
        }
        return super.lseek(offset, whence);
    }

    @Override
    public int fstat(Emulator<?> emulator, StatStructure stat) {
        stat.st_dev = 1L;
        stat.st_mode = 32768;
        stat.st_uid = 0;
        stat.st_gid = 0;
        stat.st_size = this.bytes.length;
        stat.st_blksize = emulator.getPageAlign();
        stat.st_blocks = (this.bytes.length + emulator.getPageAlign() - 1) / emulator.getPageAlign();
        stat.st_ino = 1L;
        stat.setLastModification(System.currentTimeMillis());
        stat.pack();
        return 0;
    }

    @Override
    protected byte[] getMmapData(long addr, int offset, int length) {
        if (offset == 0 && length == this.bytes.length) {
            return this.bytes;
        }
        byte[] data2 = new byte[length];
        System.arraycopy(this.bytes, offset, data2, 0, data2.length);
        return data2;
    }

    @Override
    public int ioctl(Emulator<?> emulator, long request, long argp) {
        return 0;
    }

    public String toString() {
        return this.path;
    }
}

