/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.file;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.ARM;
import com.github.unidbg.file.UnidbgFileFilter;
import com.github.unidbg.file.linux.BaseAndroidFileIO;
import com.github.unidbg.file.linux.StatStructure;
import com.github.unidbg.linux.struct.Dirent;
import com.github.unidbg.linux.struct.StatFS;
import com.sun.jna.Pointer;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DirectoryFileIO
extends BaseAndroidFileIO {
    private final String path;
    private final List<DirectoryEntry> entries;

    private static DirectoryEntry[] createEntries(File dir) {
        ArrayList<DirectoryEntry> list = new ArrayList<DirectoryEntry>();
        Object[] files = dir.listFiles(new UnidbgFileFilter());
        if (files != null) {
            Arrays.sort(files);
            for (Object file : files) {
                list.add(new DirectoryEntry(((File)file).isFile(), ((File)file).getName()));
            }
        }
        return list.toArray(new DirectoryEntry[0]);
    }

    public DirectoryFileIO(int oflags, String path, File dir) {
        this(oflags, path, DirectoryFileIO.createEntries(dir));
    }

    public DirectoryFileIO(int oflags, String path, DirectoryEntry ... entries) {
        super(oflags);
        this.path = path;
        this.entries = new ArrayList<DirectoryEntry>();
        this.entries.add(new DirectoryEntry(false, "."));
        this.entries.add(new DirectoryEntry(false, ".."));
        if (entries != null) {
            Collections.addAll(this.entries, entries);
        }
    }

    @Override
    public int getdents64(Pointer dirp, int size) {
        DirectoryEntry entry;
        byte[] data2;
        long d_reclen;
        int offset = 0;
        Iterator<DirectoryEntry> iterator = this.entries.iterator();
        while (iterator.hasNext() && (long)offset + (d_reclen = ARM.alignSize((data2 = (entry = iterator.next()).name.getBytes(StandardCharsets.UTF_8)).length + 24, 8L)) < (long)size) {
            Dirent dirent = new Dirent(dirp.share(offset));
            dirent.d_ino = 0L;
            dirent.d_off = 0L;
            dirent.d_reclen = (short)d_reclen;
            dirent.d_type = entry.type.type;
            dirent.d_name = Arrays.copyOf(data2, data2.length + 1);
            dirent.pack();
            offset = (int)((long)offset + d_reclen);
            iterator.remove();
        }
        return offset;
    }

    @Override
    public void close() {
    }

    @Override
    public int fstat(Emulator<?> emulator, StatStructure stat) {
        stat.st_mode = 16384;
        stat.st_dev = 0L;
        stat.st_size = 0L;
        stat.st_blksize = 0;
        stat.st_ino = 0L;
        stat.pack();
        return 0;
    }

    public String toString() {
        return this.path;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public int statfs(StatFS statFS) {
        statFS.setType(61267);
        statFS.setBlockSize(4096);
        statFS.f_blocks = 3290543L;
        statFS.f_bfree = 2840419L;
        statFS.f_bavail = 2840419L;
        statFS.f_files = 838832L;
        statFS.f_ffree = 834862L;
        statFS.f_fsid = new int[]{-748642328, 77008235};
        statFS.setNameLen(255);
        statFS.setFrSize(4096);
        statFS.setFlags(1062);
        statFS.pack();
        return 0;
    }

    public static class DirectoryEntry {
        private final DirentType type;
        private final String name;

        public DirectoryEntry(boolean isFile, String name) {
            this(isFile ? DirentType.DT_REG : DirentType.DT_DIR, name);
        }

        public DirectoryEntry(DirentType type, String name) {
            this.type = type;
            this.name = name;
        }
    }

    public static enum DirentType {
        DT_FIFO(1),
        DT_CHR(2),
        DT_DIR(4),
        DT_BLK(6),
        DT_REG(8),
        DT_LNK(10),
        DT_SOCK(12),
        DT_WHT(14);

        private final byte type;

        private DirentType(int type) {
            this.type = (byte)type;
        }
    }
}

