/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.file;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.linux.file.DriverFileIO;
import com.sun.jna.Pointer;
import java.util.concurrent.ThreadLocalRandom;

public class RandomFileIO
extends DriverFileIO {
    public RandomFileIO(Emulator<?> emulator, String path) {
        super(emulator, 0, path);
    }

    @Override
    public int read(Backend backend, Pointer buffer, int count) {
        int total = 0;
        byte[] buf = new byte[Math.min(4096, count)];
        this.randBytes(buf);
        Pointer pointer = buffer;
        while (total < count) {
            int read = Math.min(buf.length, count - total);
            pointer.write(0L, buf, 0, read);
            total += read;
            pointer = pointer.share(read);
        }
        return total;
    }

    protected void randBytes(byte[] bytes) {
        ThreadLocalRandom.current().nextBytes(bytes);
    }
}

