/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.signal;

import com.github.unidbg.Emulator;
import com.github.unidbg.linux.signal.SigAction32;
import com.github.unidbg.linux.signal.SigAction64;
import com.github.unidbg.pointer.UnidbgStructure;
import com.sun.jna.Pointer;

public abstract class SigAction
extends UnidbgStructure {
    private static final int SA_SIGINFO = 4;

    public static SigAction create(Emulator<?> emulator, Pointer ptr) {
        if (ptr == null) {
            return null;
        }
        SigAction action = emulator.is32Bit() ? new SigAction32(ptr) : new SigAction64(ptr);
        action.unpack();
        return action;
    }

    public abstract long getSaHandler();

    public abstract void setSaHandler(long var1);

    public abstract long getSaRestorer();

    public abstract void setSaRestorer(long var1);

    public boolean needSigInfo() {
        return (this.getFlags() & 4) != 0;
    }

    public abstract long getMask();

    public abstract void setMask(long var1);

    public abstract int getFlags();

    public abstract void setFlags(int var1);

    public SigAction(Pointer p) {
        super(p);
    }
}

