/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.thread;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.ArmSvc;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.unix.ThreadJoinVisitor;
import com.sun.jna.Pointer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import keystone.Keystone;
import keystone.KeystoneArchitecture;
import keystone.KeystoneEncoded;
import keystone.KeystoneMode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ClonePatcher32
extends ArmSvc {
    private static final Log log = LogFactory.getLog(ClonePatcher32.class);
    private final ThreadJoinVisitor visitor;
    private final AtomicLong value_ptr;
    private int threadId;

    public ClonePatcher32(ThreadJoinVisitor visitor, AtomicLong value_ptr) {
        this.visitor = visitor;
        this.value_ptr = value_ptr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long handle(Emulator<?> emulator) {
        Object context = emulator.getContext();
        UnidbgPointer pthread_start = context.getPointerArg(0);
        UnidbgPointer child_stack = context.getPointerArg(1);
        int flags = context.getIntArg(2);
        UnidbgPointer thread = context.getPointerArg(3);
        Pointer start_routine = ((Pointer)thread).getPointer(48L);
        Pointer arg = ((Pointer)thread).getPointer(52L);
        log.info("clone start_routine=" + start_routine + ", child_stack=" + child_stack + ", flags=0x" + Integer.toHexString(flags) + ", arg=" + arg + ", pthread_start=" + pthread_start);
        Backend backend = emulator.getBackend();
        boolean join = this.visitor == null || this.visitor.canJoin(start_routine, ++this.threadId);
        UnidbgPointer pointer = UnidbgPointer.register(emulator, 12);
        try {
            pointer = pointer.share(-4L, 0L);
            pointer.setInt(0L, this.threadId);
            if (join) {
                pointer = pointer.share(-4L, 0L);
                pointer.setPointer(0L, start_routine);
                pointer = pointer.share(-4L, 0L);
                pointer.setPointer(0L, arg);
            }
            pointer = pointer.share(-4L, 0L);
            pointer.setInt(0L, join ? 1 : 0);
        }
        finally {
            backend.reg_write(12, pointer.peer);
        }
        return 0L;
    }

    @Override
    public UnidbgPointer onRegister(SvcMemory svcMemory, int svcNumber) {
        try (Keystone keystone = new Keystone(KeystoneArchitecture.Arm, KeystoneMode.Arm);){
            KeystoneEncoded encoded = keystone.assemble(Arrays.asList("push {r4-r7, lr}", "svc #0x" + Integer.toHexString(svcNumber), "pop {r7}", "cmp r7, #0", "popeq {r0, r4-r7, pc}", "pop {r0, ip}", "mov r7, #0", "mov r5, #0x" + Integer.toHexString(34918), "mov r4, #0x" + Integer.toHexString(svcNumber), "svc #0", "blx ip", "mov r7, #0", "mov r5, #0x" + Integer.toHexString(34952), "mov r4, #0x" + Integer.toHexString(svcNumber), "svc #0", "pop {r0, r4-r7, pc}"));
            byte[] code = encoded.getMachineCode();
            UnidbgPointer pointer = svcMemory.allocate(code.length, this.getClass().getSimpleName());
            pointer.write(code);
            UnidbgPointer unidbgPointer = pointer;
            return unidbgPointer;
        }
    }

    @Override
    public void handlePreCallback(Emulator<?> emulator) {
        if (this.visitor.isSaveContext()) {
            emulator.pushContext(4);
        }
    }

    @Override
    public void handlePostCallback(Emulator<?> emulator) {
        super.handlePostCallback(emulator);
        this.value_ptr.set(emulator.getContext().getIntArg(0));
    }
}

