/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.thread;

import com.github.unidbg.Emulator;
import com.github.unidbg.linux.thread.AndroidWaiter;
import com.sun.jna.Pointer;

public abstract class FutexWaiter
extends AndroidWaiter {
    private final Pointer uaddr;
    private final int val;
    protected boolean wokenUp;

    public FutexWaiter(Pointer uaddr, int val) {
        this.uaddr = uaddr;
        this.val = val;
    }

    @Override
    public boolean canDispatch() {
        if (this.wokenUp) {
            return true;
        }
        int old = this.uaddr.getInt(0L);
        return old != this.val;
    }

    @Override
    public final void onContinueRun(Emulator<?> emulator) {
        super.onContinueRun(emulator);
        if (this.wokenUp) {
            emulator.getBackend().reg_write(emulator.is32Bit() ? 66 : 199, 0);
        } else {
            this.onContinueRunInternal(emulator);
        }
    }

    protected void onContinueRunInternal(Emulator<?> emulator) {
    }

    public boolean wakeUp(Pointer uaddr) {
        if (this.uaddr.equals(uaddr)) {
            this.wokenUp = true;
            return true;
        }
        return false;
    }
}

