/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.unpack;

import com.github.unidbg.Emulator;
import com.github.unidbg.Module;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.backend.UnHook;
import com.github.unidbg.arm.backend.WriteHook;
import com.github.unidbg.memory.MemRegion;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.spi.InitFunctionListener;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.commons.io.FileUtils;

public class ElfUnpacker {
    private final byte[] elfFile;
    private final File outFile;
    private final ByteBuffer buffer;
    private boolean dirty;

    public ElfUnpacker(byte[] elfFile, File outFile) {
        this.elfFile = elfFile;
        this.outFile = outFile;
        if (outFile.isDirectory()) {
            throw new IllegalStateException("isDirectory");
        }
        this.buffer = ByteBuffer.allocate(8);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public void register(final Emulator<?> emulator, final Module module) {
        module.setInitFunctionListener(new InitFunctionListener(){

            @Override
            public void onPreCallInitFunction(Module module, long initFunction, int index) {
                ElfUnpacker.this.dirty = false;
            }

            @Override
            public void onPostCallInitFunction(Module module, long initFunction, int index) {
                try {
                    if (ElfUnpacker.this.dirty) {
                        System.out.println("Unpack initFunction=" + UnidbgPointer.pointer(emulator, module.base + initFunction));
                        FileUtils.writeByteArrayToFile(ElfUnpacker.this.outFile, ElfUnpacker.this.elfFile);
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
        for (MemRegion region : module.getRegions()) {
            if ((region.perms & 2) != 0 || (region.perms & 4) != 4) continue;
            System.out.println("Begin unpack " + module.name + ": 0x" + Long.toHexString(region.begin) + "-0x" + Long.toHexString(region.end));
            emulator.getBackend().hook_add_new(new WriteHook(){
                private UnHook unHook;

                @Override
                public void hook(Backend backend, long address, int size, long value, Object user) {
                    long offset = address - module.base;
                    int fileOffset = module.virtualMemoryAddressToFileOffset(offset);
                    if (size < 1 || size > 8) {
                        throw new IllegalStateException("size=" + size);
                    }
                    if (fileOffset >= 0) {
                        ElfUnpacker.this.buffer.clear();
                        ElfUnpacker.this.buffer.putLong(value);
                        System.arraycopy(ElfUnpacker.this.buffer.array(), 0, ElfUnpacker.this.elfFile, fileOffset, size);
                        ElfUnpacker.this.dirty = true;
                    }
                }

                @Override
                public void onAttach(UnHook unHook) {
                    this.unHook = unHook;
                }

                @Override
                public void detach() {
                    this.unHook.unhook();
                }
            }, region.begin, region.end, emulator);
        }
    }
}

