/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.spi;

import com.github.unidbg.Emulator;
import com.github.unidbg.Symbol;
import com.github.unidbg.hook.HookListener;
import com.github.unidbg.memory.Memory;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.serialize.Serializable;
import java.io.DataOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Dlfcn
implements HookListener,
Serializable {
    private static final Log log = LogFactory.getLog(Dlfcn.class);
    protected final UnidbgPointer error;

    protected Dlfcn(SvcMemory svcMemory) {
        this.error = svcMemory.allocate(128, "Dlfcn.error");
        assert (this.error != null);
        this.error.setMemory(0L, 128L, (byte)0);
    }

    protected final long dlsym(Emulator<?> emulator, long handle, String symbolName) {
        Memory memory = emulator.getMemory();
        Symbol symbol = memory.dlsym(handle, symbolName);
        if (symbol == null) {
            log.info("Find symbol \"" + symbolName + "\" failed: handle=0x" + Long.toHexString(handle) + ", LR=" + emulator.getContext().getLRPointer());
            this.error.setString(0L, "Find symbol " + symbolName + " failed");
            return 0L;
        }
        return symbol.getAddress();
    }

    @Override
    public void serialize(DataOutput out) {
        throw new UnsupportedOperationException();
    }
}

