/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.thread;

import com.github.unidbg.AbstractEmulator;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.memory.Memory;
import com.github.unidbg.thread.MainTask;

public class Entry
extends MainTask {
    private final long entry;
    private final long sp;

    public Entry(int pid, long entry, long until, long sp) {
        super(pid, until);
        this.entry = entry;
        this.sp = sp;
    }

    @Override
    protected Number run(AbstractEmulator<?> emulator) {
        Backend backend = emulator.getBackend();
        Memory memory = emulator.getMemory();
        memory.setStackPoint(this.sp);
        backend.reg_write(emulator.is64Bit() ? 2 : 10, this.until);
        return emulator.emulate(this.entry, this.until);
    }

    @Override
    public String toThreadString() {
        return "Executable entry=0x" + Long.toHexString(this.entry) + ", sp=0x" + Long.toHexString(this.sp);
    }
}

