/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.virtualmodule.android;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.Arm64Svc;
import com.github.unidbg.arm.ArmSvc;
import com.github.unidbg.linux.android.dvm.VM;
import com.github.unidbg.linux.android.dvm.api.Bitmap;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.utils.Inspector;
import com.github.unidbg.virtualmodule.VirtualModule;
import com.sun.jna.Pointer;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JniGraphics
extends VirtualModule<VM> {
    private static final Log log = LogFactory.getLog(JniGraphics.class);
    private static final int ANDROID_BITMAP_FORMAT_RGBA_8888 = 1;
    private static final int ANDROID_BITMAP_RESULT_SUCCESS = 0;

    public JniGraphics(Emulator<?> emulator, VM vm) {
        super(emulator, vm, "libjnigraphics.so");
    }

    @Override
    protected void onInitialize(Emulator<?> emulator, final VM vm, Map<String, UnidbgPointer> symbols) {
        boolean is64Bit = emulator.is64Bit();
        SvcMemory svcMemory = emulator.getSvcMemory();
        symbols.put("AndroidBitmap_getInfo", svcMemory.registerSvc(is64Bit ? new Arm64Svc(){

            @Override
            public long handle(Emulator<?> emulator) {
                return JniGraphics.getInfo(emulator, vm);
            }
        } : new ArmSvc(){

            @Override
            public long handle(Emulator<?> emulator) {
                return JniGraphics.getInfo(emulator, vm);
            }
        }));
        symbols.put("AndroidBitmap_lockPixels", svcMemory.registerSvc(is64Bit ? new Arm64Svc(){

            @Override
            public long handle(Emulator<?> emulator) {
                return JniGraphics.lockPixels(emulator, vm);
            }
        } : new ArmSvc(){

            @Override
            public long handle(Emulator<?> emulator) {
                return JniGraphics.lockPixels(emulator, vm);
            }
        }));
        symbols.put("AndroidBitmap_unlockPixels", svcMemory.registerSvc(is64Bit ? new Arm64Svc(){

            @Override
            public long handle(Emulator<?> emulator) {
                return JniGraphics.unlockPixels(emulator, vm);
            }
        } : new ArmSvc(){

            @Override
            public long handle(Emulator<?> emulator) {
                return JniGraphics.unlockPixels(emulator, vm);
            }
        }));
    }

    private static long getInfo(Emulator<?> emulator, VM vm) {
        Object context = emulator.getContext();
        UnidbgPointer env = context.getPointerArg(0);
        UnidbgPointer jbitmap = context.getPointerArg(1);
        UnidbgPointer info = context.getPointerArg(2);
        Bitmap bitmap = (Bitmap)vm.getObject(jbitmap.toIntPeer());
        BufferedImage image = (BufferedImage)bitmap.getValue();
        if (log.isDebugEnabled()) {
            log.debug("AndroidBitmap_getInfo env=" + env + ", width=" + image.getWidth() + ", height=" + image.getHeight() + ", stride=" + image.getWidth() * 4 + ", info=" + info);
        }
        ((Pointer)info).setInt(0L, image.getWidth());
        ((Pointer)info).setInt(4L, image.getHeight());
        ((Pointer)info).setInt(8L, image.getWidth() * 4);
        ((Pointer)info).setInt(12L, 1);
        ((Pointer)info).setInt(16L, 0);
        return 0L;
    }

    private static long lockPixels(Emulator<?> emulator, VM vm) {
        Object context = emulator.getContext();
        UnidbgPointer env = context.getPointerArg(0);
        UnidbgPointer jbitmap = context.getPointerArg(1);
        UnidbgPointer addrPtr = context.getPointerArg(2);
        Bitmap bitmap = (Bitmap)vm.getObject(jbitmap.toIntPeer());
        BufferedImage image = (BufferedImage)bitmap.getValue();
        if (image.getType() != 6) {
            throw new IllegalStateException("image type=" + image.getType());
        }
        if (addrPtr != null) {
            ByteBuffer buffer = ByteBuffer.allocate(image.getWidth() * image.getHeight() * 4);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            for (int y = 0; y < image.getHeight(); ++y) {
                for (int x = 0; x < image.getWidth(); ++x) {
                    int rgb = image.getRGB(x, y);
                    buffer.putInt((rgb >> 24 & 0xFF) << 24 | (rgb & 0xFF) << 16 | (rgb >> 8 & 0xFF) << 8 | rgb >> 16 & 0xFF);
                }
            }
            Pointer pointer = bitmap.lockPixels(emulator, image, buffer);
            ((Pointer)addrPtr).setPointer(0L, pointer);
            if (log.isDebugEnabled()) {
                log.debug(Inspector.inspectString(buffer.array(), "AndroidBitmap_lockPixels buffer=" + buffer));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("AndroidBitmap_lockPixels env=" + env + ", bitmap=" + bitmap + ", addrPtr=" + addrPtr);
        }
        return 0L;
    }

    private static long unlockPixels(Emulator<?> emulator, VM vm) {
        Object context = emulator.getContext();
        UnidbgPointer env = context.getPointerArg(0);
        UnidbgPointer jbitmap = context.getPointerArg(1);
        Bitmap bitmap = (Bitmap)vm.getObject(jbitmap.toIntPeer());
        bitmap.unlockPixels();
        if (log.isDebugEnabled()) {
            log.debug("AndroidBitmap_unlockPixels env=" + env + ", bitmap=" + bitmap);
        }
        return 0L;
    }
}

