/*
 * Decompiled with CFR 0.152.
 */
package de.fearlesstobi.demangler.ast;

import de.fearlesstobi.demangler.ast.BaseNode;
import de.fearlesstobi.demangler.ast.NodeArray;
import de.fearlesstobi.demangler.ast.NodeType;
import java.io.StringWriter;

public class NewExpression
extends BaseNode {
    private final NodeArray expressions;
    private final BaseNode typeNode;
    private final NodeArray initializers;
    private final boolean isGlobal;
    private final boolean isArrayExpression;

    public NewExpression(NodeArray expressions, BaseNode typeNode, NodeArray initializers, boolean isGlobal, boolean isArrayExpression) {
        super(NodeType.NewExpression);
        this.expressions = expressions;
        this.typeNode = typeNode;
        this.initializers = initializers;
        this.isGlobal = isGlobal;
        this.isArrayExpression = isArrayExpression;
    }

    @Override
    public void printLeft(StringWriter writer) {
        if (this.isGlobal) {
            writer.write("::operator ");
        }
        writer.write("new ");
        if (this.isArrayExpression) {
            writer.write("[] ");
        }
        if (!this.expressions.nodes.isEmpty()) {
            writer.write("(");
            this.expressions.print(writer);
            writer.write(")");
        }
        this.typeNode.print(writer);
        if (!this.initializers.nodes.isEmpty()) {
            writer.write("(");
            this.initializers.print(writer);
            writer.write(")");
        }
    }
}

